# $Header: diskErrors.pl 24-sep-2003.16:20:17 vnukal Exp $
#
# diskErrors.pl
# 
# Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      diskErrors.pl - uses the iostat -e command to collect disk errors
#
#    DESCRIPTION
#      This metric actually collects disk device error summary statistics. The 
#      total errors, hard errors, soft errors and transport errors are collected
#      via iostat -e. If there are no errors for that device, that is the total
#      errors is zero, then that device row is ignored.
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    vnukal      09/24/03 - \n add 
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    dmshah      05/23/02 - dmshah_add_support_metrics
#    dmshah      05/23/02 - Correcting the error message
#    dmshah      05/16/02 - Creation
#

@deviceList = ();

@deviceList = `/usr/bin/iostat -e`
              or die "em_error=Failed to run iostat -e \n";

# Shift twice to exclude the headers ....
shift @deviceList;
shift @deviceList;

foreach $deviceRow (@deviceList)
{
    ($device, $softErrors, $hardErrors, $transportErrors, $total) = split(" ", $deviceRow );

    if ($total <= 0)
    {
        # Skip the device rows if there are no errors
        next;
    }
    else
    {
       print "em_result=$device|$softErrors|$hardErrors|$transportErrors|$total\n";
    }
}
