#
# $Header: emdiscoveryhelper.pm 22-jan-2008.18:18:12 apenmets Exp $
#
# emdiscoveryhelper.pm
#
# Copyright (c) 2002, 2008, Oracle. All rights reserved.  
#
#    NAME
#      emdiscoveryhelper.pm - helper routines for discovery scripts.
#
#    DESCRIPTION
#    Reads Oui inventory to gather info about oracle products. Provides
#    a set of methods that can be used by various discovery scripts.
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       apenmets 01/22/08 - branch to st_emagent_10.2.0.4.1db11
#       apenmets 01/04/08 - Updating changes from stpl_emdb_main_gen branch
#       amathur  10/19/07 - correct pattern
#       amathur  10/18/07 - bug 6509752
#       kduvvuri 08/15/05 - fix emagentSDK.jar path. 
#       kduvvuri 08/12/05 - fix 4551263. 
#       kduvvuri 07/25/05 - fix 4510519 - packaging issues. 
#       kduvvuri 06/05/05 - kduvvuri_bug-4225469
#       kduvvuri 06/03/05 - put more comments about the useage. 
#       kduvvuri 06/02/05 - review comments. 
#       kduvvuri 05/25/05 - fix the example. 
#       kduvvuri 05/20/05 - add getInventoryLocs. 
#       kduvvuri 05/10/05 - more dev. 
#       kduvvuri 05/05/2005  - created.
#

package emdiscoveryhelper;

use Exporter;
@ISA = ('Exporter');
@EXPORT_OK = ('getOracleHomes','getProductsForOracleHome', 
              'getOracleHomesForProduct','getJavaHome','getInventoryLocations');

my $oraHome = $ENV{'ORACLE_HOME'};

require "emdcommon.pm";
my $osType = emdcommon::get_osType();
my $cpSep = ":";

if($osType eq "WIN")
{
  $cpSep = ";";
}

my $LOG_CATEGORY = "EM_DISCOVERY_HELPER: ";

sub getJavaHome
{
  # use java from 'appropriate' location
  my $JAVA_HOME="";

  $JAVA_HOME="$oraHome/jdk";

die "Cannot determine JAVA_HOME\n" if (($JAVA_HOME eq "") || (! -e "$JAVA_HOME/bin"));

   return $JAVA_HOME;
}

#The function 'getOracleHomes' returns a  reference to an array consisting of 
#oracle homes read from OUI.
#Typical useage:
# use emdiscoveryhelper('getOracleHomes')
# $oraclehomes = getOracleHomes();
# $numHomes=@$oraclehomes;
# for ( $i = 0; $i < $numHomes; $i++ ) {
#    print "$oraclehomes->[$i] \n";
# }

sub getOracleHomes
{
 #print "getOracleHomes called\n";
 return getInfoFromInventory("getorahomes");
}

#returns a reference to an array consisting of products for oracle home
#This function expects oracle home as an argument..
sub getProductsForOracleHome
{
  $numArgs = scalar(@_);
  if ( $numArgs != 1 ) 
  {
    die "Must specify oracleHome  as an argument to geOracleHomesForProduct";
  }
  $oh = $_[0];
  return getInfoFromInventory("getprodsforoh","$oh");
}

#returns a reference to an array consisting of oracle homes for product.
#This function expects oui component name as an argument.
sub getOracleHomesForProduct
{
  $numArgs = scalar(@_);
  if ( $numArgs != 1 ) 
  {
    die "Must specify product name as an argument to getOracleHomesForProduct";
  }
  $oh = $_[0];
  emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY getOracleHomesForProduct called");
  return getInfoFromInventory("getohsforprod", "$oh");
}


#returns a reference to an array containing an array of strings representing
#inventory locations.
sub getInventoryLocations
{
 emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY getInventoryLocations called");
 return getInfoFromInventory("getInvLocs");
}

sub getInfoFromInventory
{
  $option = $_[0];
  emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY processing option $option");
  my $savePath = $ENV{PATH};

  if($osType eq "WIN")
  {
    $ENV{PATH} = "$oraHome/oui/lib/win32\;$savePath";
  }

  $JAVA_HOME = getJavaHome();

  if (isJDKHybridOnPlatform())
  {
    open (HOMES_READER, "$JAVA_HOME/bin/java  -d64 -DinvPtr=$ENV{invPtr} -DecmInvLoc=$ENV{ecmInvLoc} -DoracleHome=$ENV{oracleHome} -cp $oraHome/jlib/emConfigInstall.jar$cpSep$oraHome/jlib/share.jar$cpSep$oraHome/oui/jlib/OraInstaller.jar$cpSep$oraHome/jlib/srvm.jar$cpSep$oraHome/sysman/jlib/emcoreAgent.jar$cpSep$oraHome/sysman/jlib/emagentSDK.jar oracle.sysman.emSDK.emd.conf.InventoryLoader @_ |");
  }
  else
  {
    open (HOMES_READER, "$JAVA_HOME/bin/java  -DinvPtr=$ENV{invPtr} -DecmInvLoc=$ENV{ecmInvLoc} -DoracleHome=$ENV{oracleHome} -cp $oraHome/jlib/emConfigInstall.jar$cpSep$oraHome/jlib/share.jar$cpSep$oraHome/oui/jlib/OraInstaller.jar$cpSep$oraHome/jlib/srvm.jar$cpSep$oraHome/sysman/jlib/emcoreAgent.jar$cpSep$oraHome/sysman/jlib/emagentSDK.jar oracle.sysman.emSDK.emd.conf.InventoryLoader @_ |");
  }


  $ENV{PATH} = $savePath;
  while($homeLine = <HOMES_READER>)
  {
    $homeLine =~ s/^\s*//;
    chomp($homeLine);
    #print "Line read for option $option is $homeLine\n";
    push(@InventoryInfo,$homeLine);
    emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY Add OUI InvInfo=$homeLine for discovery $option" );
  }
  close HOMES_READER;
  return (\@InventoryInfo);

}

sub isJDKHybridOnPlatform()
{
  $myosbuild=$^O;
  emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY PERL_OSBUILD $myosbuild\n");

  $myosarch="none\n";

  if ( $myosbuild eq "solaris" )
  {
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY This is Solaris \n");
      open (MYSOLARCH, "isainfo -kv |");
      $myosarch = <MYSOLARCH> ;
      close MYSOLARCH;
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY SOL_ARCH $myosarch\n");
      if ( $myosarch =~ /64/g )
      {
          emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY This is a 64 bit env \n");
          return 1;
      }

  }

  if ( $myosbuild eq "hpux" )
  {
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY This is HPUX \n");
      open (MYHPUXARCH, "getconf KERNEL_BITS |");
      $myosarch = <MYHPUXARCH> ;
      close MYHPUXARCH;
      emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY HPUX_ARCH $myosarch\n");
      if ( $myosarch =~ /64/g )
      {
         emdcommon::EMD_PERL_DEBUG("$LOG_CATEGORY This is a 64 bit env \n");
         return 1;
      }
  }

  return 0;
}

1;
