# $Header: hostfileaccess.pl 25-jun-2002.10:33:20 xxu Exp $
#
# hostfileaccess.pl
# 
# Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      hostfileaccess.pl 
#
#    DESCRIPTION
#      returns system kernel mem activity as:
#      em_result=<num iget calls per sec>|
#                <num lookuppn calls per sec>|
#                <num 512 byte blocks read by dir search routine per sec>
#
#    NOTES
#      data collected and averaged over a 5 second interval
#
#    MODIFIED   (MM/DD/YY)
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    aaitghez    05/18/01 - sar file access stats.
#    aaitghez    05/18/01 - Creation
# 

$ENV{PATH} = "/usr/bin:/usr/sbin:/usr/local/bin:/local/bin";

# invoke sar
$r = `sar -a 5`
    or die "failed to execute sar";

#parse the return string into lines
@res = split(m/dirbk\/s\n/, $r);
@values = split(m/[\t\s]+/, @res[1]);

print "em_result=@values[1]|@values[2]|@values[3]\n";
