# $Header: hostkernelmem.pl 25-jun-2002.10:33:21 xxu Exp $
#
# hostkernelmem.pl
# 
# Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      hostkernelmem.pl 
#
#    DESCRIPTION
#      returns system kernel mem activity as:
#      em_result=<mem allocation available for small mem reqs in bytes>|
#                <mem allocated to satisfy reqs for small mem amounts>|
#                <small mem requests that failed>|
#                <mem allocation for requests of large amounts of mem, bytes>|
#                <large mem requests that failed>|
#                <mem allocation available for oversized reqs in bytes>|
#                <oversized mem requsts that failed>
#
#    NOTES
#      data collected and averaged over a 5 second interval
#      ONLY AVAILABLE ON SUN.
#      TODO: make available from HP if possible
#
#    MODIFIED   (MM/DD/YY)
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    aaitghez    05/18/01 - sar kernel mem stats.
#    aaitghez    05/18/01 - Creation
# 

$ENV{PATH} = "/usr/bin:/usr/sbin:/usr/local/bin:/local/bin";

# invoke sar
$r = `sar -k 5`
    or die "failed to execute sar";

#parse the return string into lines
@res = split(m/ovsz_alloc.+fail\n/, $r);
print "@res[1]\n";
@values = split(m/[\t\s]+/, @res[1]);

print "em_result=@values[1]|@values[2]|@values[3]|@values[4]|@values[5]|@values[6]|@values[7]|@values[8]\n";

