# $Header: hostpagingactivity.pl 22-feb-2007.04:00:47 aptrived Exp $
#
# hostpagingactivity.pl
# 
# Copyright (c) 2001, 2007, Oracle. All rights reserved.  
#
#    NAME
#      hostpagingactivity.pl 
#
#    DESCRIPTION
#      returns system paging activity
#      em_result=<page out reqs per sec>|<num pages paged out per sec>|
#                <pages placed on free list by page stealing daemon per sec>|
#                <pages scanned by pages stealing daemon per sec>|
#                <igets with page flushes per sec>|
#                <page faults satisfied by memory page reclaim per sec>|
#                <page in reqs per sec>|
#                <page faults from protection errs per sec>|
#                <address translation page faults per sec>|
#                <page faults by software lock requests>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    aptrived    01/29/07 - Bug#5665954, Take care of new version of Linux
#                           kernel which does not have info on inactivedp,
#                           inactivecp
#    aptrived    11/17/06 - Bug#5191263, Taking care for SuSE-9
#    aptrived    02/22/07 - Backport aptrived_bug-5665954 from main
#    sreddy      05/03/05 - bug#4338639 - SuSE Linux changes, refactor code
#    sreddy      05/04/10 - bug#4277824 - Redhat 3.0 Changes
#    qding       03/15/05 - set locale to C 
#    skumar      06/11/04 - /proc/vmstat in 2.6 kernel
#    rrawat      06/03/04 - Bug-3667660
#    skumar      01/08/04 - Creation
# 

exit 1 if ($^O ne "linux");

$ENV{LC_ALL} = "C";
$ENV{PATH} = "/usr/bin:/usr/sbin:/usr/local/bin:/local/bin:/bin";

# pages paged in/out in 1KB blocks units
my $default = "";
my $pgpgin = $default;
my $pgpgout = $default;
my $activepg = $default;
my $inactivedp = $default;
my $inactivecp = $default;

# Reading pgpgin, pgpgout
# First try reading from /proc/vmstat
parseProcVmstat();
# If could not find /proc/vmstat or no info in it, look into /proc/stat
if( $pgpgin==$default && $pgpgout==$default )
{
  parseProcStat();
}
# If still not getting pgpgin and pgpgout, I am giving up

# Reading activepg, inactivedp, inactivecp
#First try from 'sar'
parseSarB();
if( $activepg==$default && $inactivedp==$default && $inactivecp==$default )
{
  # Try reading from /proc/meminfo
  parseProcMeminfo();
}

print "em_result=$pgpgout|$activepg|$inactivedp|$inactivecp|$pgpgin\n";
exit 0;

# Sub-routines starts
sub parseProcVmstat()
{
  if (open(FH, "/proc/vmstat"))
  {
    while (<FH>)
    {
      if (/pgpgin\s+(\d+)/)
      {
        $pgpgin = $1;
      }
      if (/pgpgout\s+(\d+)/)
      {
        $pgpgout = $1;
        last;
      }
    }
  close FH;
  }
}

sub parseProcStat()
{
  if (open(FH, "/proc/stat"))
  {
    while (<FH>)
    {
      if (/page\s+(\d+)\s+(\d+)/)
      {
        $pgpgin = $1;
        $pgpgout = $2;
        last;
      }
    }
    close FH;
  }
  else
  {
    print STDERR "em_error=failed to open /proc/stat\n";
    exit 1;
  }
}

sub parseProcMeminfo()
{
  if (open FH, "/proc/meminfo")
  {
    my $pagesizeB = `getconf PAGE_SIZE` or die "em_error=failed to execute getconf";
    my $pagesizeKB = $pagesizeB/1024;
    while (<FH>)
    {
      if (/^Active:\s+(\d+)/)
      {
        $activepg = $1/$pagesizeKB;
        next;
      }
      if (/Inact_dirty:\s+(\d+)/)
      {
        $inactivedp   = $1/$pagesizeKB;
        next;
      }
      if (/Inact_clean:\s+(\d+)/)
      {
        $inactivecp   = $1/$pagesizeKB;
        last;
      }
    }
    close FH;
  }
  else
  {
    print STDERR "em_error=failed to open /proc/meminfo\n";
    exit 1;
  }
}

sub parseSarB
{
# sar -B
# Bug#5665954, Bug#5191263
# Newer version of sar does not return all values mentioned below
# check sar output to decide if it has all required values or not
# do not populate values if you find number of columns are less
# than what is expected (6), in such case user need to get
# $activepg info from /proc/meminfo and $inactivedp, $inactivecp
# will not be available in linux kernel
#
# pgpgin/s
#        Total  number  of blocks the system paged in
#        from disk per second.
#
# pgpgout/s
#        Total number of blocks the system paged  out
#        to disk per second.
#
# activepg
#        Number of active (recently touched) pages in
#        memory.  Note that a page has a size of 4 KB
#        or  8  KB according to the machine architec
#        ture.
#
# inadtypg
#        Number of inactive dirty (modified or poten
#        tially modified) pages in memory.
#
# inaclnpg
#        Number  of  inactive  clean  (not  modified)
#        pages in memory.
#
# inatarpg
#        "Inactive  target"  number  of  pages.  This
#        field  is a 1-minute floating average of the
#        number of pages the system needs to  "steal"
#        every  second  in  order  to  satisfy memory
#        demand.

  my @sarB = `sar -B`;
  return if ($#sarB == -1); #sar is not present or sar did not return anything
  chomp($sarB[$#sarB]);
  my ($ignore, $stats) = split(/:/, $sarB[$#sarB]);
  @sarB = split(/[\s\t]+/, $stats);
  return if ($#sarB < 6); #This is new sar, which does not have required info
  $activepg = $sarB[3];
  $inactivedp = $sarB[4];
  $inactivecp = $sarB[5];
}
