#!/bin/sh
#
# $Header: ifconfig.sh 10-oct-2002.15:57:32 vsekuboy Exp $
#
# ifconfig.sh
#
# Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      ifconfig.ksh - Network Interface Configuration
#
#    DESCRIPTION
#      Obtains network interface configuration information like flags, mtu,
#      inet and netmask per network interface.
#
#    NOTES
#      Currently this script is specific to Sun Solaris OS. For other OS,
#      the script may need to be modified.
#
#    MODIFIED   (MM/DD/YY)
#    vsekuboy    10/10/02 - Changes for linux
#    dmshah      04/03/02 - dmshah_support_host_metris
#    dmshah      04/02/02 - Creation
#

OS=`uname -s`

if [ $OS = "SunOS" ] ; then
  # Which awk to use?
  if [ -x /bin/nawk ] ; then
    AWK=/bin/nawk
  elif [ -x /usr/bin/nawk ] ; then
    AWK=/usr/bin/nawk
  elif [ -x /bin/awk ] ; then
    AWK=/bin/awk
  else
    echo "Cannot find awk - exiting."
    exit
  fi

  # Which ifconfig to use?
  if [ -x /usr/sbin/ifconfig ] ; then
    IFCONFIG=/usr/sbin/ifconfig
  elif [ -x /etc/ifconfig ] ; then
    IFCONFIG=/etc/ifconfig
  elif [ -x /usr/bin/ifconfig ] ; then
    IFCONFIG=/usr/bin/ifconfig
  elif [ -x /sbin/ifconfig ] ; then
    IFCONFIG=/sbin/ifconfig
  elif [ -x /bin/ifconfig ] ; then
    IFCONFIG=/bin/ifconfig
  elif [ -x /sbin/ifconfig ] ; then
    IFCONFIG=/sbin/ifconfig
  else
    IFCONFIG=ifconfig
  fi

# ifconfig -a returns two lines of info per network interface
# The first line contains the interface, flags and mtu information
# The second line contains the netmask, broadcast information.
# We need to return one line per interface
  $IFCONFIG -a | $AWK '
                       {
                       if ($0 ~ /flags/) {
                         interface = $1
                         flags = substr($2,7)
                         flags = substr(flags,5,length(flags)-5)
                         mtu = $4
                       }
                       if ($0 ~ /netmask/) {
                         printf "em_result=%s|%s|%s", interface, flags, mtu ;
                         printf "|%s|%s|%s\n", $2, $4, $6
                       }
                      }'


elif [ $OS = "Linux" ] ; then
  IFCONFIG=/sbin/ifconfig
  NETSTAT=/bin/netstat
  if [ -x /usr/bin/awk ] ; then
    AWK=/usr/bin/awk
  elif [ -x /usr/local/bin/awk ] ; then
    AWK=/usr/local/bin/awk
  else
    echo "Cannot find awk - exiting."
    exit
  fi
  $IFCONFIG | $AWK '
                       BEGIN { 
		          ip="";
		          bcast="";
		          netmask="";
		          interface="";
		       }
                       {
                       if ($0 ~ /^$/) {
                          "/bin/netstat -i | tail +3 |grep '^$interface'" | getline ;
                          printf "em_result=%s|%s|%s|%s|%s|%s\n", interface, $10,$2,ip, netmask,bcast ;
		          ip="";
		          bcast="";
		          netmask="";
		          interface="";
		       }
                       if ($0 ~ /Link encap/) {
		          interface = $1;
		       }
                       if ($0 ~ /inet addr:/) {
		          ip = substr($2,6);
		       }
                       if ($0 ~ /Bcast:/ && $0 ~ /Mask:/) {
		          bcast = substr($3,7);
		          netmask = substr($4,6);
		       }
                       else if( $0 ~ /Mask:/){
		          netmask = substr($3,6);
		       }
                       }
                    
                    ' 

fi
