#  $Header: oidLoad.pl 21-oct-2002.11:17:01 vsekuboy Exp $
# 
# Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      oidLoad.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This script computes for Oracle Internet Directory Server 
#      the process size in VM, % physical memory and %CPU consumption
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vsekuboy    10/21/02 - added ENV of PATH
#    vsekuboy    10/18/02 - Changes for HP, Linux, Tru64 and AIX
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    ggilchri    08/10/01 - Creation
#

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

$os = `uname -s`;
chomp ($os);
if ($os eq "SunOS" || $os eq "Linux") {
   @PSINFO = `ps -e -o fname,ppid,pid,vsz,pmem,pcpu|grep oidldapd`;
}
elsif ($os eq "OSF1" || $os eq "AIX") {
   @PSINFO = `ps -e -o comm,ppid,pid,vsz,pmem,pcpu|grep oidldapd`;
}
elsif ($os eq "HP-UX") {
   $ENV{UNIX95} = "XPG4";
   @PSINFO = `ps -e -o comm,ppid,pid,vsz,sz,pcpu|grep oidldapd`;
}
else {
   print "Platform - $os not supported\n";
}

$procID = 0;
$sz     = 0;
$phMem  = 0;
$CPU    = 0;

foreach $oidProcessInfo (@PSINFO)
{
  @data = split(/\s+/, $oidProcessInfo);
  if (1 == $data[1])
  {
    $procID = $data[2];
    $sz     = $data[3];
    if ($os eq "HP-UX") {
	$phMem = `$ENV{EMDROOT}/bin/nmupm mempct $data[4]`;
	chomp ($phMem);
    }
    else {
	$phMem  = $data[4];
    }
    $CPU    = $data[5];
    print "em_result=$procID|$sz|$phMem|$CPU\n";
  }
}



