#  $Header: osLoad.pl 03-apr-2007.03:30:44 shnavane Exp $
# 
# Copyright (c) 2001, 2007, Oracle. All rights reserved.  
#
#    NAME
#      osLoad.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This script is used in EMD to collect OS related statistics.  
#      Only Linux is supported.
#
#      The output of this script is :
#
#          em_result=$cpuAvg5Min|$numActivePgs|$noOfProcesses|$noOfUsers|$tps|
#                    0|$cpuIdleRaw|$cpuUserRaw|$cpuSysRaw|$cpuNiceRaw|$page_size|
#                    $realMemInKb|$freeMemInRaw|$usedSwapInRaw|$usedSwapInRaw|$freeSwapInRaw|$tps
#
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    shnavane    12/11/06 - Fix bug #5701916
#       shnavane 04/03/07 - Backport shnavane_bug-5701916 from main
#    rtakeish    02/07/-7 - Getting activeMem for bug5336607
#                         - Changing to get freeMem as KBytes
#    aptrived    07/11/06 - Backport aptrived_bug-4878743 from main 
#    sacgoyal    01/13/05 - bug#3845346 make script to linux relevent only 
#    sreddy      10/18/04 - latest code (bug#3838481), bug#3845346 included
#    rlal        08/20/04 - Define all vars for strict 
#    njagathe    07/12/04 - Merge PE Changes 
#    rlal        03/25/04 - Fix for bug 3533989
#    skumar      01/29/04 - fix for 1 user 
#    skumar      01/19/04 - paging changes 
#    skumar      01/07/04 - Creation
#    vsekuboy    10/25/02 - Added Tru64
#    vsekuboy    10/09/02 - Changes for Linux
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    lnhan       08/05/01 - Add number of processes on HP-UX
#    lnhan       04/04/01 - To handle different outputs returned by different versions of top
#    lnhan       03/12/01 - Some scripts by Ash Arnold are combined and modified
#                           to form the codes related HP. 
#                           On HP, if swapinfo fails to run swap value is set to 0.
#                           By default only root can run swapinfo on HP
#    lnhan       03/12/01 - Creation
#

exit 1 if ($^O ne "linux");

use strict;

use hostGenFunctions;

use constant NIL => '';

my $loadavg      = NIL;
my $loadavg1min  = NIL;
my $loadavg5min  = NIL;
my $loadavg15min = NIL;

my $nprocs    = NIL;
my $nusers    = NIL;
my $transfers = 0;

my $cpuidle = NIL;
my $cpuuser = NIL;
my $cpusys  = NIL;
my $cpuwait = 0;

my $pagesize  = NIL;
my $realmemKB = NIL;
my $freemem   = NIL;

my $usedswap = NIL;
my $freeswap = NIL;
my $totalswap = NIL;

my @data = ();
my $size = 0;
my @tokens = ();
my $page = '';
my $pgpgin = 0;
my $pgpgout = 0;
my $activeMem = NIL;

my $i;
my $rioindex = -1;
my $wioindex = -1;

my $k24 = 0;

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/local/bin";

# Load averages and Number of Users Logged in
my $lc_all_original = $ENV{LC_ALL};  #Save the original LC_ALL
$ENV{LC_ALL} = "C";
$_ = `uptime` or die "Failed to run command uptime\n";
$ENV{LC_ALL} = $lc_all_original;     #Restore original LC_ALL

if (/.*,(\s+\d+ user).* load average:(.*)/)
{
  $nusers = trim($1);
  $loadavg = trim($2);
  $nusers =~ s/ user//;
}

die "Failed to get Number of users\n" if ($nusers eq NIL || $loadavg eq NIL);

($loadavg1min, $loadavg5min, $loadavg15min) = split(", ", $loadavg);

# page scans
$page = `grep page /proc/stat`;
$page =~ s/page\s+//;
($pgpgin, $pgpgout) = split(" ", $page);

if ($pgpgin eq NIL) # 2.6 kernel
{
  if (open(FH, "/proc/vmstat"))
  {
    while (<FH>)
    {
      if (/pgpgin\s+(\d+)/)
      {
        $pgpgin = $1;
      }
      if (/pgpgout\s+(\d+)/)
      {
        $pgpgout = $1;
        last;
      }
    }
    close FH;
  }
}

$nprocs = `ps -e | wc -l` or die "Failed to run ps";
chomp($nprocs);
$nprocs = trim($nprocs);
$pagesize = `getconf PAGE_SIZE`;
chomp($pagesize);

# Transfers
if (!open(FH, "/proc/diskstats")) # 2.6 kernel
{
  open FH, "/proc/partitions" or die "Could not open /proc/partitions\n";
  $k24 = 1; # 2.4 kernel;
}

@data = (<FH>);
close FH;

if ($k24)
{
  # Index of fields: rio and wio
  if ($data[0] =~ /rio/)
  {
    @tokens = split(/[\s\t]+/, $data[0]);
    for ($i = 0; $i < $#tokens; $i++)
    {
      if ($tokens[$i] =~ /rio/) { $rioindex = $i; }
      if ($tokens[$i] =~ /wio/) { $wioindex = $i; }
    }
  }

  if ($rioindex != -1 && $wioindex != -1)
  {
    $size = scalar(@data);
    for ($i = 1; $i < $size; $i++)
    {
      $_ = trim($data[$i]);
      next if /^$/;
    
      @tokens = split(/[\s\t]+/, $_);
      $transfers += ($tokens[$rioindex] + $tokens[$wioindex]);
    }
  }
}
else
{
  $size = scalar(@data);
  for ($i = 0; $i < $size; $i++)
  {
    $_ = trim($data[$i]);
    next if /^$/;

    @tokens = split(/[\s\t]+/, $_);
    if (scalar(@tokens) == 7)
    {
      $transfers += ($tokens[3] + $tokens[5]);
    }
    else
    {
      $transfers += ($tokens[3] + $tokens[7]);
    }
  }
}

# CPU stats
$_ = `grep -F 'cpu ' /proc/stat` or die "Failed to run grep";
if (/cpu\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)/)
{
  $cpuuser = $1;
  $cpuuser += $2;
  $cpusys  = $3;
  $cpuidle = $4;
  $cpuwait = $5;
}
elsif (/cpu\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)/)
{
  $cpuuser = $1;
  $cpuuser += $2;
  $cpusys  = $3;
  $cpuidle = $4;
}

# Memory and Swap Info
open FH, "/proc/meminfo" or die "Could not open /proc/meminfo\n";

while (<FH>)
{
  if (/MemTotal:\s+(\d+)/)
  {
    $realmemKB = $1;
  }
  if (/MemFree:\s+(\d+)/)
  {
    $freemem   = $1;
  }
  if (/Active:\s+(\d+)/)
  {
    $activeMem = $1;
  }
  if (/SwapTotal:\s+(\d+)/)
  {
    $totalswap = $1*1024;
  }
  if (/SwapFree:\s+(\d+)/)
  {
    $freeswap = $1*1024;
    $usedswap = $totalswap - $freeswap;
    last;
  }
}

close FH;

print "em_result=$loadavg1min|$loadavg5min|$loadavg15min|$pgpgin|$pgpgout|$nprocs|$nusers|$transfers|$cpuidle|$cpuuser|$cpusys|$cpuwait|$pagesize|$realmemKB|$freemem|$usedswap|$freeswap|$activeMem\n";

exit 0;
