#  $Header: emagent/sysman/admin/scripts/osconfig.pl /stpl_db_11.2.0.0.0_gen/1 2009/07/14 22:40:05 ssalunke Exp $
# 
# Copyright (c) 2001, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      osconfig.pl
#
#    Description:
#      This script is used in the EMD to ccollect OS configuration info.
#      The expected o/p if the script executes successfully is
#  
#  em_result=<OS>|<OSReleaseLevel>|<PatchLevel>|<Platform>|<Uptime>|<IP Addr>
#
#    MODIFIED  (MM/DD/YY)
#    ssalunke 12/18/08 - who -b does not work on SLES
#    aptrived 01/31/08 - Backport aptrived_bug-6758581 from main
#    aptrived   01/28/08 - Bug#6758581, Doing fix for Bug#5076516 for all UNIX flavor
#    aptrived 03/03/06 - Bug#5076516, Collecting uptime in date-time format 
#                        for Linux 
#    aptrive  02/20/07 - Backport aptrived_bug-5076516 from main
#    ajayshar   09/28/06 -Bug#5448472 For AIX, os_release_level calculated using oslevel 
#    ajayshar 09/29/06 - Backport ajayshar_bug-5448472 from main
#    sacgoyal 03/06/05 - fix bug#4215387 
#    mbhoopat 03/10/04 - linux port 
#    nsharma  01/28/04 - Fix for united linux 
#    rzkrishn 07/28/03 - using nmupm for system boot time
#    vsekuboy 10/28/02 - Updated comments to reflect correct output
#    vsekuboy 10/24/02 - Changes for AIX and Tru64
#    vsekuboy 10/09/02 - Changes for HP and Linux
#    xxu      06/25/02 - remove /usr/local/bin/perl
#    njagathe 01/17/02 - Adding back more columns
#    njagathe 01/17/02 - Updating to only return 3 columns
#    vnukal   12/24/01 - fixing ip parsing glitch in 2.8
#    vnukal   10/22/01 - adding patch level and ip info to Config metric
#    vnukal   10/03/01 - reducing delay for top execution
#    vnukal   09/04/01 - Initial revision

#require "emd_common.pl";
use hostGenFunctions;

# accpts month in MON/MONTH format and returns in MM
# month index starts with 1
# if correct month is not found, return 0, meaning error
sub getMMFromMonth
{
  if     ((lc($_[0]) eq "jan") || (lc($_[0]) eq "january"))   {
    return 1;
  } elsif((lc($_[0]) eq "feb") || (lc($_[0]) eq "february"))  {
    return 2;
  } elsif((lc($_[0]) eq "mar") || (lc($_[0]) eq "march"))     {
    return 3;
  } elsif((lc($_[0]) eq "apr") || (lc($_[0]) eq "april"))     {
    return 4;
  } elsif((lc($_[0]) eq "may") || (lc($_[0]) eq "may"))       {
    return 5;
  } elsif((lc($_[0]) eq "jun") || (lc($_[0]) eq "june"))      {
    return 6;
  } elsif((lc($_[0]) eq "jul") || (lc($_[0]) eq "july"))      {
    return 7;
  } elsif((lc($_[0]) eq "aug") || (lc($_[0]) eq "august"))    {
    return 8;
  } elsif((lc($_[0]) eq "sep") || (lc($_[0]) eq "september")) {
    return 9;
  } elsif((lc($_[0]) eq "oct") || (lc($_[0]) eq "october"))   {
    return 10;
  } elsif((lc($_[0]) eq "nov") || (lc($_[0]) eq "november"))  {
    return 11;
  } elsif((lc($_[0]) eq "dec") || (lc($_[0]) eq "december"))  {
    return 12;
  }
  # could not find correct mon/month, return 0
  return 0;
}

sub getUptimeFormat1
{
  my $upsince_1 = shift;
  $upsince_1 =~ /system boot\s+([a-zA-Z0-9 :]+)/i ;
  $upsince_1 = $1;
  $upsince_1 =~ s/[\s]+/ /g;
  my @tmpstr_1 = split(/ /, $upsince_1);
  my @timeData_1 = localtime(time);
  chomp($uptime_1 = `uptime`);
  $uptime_1 =~ s/[\s]+/ /g;
  #Different kind of uptime possible as below
  #5:31am up 16 min(s), 1 user, load average: 0.20, 2.50, 2.36
  #7:26am up 2:12, 1 user, load average: 0.71, 0.30, 0.29
  #02:30:46 up 297 days, 13:28, 13 users, load average: 0.08, 0.21, 0.17
  #Below parsing should work for all
  $upsinceDay_1 = (split(/ /, $uptime_1))[3]; #This could be min also, but that's fine
  $upsinceYr_1 = ($timeData_1[5]+1900) - int($upsinceDay_1/365);
  if($upsinceDay_1 > $timeData_1[7])
  {
    $upsinceYr_1 -= 1;
  }
  my $uptime_1 = sprintf("%04d-%02d-%02d %02d:%02d:00", $upsinceYr_1, getMMFromMonth($tmpstr_1[0]), $tmpstr_1[1], (split(/:/,$tmpstr_1[2]))[0], (split(/:/,$tmpstr_1[2]))[1]);
  return $uptime_1;
}

sub getUptimeFormat2
{
  my $upsince_2 = shift;
  $upsince_2 =~ /system boot[\s]+(\d{1,4}-\d{1,2}-\d{1,2} \d{1,2}:\d{1,2})$/i;
  $upsince_2 = $1;
  $uptime_2 = sprintf("$upsince_2:00");
  return $uptime_2;
}

$ENV{PATH} = "/bin:/usr/bin:/usr/sbin:/usr/local/bin:/sbin:$ENV{EMDROOT}/bin";
chomp ($os = `uname -s`);
if ( $os eq "SunOS" || $os eq "AIX" || $os eq "OSF1" ) {
   chomp ($os_release_level = `uname -r`);
   chomp ($patchlevel = `uname -v`);

   chomp($hostname = `hostname`);

   if ( $os eq "AIX" ) {
      chomp ($os_release_level = `oslevel`);
      chomp ($platform = `uname -M`);
      chomp($pingop = `ping $hostname 1 1 | head -1`); 
   }
   elsif ( $os eq "OSF1" ) {
      chomp ($platform = `uname -m`);
      chomp($pingop = `ping -c 1 $hostname | head -1`);
   }
   else {
      chomp ($platform = `uname -mi`);
      chomp($pingop = `ping -s $hostname 1 1`);
   }

   #get the first stuff between parenthesis.
   ($ip) = $pingop =~ m/\((\S+)\)/o; 
}
elsif ( $os eq "HP-UX") {
 
   chomp ($os_release_level = `uname -r`);
   chomp ($model = `uname -mi`);
 
   if ( $model == "ia64" ) {
      $platform="IA64";
   }
   else {
      $platform="PA-RISC";
   }
 
   chomp ($patchlevel = `uname -v`);
 
   chomp($hostname = `hostname`);
   chomp($pingop = `/etc/ping $hostname -n 1`);
 
   #get the IP address
   $pingop =~ /bytes from (.*?):/;
   ($ip) = $1;
}
elsif ($os eq "Linux") {
   chomp ($platform = `uname -m`);
   chomp ($patchlevel = `uname -r`);

   if ( -r "/etc/SuSE-release" ) {
       $os_release_level=`cat /etc/SuSE-release | tr '\n' ' ' `;
   }
   elsif ( -r "/etc/redhat-release") {
      $os_release_level=`cat /etc/redhat-release | tr '\n' ' ' `;
   }
   elsif ( -r "/etc/UnitedLinux-release") {
      $os_release_level=`cat /etc/UnitedLinux-release | tr '\n' ' ' `;
   }
   $host = `hostname`;
   $_ = `ping -c1 $host`;

   if(/PING/) {
	   ($c1,$c2,$c3,$ignore) = split(/\s+/);
	   ($c1,$ip,$ignore) = split(/[\(\)]/, $c3);
   }
}

$os_release_level = trim($os_release_level);
  
chomp($upsince = `who -b`);
if ($os =~ m/Linux/i)
{
  #Linux
  chomp($updata = `grep btime /proc/stat`);
  if ($updata =~ m/btime/i)
  {
    #/proc/stat contains btime
    #Should work for most distros
    #print "DEBUG: using btime from /proc/stat\n";
    my @btime_data = split(/ /, $updata);
    ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)= localtime($btime_data[1]);
    # localtime returns year from 1900 and month in range of 0-11
    $uptime = sprintf('%04d-%02d-%02d %02d:%02d:%02d',($year+1900),($mon+1),$mday,$hour,$min,$sec);
  }
  elsif ($upsince =~ /system boot/i)
  {
    #Linux, but /proc/stat doesn't contain btime, so checking `who -b` formats
    $upsince =~ s/^\s+//; #remove leading whitespaces
    $upsince =~ s/\s+$//; #remove trailing whitespace
    if ($upsince =~ m/system boot[\s]+\D+ \d{1,2} \d{1,2}:\d{1,2}$/)
    {
      #system boot  Oct 26 18:06
      #system boot[\s]+\D+ \d{1,2} \d{1,2}:\d{1,2} 
      #currently seen in EL4
      #print "DEBUG: using who, format 1\n";
      $uptime = getUptimeFormat1($upsince);
    }
    elsif ($upsince =~ m/system boot[\s]+\d{1,4}-\d{1,2}-\d{1,2} \d{1,2}:\d{1,2}$/)
    {
      #system boot  2008-11-20 12:49
      #system boot[\s]+\d{1,4}-\d{1,2}-\d{1,2} \d{1,2}:\d{1,2}     
      #currently seen in EL5
      $uptime = getUptimeFormat2($upsince);
      #print "DEBUG: using who, format 2\n";
    }
    else
    {
      #Unsupported - `who -b` works, but new format encountered
      $uptime = "2008-00-00 00:00:00";
    }
  }
  else
  {
    #Unsupported - neither /proc/stat nor `who -b` working
    $uptime = "2009-00-00 00:00:00";
  }
}
else
{
  #Other unix operating systems
  if ($upsince =~ /system boot/i)
  {
    #print "DEBUG: using who, format 1\n";
    $uptime = getUptimeFormat1($upsince);
  }
  else
  {
    #Unsupported Unix platform
    $uptime = "2000-00-00 00:00:00";
  }
}

print "em_result=$os|$os_release_level|$patchlevel|$platform|$uptime|$ip\n";

