#!/bin/sh
#
# $Header: stopoidserver.sh 13-sep-01.16:06:50 xshi Exp $
#
# stopoidserver.sh
#
#  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
#
#    NAME
#       stopoidserver.sh - This script starts oidmon and then starts oidldapd server
#
#    DESCRIPTION
#	usage: startoidserver.sh <connectString> <instanceNo> [<sleepTime>] 
#
#
#	connectString: Connect String of the database
#
#       instanceNo   : Instance number of the server to start.  This should be a 
#                      number whose value MUST be > 0 and <= 1000. 
#
#       sleepTime    : Specifies time in number of seconds, waiting time before
#		       shutting down the OID server and after shutting down OID Monitor
#
#	Note:  Please make sure that environment variable $ORACLE_HOME is set, before
#	       running this script.
#
#              This script has been written for the default configurations.  User needs
#              to edit it as per his requirements.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xshi        09/13/01 - 
#    xshi        09/13/01 - Creation
#

if [ $# -eq 3 ]
then
  sleeptime=0
else
  sleeptime=$3
fi

sleep $sleeptime

LOGFILE=/tmp/oid$$.log

$ORACLE_HOME/bin/oidctl connect=$1 server=OIDLDAPD instance=$2 stop >> $LOGFILE 2>&1 
sleep 30

$ORACLE_HOME/bin/oidmon connect=$1 sleep=10 stop >> $LOGFILE 2>&1 

sleep $sleeptime
exit 0


