#!/usr/local/bin/perl
# 
# $Header: tns_response.pl 06-apr-2005.20:51:54 afontana Exp $
#
# tns_response.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      tns_response.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    afontana    04/06/05 - fix result on failure 
#    afontana    11/12/04 - append txnName and beaconName to results 
#    afontana    11/10/04 - afontana_sql_metrics
#    afontana    11/08/04 - Creation
#

use ParseStdin;
use Time::HiRes qw(gettimeofday tv_interval);
use strict;

ParseStdin::initStdin();

my $txnName =  ParseStdin::getParameter("TxnName");
my $beaconName = ParseStdin::getParameter("BeaconName");
my $connectString = ParseStdin::getParameter("ConnectString");
my $numTries = ParseStdin::getParameter("NumTries", "1");


my $r;

if (!($r = `tnsping "$connectString" $numTries`))
{
  print "em_error=Failed to run tnsping";
  exit -1;
}

my @resLns = split(m/\n/o, $r);
my $line;
my $successCount = 0;
my $totalTime = 0;
my $pingtime;

foreach $line (@resLns)
{
  if ($line =~ /\AOK.*/o)
  {
    ($pingtime) = ($line =~ /\.*(\d+).*/o);
    $successCount += 1;
    $totalTime += $pingtime;
  }
}

#print $successCount . "|" . $totalTime . "\n";

if ($successCount > 0)
{
  print "em_result=";
  print ($txnName . "|") if ($txnName);
  print ($beaconName . "|") if ($beaconName);
  print "1|";
  print $totalTime / $successCount . "|";
  print (($numTries - $successCount) / $numTries);
}
else
{
  print "em_result=";
  print ($txnName . "|") if ($txnName);
  print ($beaconName . "|") if ($beaconName);
  print "0||";
}
