#!/usr/bin/sh
# ------------------------------------------------------------
# Script : topprocs.sh
# Purpose: Fetch top process stats
# Usage  : topprocs.sh 
# Modified : rstorrie - added multi OS support 
# ------------------------------------------------------------
OSTYPE=`uname -s`
export OSTYPE

stat=$1
count=${2-10}

case $OSTYPE in
 SunOS) # setup the Solaris specific parameters
  # list processes ordered by CPU utilization
  if [ $stat -eq 1 ] ; then
    ps -efo 'pcpu, pmem, rss, vsz, pid, user, comm' | tail +2 | sort -r | head -${count} | awk '{print "em_result=" $1 "|" $2 "|" $3 "|" $4 "|" $5 " ( user=" $6 " command=" $7 " )"}'
  fi;
  # list processes ordered by memory utilization
  if [ $stat -eq 2 ] ; then
    ps -efo 'pmem, rss, vsz, pcpu, pid, user, comm' | tail +2 | sort -r | head -${count} | awk '{print "em_result=" $1 "|" $2 "|" $3 "|" $4 "|" $5 " ( user=" $6 " command=" $7 " )"}'
  fi;
  ;;
 HP-UX) # For HP-UX the parameter UNIX95 is required to access POSIX utils 
  UNIX95=
  export UNIX95
  # list processes ordered by CPU utilization
  if [ $stat -eq 1 ] ; then
   ps -efo pcpu,sz,vsz,pid,user,comm | tail +2 | sort -r | head -${count} | awk '{print "em_result=" $1 "|" $2 "|" $3 "|" $4 " ( user=" $5 " command=" $6 " )"}'
  fi;
  # list processes ordered by memory utilization
  if [ $stat -eq 2 ] ; then
   ps -efo 'sz,vsz,pcpu,pid,user,comm' | tail +2 | sort -r | head -${count} | awk '{print "em_result=" $1 "|" $2 "|" $3 "|" $4 " ( user=" $5 " command=" $6 " )"}'
  fi;
  ;;
esac
