#!/usr/local/bin/perl
# 
# $Header: webcache_esm.pl 03-may-2005.04:27:15 rkuriako Exp $
#
# webcache_esm.pl
# 
# Copyright (c) 2003, 2005, Oracle. All rights reserved.  
#
#    NAME
#      webcache_esm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      ESM script for webcache security violations
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rkuriako    05/03/05 - bug-4188709
#    kchander    12/16/03 - fix bug 3318453 
#    kchander    11/26/03 - kchander_esm_scripts_for_ias 
#    kchander    11/06/03 - 
#    kchander    10/28/03 - Creation
#
use File::Find;
use Digest::MD5;
use strict;
my $oraHome = $ENV{ORACLE_HOME};

our $writeableFileCount = 0;
my $sep = $^O =~ m/MSWin32/ ? "\\" : "\/";
my $webcache = $oraHome.$sep."webcache".$sep."webcache.xml";
if (open WEBCACHECONF, "<$webcache")
{
    my @confarray = ();
    while (my $in = <WEBCACHECONF>)
    {
        chomp($in);
        $in =~ s/^\s+//;
        $in =~ s/\s+$//;
        push(@confarray, $in);
    }
    close WEBCACHECONF;
    #check whether access logging is enabled or not
    my @array = grep(/<ACCESSLOG /, @confarray);
    my @access; 
#weed out comments
    for (my $i=0; $i<=$#array; $i++)
    {
        $array[$i] =~ s/^\s+//;
    }
    @array = grep(!/^<!--/, @array);
    for (my $i=0; $i<=$#array; $i++)
    {
        my $ind = index($array[$i], "ENABLED=");
        if ( $ind != -1)
        {
            my $in = index($array[$i], "\"", $ind+9);
            my $en = substr($array[$i], $ind+9, $in - ($ind +9));
            $en =~ s/^\s+//;
            $en =~ s/\s+$//;
            print "$en\n";
            $access[$i]=$en;
        }
        else
        {
            $access[$i]="YES";
        }
    }
    if ( $#access < 0)
    {
        print "em_result=WebCacheAccessLogging|disabled\n";
    }
    else
    {
        for (my $i =0; $i<=$#access; $i++)
        {
            if ($access[$i] ne "YES")
            {
                print "em_result=WebCacheAccessLogging|disabled\n";
            }
        }
    }
    my $webcacheexe = $oraHome.$sep."webcache".$sep."bin".$sep."webcached";
    my @attr=stat($webcacheexe);
    #test whether webcached is owned by root and setuid bit is set
    if ( ($attr[4] == 0) and ($attr[2] & 04000))
    {
        print "em_result=WebCacheProcess|root\n";
    }
    else 
    {
        print "em_result=WebCacheProcess|non_root\n";
    }

#test all files under the docs directory are read only
    my $docDir = $oraHome.$sep."webcache".$sep."docs";
    find(\&checkFiles, $docDir);
    if ($writeableFileCount >= 0)
    {
        print "em_result=WebCacheWritableFile|$writeableFileCount\n";
    }
#check for usage of default wallet
    my @port = ();
    my @wallet = ();
    my $line;
    for (my $i =0; $i<$#confarray; $i++) 
    {
        $line = $confarray[$i];
        chomp($line);
        $line =~s/^\s+//;
        $line =~ s/\s+$//;

        if (!grep(/<!--/, $line) and grep(/<LISTEN/, $line) and grep(/SSLENABLED/, $line)
                and !grep(/SSLENABLED="NONE"/, $line))
        {
            while (!grep(/<\/LISTEN>/, $line))
            {
                my $l = $confarray[++$i];
                chomp($l);
                $l =~s/^\s+//;
                $l =~ s/\s+$//;
                $line = $line.$l;
            }

            my $in1 = index($line, "<WALLET>");
            my $in2 = index($line, "</WALLET>");
            my $wal = substr($line, $in1+8, $in2 -($in1+8));
            push(@wallet, $wal);
            $in1 = index($line, "PORT");
            $in2 = index($line, "\"", $in1+6);
            my $p = substr($line, $in1+6, $in2 - ($in1+6));
            push(@port, $p);

        }
    }
    #print " @port\n";
    #print " @wallet\n";

    my $defaultDigest = "drBm1T5EkXGE508cBGjXNw";
    for (my $i = 0; $i<=$#wallet; $i++)
    {

        my $defaultCert = $wallet[$i].$sep."ewallet.p12";
        if (open DEFCER ,$defaultCert)
        {
            binmode(DEFCER);
            my $md5 = Digest::MD5->new;
            while(<DEFCER>)
            {
                $md5->add($_);
            }
            close DEFCER;
            my $dig = $md5->b64digest; 
            if ($dig eq $defaultDigest)
            {
                print "em_result=WebCacheDummyWallet|$port[$i]\n";
            }
        }
    }
}
sub checkFiles
{
    my $currentFile = $_;
    if (!(  -d $currentFile))
    {
        my @fileattr = stat($currentFile);
        # print "$currentFile\n";
        if (($fileattr[2] & 020)or ($fileattr[2] & 2))
        {
            $writeableFileCount++;
        }
    }
}

