#
# Copyright (c) 2001, 2005, Oracle. All rights reserved.  
#
#    NAME
#      wmiquery.pl 
#
#    DESCRIPTION
#      This script is used in EMD to execute the wmi query depending on the filetype passed.
#      The state file directory is read from the environment variable $EMSTATE, which must
#      be set for the script to run.This script will set the WBEM_WQL environment and then call the 
#      nmuwmi.exe to get the metric result.
#

#
#    MODIFIED   (MM/DD/YY)
#    cgnanasa    06/24/05 - EMSTATE to be used to read state directory 
#    hsharma     02/15/05 - hsharma_wmiexecutable3
#    ajayshar    02/09/05 - Creation for facilitating WMI queries (EM 10.2)


require "emd_common.pl";
use Time::gmtime;
use Time::Local;

my $fileTime="0";
my $filetype=$ENV{"WBEM_FILENAME"}; # 'APPLICATION , SECURITY, SYSTEM , WINDOWS';
my $setenvstring="";
my $filename;
my $offset  = sprintf "%.1f", (timegm(localtime) - time) / 3600;
my $UTC=sprintf "%+d", $offset*60;
my $zero=0;
my $currtime;

EMD_PERL_DEBUG("------- STARTED wmiquery.pl ( $filetype )----------");

if(($filetype ne "APPLICATION") && ($filetype ne "SYSTEM") && ($filetype ne "SECURITY") && ($filetype ne "WINDOWS"))
{

    print "em_error=Incorrect filetype (WBEM_FILENAME) in parameter.\n";
    EMD_PERL_DEBUG("$filetype : Incorrect filetype (WBEM_FILENAME) in parameter.\n\n");
    exit 1;
}

unless( exists $ENV{"EMSTATE"} or defined $ENV{"EMSTATE"} ) 
{
    print "em_error=The environment variable EMSTATE needs to be set.\n";
    EMD_PERL_DEBUG("The environment variable EMSTATE needs to be set.\n\n");
    exit 1;
}

$filename=$ENV{EMSTATE}."\\sysman\\emd\\state"."\\wmi_state_".$filetype.".dat"; 

&getTimeState();
&saveTimeState();


# This function will get the last saved time from the coresponding state file (TYPE[app/sys/sec/win]).
# If the file is not existing , it will just return indicating that the query is being run the first time.
sub getTimeState()
{  
    unless( open STATE, "< $filename" ) 
    {
        EMD_PERL_DEBUG("WARNING:Unable to open statefile ( $filename ) for reading. Should create a new file after this step.");   
        ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime(time);
        $currtime = sprintf("%4d%02d%02d%02d%02d%02d.%06d%03d",$year+1900,$mon+1,$mday,$hour,$min,$sec,$zero,$UTC); 
        $fileTime=$currtime;
        return;
    }    
    my @stateData = <STATE>;
    my @timevar = split("=", $stateData[0]);
    $fileTime = $timevar[0];    
    EMD_PERL_DEBUG("Getting:$fileTime");    
    close(STATE);
    return $fileTime;  
}


# This function will save the curent time using the WQL format in the state file
# This will give error if due to some reason file cannot be created , which should never happen.
sub saveTimeState()
{

    
    unless( open STATE, "> $filename" ) 
    {
        print "em_error=Unable to open statefile ( $filename ) for Writing.\n";
        EMD_PERL_DEBUG("ERROR:Unable to open statefile ( $filename ) for Writing.\n\n");    
        exit 1;
    }    
    ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime(time);
     $currtime = sprintf("%4d%02d%02d%02d%02d%02d.%06d%03d",$year+1900,$mon+1,$mday,$hour,$min,$sec,$zero,$UTC);        
    print STATE "$currtime=TIMESTATE\n";  
    EMD_PERL_DEBUG("Setting:$currtime");  
    close(STATE);  
}


if($filetype eq "WINDOWS")
{   
    $setenvstring="select logfile,sourcename,eventcode,timegenerated,recordnumber,type,categorystring,user,message from win32_ntlogevent where timegenerated >= '$fileTime' and (type='warning' or type='error')";
}

else
{
    $setenvstring="select sourcename,categorystring,eventcode,timegenerated,recordnumber,type,user,message from win32_ntlogevent where logfile='$filetype' and timegenerated >= '$fileTime' and (type='warning' or type='error')";
}

EMD_PERL_DEBUG("SET Environment(WBEM_WQL):$setenvstring ");
$ENV{WBEM_WQL}=$setenvstring;
system "nmefwmi.exe";
EMD_PERL_DEBUG("------- ENDED wmiquery.pl ---------\n\n");





