REM############################################################################
REM
REM Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
REM
REM
REM PRODUCT
REM	Oracle Enterprise Manager
REM
REM THIS FILE IS MACHINE GENERATED. DO NOT EDIT!
REM
REM JOB TYPE SQL FOR JOB TYPE: PAFFileTransfer
REM
REM#############################################################################

SET DEFINE OFF

SET SQLPREFIX OFF


BEGIN 
BEGIN
DECLARE
    l_job_type_name MGMT_JOB_TYPE_INFO.job_type%TYPE;
    l_job_type_id MGMT_JOB_TYPE_INFO.job_type_id%TYPE;
    l_major_version MGMT_JOB_TYPE_INFO.major_version%TYPE;
    l_minor_version1 MGMT_JOB_TYPE_INFO.minor_version1%TYPE;
    l_minor_version2 MGMT_JOB_TYPE_INFO.minor_version2%TYPE;
BEGIN

l_job_type_name:= 'PAFFileTransfer';

BEGIN 
MGMT_JOB_ENGINE.fix_flatten_steps(TRUE); 
MGMT_JOB_ENGINE.get_max_versions(l_job_type_name, l_major_version,
                   l_minor_version1, l_minor_version2, 
                   l_job_type_id); 
                         
l_minor_version2 := l_minor_version2+1; 
     
EXCEPTION 
    WHEN OTHERS THEN 
        IF SQLCODE=MGMT_GLOBAL.INVALID_JOB_TYPE_ERR THEN             l_major_version := 1; 
            l_minor_version1 := 0; 
            l_minor_version2 := 1; 
        ELSE 
            RAISE;
        END IF; 
END; 

-- CHECK TO VALIDATE REFERENCED COMMANDS/NESTED JOB TYPES
BEGIN
DECLARE
    l_commands SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
    l_nested_jobtypes SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN

    l_commands.trim(l_commands.count);

    l_commands.extend(1);
    l_commands(1) := 'remoteOp';

    l_nested_jobtypes.trim(l_nested_jobtypes.count);

    l_nested_jobtypes.extend(1);
    l_nested_jobtypes(1) := 'PAFFileTransferImpl';
    MGMT_JOB_ENGINE.validate_job_type(l_job_type_name, l_commands, l_nested_jobtypes );


END;
END;


-- JOBTYPE ENTRY
INSERT INTO MGMT_JOB_TYPE_INFO(job_type, version, major_version, minor_version1, minor_version2, job_type_category, all_target_types, agent_bound, single_target, suspend_on_nocreds, default_target_type, restartable, editable, suspendable, trusted,job_type_nlsid,job_type_default,create_text_nlsid,create_text_default,delete_text_nlsid,delete_text_default)  VALUES
	( l_job_type_name, '1.0', l_major_version, l_minor_version1, l_minor_version2, 0, 0, 0, 0, 0, null, 1, 1, 1, -1, 'PAFFILETRANSFER_DISP_NAME', 'File Transfer', null, null, null, null)
RETURNING job_type_id INTO l_job_type_id;

-- ENTRIES FOR STEPSET main
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'main', 2, null, null, -1, null, -1, null, null, null, null, null, 1, null, null, null, 2, 0, 0, 0, null, null, -1 );

-- PARAMINFO ENTRIES FOR STEP CheckSkipArchive
-- PARAM SOURCE: source type credentials
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'sourceUsername';
    l_param_names(2) := 'sourcePassword';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'CheckSkipArchive', 3, 'credentials', 1, '
  ', 0, 0, 1, l_param_names );


END;
END;


-- CREDENTIAL PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_cred_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_types MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_container_paths MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_cred_type_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_cred_columns.trim(l_cred_columns.count);

    l_cred_columns.extend(2);
    l_cred_columns(1) := 'username';
    l_cred_columns(2) := 'password';

    l_target_names.trim(l_target_names.count);

    l_target_names.extend(1);
    l_target_names(1) := '%source_target_name%';

    l_target_types.trim(l_target_types.count);

    l_target_types.extend(1);
    l_target_types(1) := 'host';
    INSERT INTO MGMT_JOB_CRED_PARAMS(source_id, 
                         credential_set_name, 
                         credential_set_target_type, 
                         base_cred_type_name, 
                         base_cred_type_target_type, 
                         base_cred_type_columns, 
                         credential_columns, 
                         credential_columns_param, 
                         target_names, 
                         target_types, 
                         container_paths, 
                         target_names_param, 
                         target_types_param, 
                         container_paths_param, 
                         set_override) 
       SELECT source_id, 'HostCredsNormal', 'host', null, null, null, l_cred_columns, null, l_target_names, l_target_types, null, null, null, null, 0         FROM   MGMT_JOB_PARAM_SOURCE WHERE job_type_id= l_job_type_id            AND source_index=1;
END;
END;


-- PARAM SOURCE: source type credentials
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'destUsername';
    l_param_names(2) := 'destPassword';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 0, 'CheckSkipArchive', 3, 'credentials', 2, '
  ', 0, 0, 1, l_param_names );


END;
END;


-- CREDENTIAL PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_cred_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_target_types MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_container_paths MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
    l_cred_type_columns MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_cred_columns.trim(l_cred_columns.count);

    l_cred_columns.extend(2);
    l_cred_columns(1) := 'username';
    l_cred_columns(2) := 'password';

    l_target_names.trim(l_target_names.count);

    l_target_names.extend(1);
    l_target_names(1) := '%dest_target_name%';

    l_target_types.trim(l_target_types.count);

    l_target_types.extend(1);
    l_target_types(1) := 'host';
    INSERT INTO MGMT_JOB_CRED_PARAMS(source_id, 
                         credential_set_name, 
                         credential_set_target_type, 
                         base_cred_type_name, 
                         base_cred_type_target_type, 
                         base_cred_type_columns, 
                         credential_columns, 
                         credential_columns_param, 
                         target_names, 
                         target_types, 
                         container_paths, 
                         target_names_param, 
                         target_types_param, 
                         container_paths_param, 
                         set_override) 
       SELECT source_id, 'HostCredsNormal', 'host', null, null, null, l_cred_columns, null, l_target_names, l_target_types, null, null, null, null, 0         FROM   MGMT_JOB_PARAM_SOURCE WHERE job_type_id= l_job_type_id            AND source_index=2;
END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(3);
    l_param_names(1) := 'staging_area';
    l_param_names(2) := 'ftp_transfer';
    l_param_names(3) := 'skip_archive';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 1, 'CheckSkipArchive', 3, 'inline', 3, '
  ', 0, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(3);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'staging_area';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := '%emd_root%';
    l_params(1).vector_value := null;
    l_params(2) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(2).param_name := 'ftp_transfer';
    l_params(2).param_type := 1;
    l_params(2).scalar_value := 'false';
    l_params(2).vector_value := null;
    l_params(3) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(3).param_name := 'skip_archive';
    l_params(3).param_type := 1;
    l_params(3).scalar_value := 'false';
    l_params(3).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=3;
END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'temp';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 1, 'CheckSkipArchive', 3, 'inline', 4, '
  ', 1, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(1);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'temp';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := '%staging_area%/PAF/Job_%job_execution_id%';
    l_params(1).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=4;
END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(4);
    l_param_names(1) := 'archive_command';
    l_param_names(2) := 'archive_filename';
    l_param_names(3) := 'source_file_list';
    l_param_names(4) := 'restore_command';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 1, 'CheckSkipArchive', 3, 'inline', 5, '
  ', 0, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(4);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'archive_command';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := '%emd_root%/bin/zip -r';
    l_params(1).vector_value := null;
    l_params(2) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(2).param_name := 'archive_filename';
    l_params(2).param_type := 1;
    l_params(2).scalar_value := 'xyz.zip';
    l_params(2).vector_value := null;
    l_params(3) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(3).param_name := 'source_file_list';
    l_params(3).param_type := 1;
    l_params(3).scalar_value := '*';
    l_params(3).vector_value := null;
    l_params(4) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(4).param_name := 'restore_command';
    l_params(4).param_type := 1;
    l_params(4).scalar_value := '%emd_root%/bin/unzip -o';
    l_params(4).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=5;
END;
END;


-- PARAM SOURCE: source type substValues
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(2);
    l_param_names(1) := 'archive_command';
    l_param_names(2) := 'restore_command';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 0, 1, 'CheckSkipArchive', 3, 'substValues', 6, '
  ', 1, 0, 0, l_param_names );


END;
END;


-- SUBSTVALUES PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_source_params MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_source_params.trim(l_source_params.count);

    l_source_params.extend(2);
    l_source_params(1) := 'archive_command';
    l_source_params(2) := 'restore_command';
    INSERT INTO MGMT_JOB_SUBST_PARAMS(source_id, 
                      source_params) 
 SELECT source_id, l_source_params     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=6;
END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'source_file_name';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 1, 'CheckSkipArchive', 3, 'inline', 7, '
    ', 0, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(1);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'source_file_name';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := '%source_file_list%';
    l_params(1).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=7;
END;
END;


-- PARAM SOURCE: source type inline
BEGIN
DECLARE
    l_param_names MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_param_names.trim(l_param_names.count);

    l_param_names.extend(1);
    l_param_names(1) := 'destination_file_name';
    INSERT INTO MGMT_JOB_PARAM_SOURCE(job_type_id, 
                          apply_at_submission, 
                          apply_on_retry, 
                          step_name, 
                          step_type, 
                          source_type, 
                          source_index, 
                          source_data, 
                          override_user, 
                          required, 
                          encrypted, 
                          parameter_names)  VALUES
	( l_job_type_id, 1, 1, 'CheckSkipArchive', 3, 'inline', 8, '
  ', 0, 0, 0, l_param_names );


END;
END;


-- INLINE PARAM SOURCE DETAILS
BEGIN
DECLARE
    l_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
    l_vector_vals MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN

    l_params.trim(l_params.count);

    l_params.extend(1);
    l_params(1) := MGMT_JOB_PARAM_RECORD(null,1,null,null);
    l_params(1).param_name := 'destination_file_name';
    l_params(1).param_type := 1;
    l_params(1).scalar_value := '%source_file_name%';
    l_params(1).vector_value := null;
    INSERT INTO MGMT_JOB_VALUE_PARAMS(source_id, param_values, action) 
  SELECT source_id, l_params, 'none'     FROM MGMT_JOB_PARAM_SOURCE WHERE job_type_id=l_job_type_id       AND source_index=8;
END;
END;


-- ENTRIES FOR STEPSET CheckSkipArchive
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'CheckSkipArchive', 3, null, null, 1, 'main', 2, 'skip_archive', null, null, null, null, 1, 'main', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEPSET transferFileSteps
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'transferFileSteps', 2, null, null, 3, 'CheckSkipArchive', 3, null, null, 'true', null, null, 1, 'CheckSkipArchive', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP createDestinationDirectory
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'createDestinationDirectory', 1, null, null, 1, 'transferFileSteps', 2, null, null, null, null, null, 0, 'transferFileSteps', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP createDestinationDirectory
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestinationDirectory', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestinationDirectory', 'targetName', 1, 0, '%dest_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestinationDirectory', 'targetType', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestinationDirectory', 'username', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestinationDirectory', 'password', 1, 0, '%destPassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'createDestinationDirectory', 'input', 1, 0, '
              
                use File::Path;
                $dir = ''%destination_directory%'';
                $dir =~ s/\\/\//g;
                $return = chdir($dir);
           			if ($return==0)
           			{
             			print "Creating destination directory: $dir.\n";
             			mkpath("$dir",0,0700);
           			}
                
               
                chdir($dir) or die ( "Directory creation failed. $!" );
                print "Directory created successfully.\n";
              
            ', null, null );


END;
END;


-- ENTRY FOR NESTED JOB transferFile
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'transferFile';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'PAFFileTransferImpl', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'transferFile', 12, 'PAFFileTransferImpl', null, 7, 'createDestinationDirectory', 1, null, null, null, l_gen_iterate_param, null, 0, 'transferFileSteps', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'transferFile', 6, null, null, 7, 'transferFile', 12, null, null, null, l_gen_iterate_param, null, 1, 'transferFileSteps', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'transferFile', 2, null, null, 6, 'transferFile', 6, null, null, null, null, null, 1, 'transferFile', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'transferFile', 7, 'PAFFileTransferImpl', null, 1, 'transferFile', 2, null, null, null, l_gen_iterate_param, null, 0, 'transferFile', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'transferFile', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'transferFile', 7, 'PAFFileTransferImpl', null, 7, 'createDestinationDirectory', 1, null, null, null, null, null, 0, 'transferFileSteps', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP transferFile
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferFile', 'source_target_name', 1, 0, '%source_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferFile', 'source_target_type', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferFile', 'dest_target_name', 1, 0, '%dest_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferFile', 'dest_target_type', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferFile', 'source_file_name', 1, 0, '%source_directory%/%source_file_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferFile', 'sourceUsername', 1, 0, '%sourceUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferFile', 'sourcePassword', 1, 0, '%sourcePassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferFile', 'destination_file_name', 1, 0, '%destination_directory%/%destination_file_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferFile', 'destUsername', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferFile', 'destPassword', 1, 0, '%destPassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferFile', 'ftp_transfer', 1, 0, '%ftp_transfer%', null, null );


END;
END;


-- ENTRIES FOR STEPSET transferArchiveSteps
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'transferArchiveSteps', 2, null, null, 3, 'CheckSkipArchive', 3, null, null, 'false', null, null, 1, 'CheckSkipArchive', null, null, 1, 0, 0, 0, null, null, -1 );

-- ENTRIES FOR STEP prepareArchive
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'prepareArchive', 1, null, null, 1, 'transferArchiveSteps', 2, null, null, null, null, null, 0, 'transferArchiveSteps', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP prepareArchive
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareArchive', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareArchive', 'targetName', 1, 0, '%source_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareArchive', 'targetType', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareArchive', 'username', 1, 0, '%sourceUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareArchive', 'password', 1, 0, '%sourcePassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareArchive', 'input', 1, 0, '
				          
				           use File::Path;
				           print "Creating temp directory on source target... ";
				           $dir1 = ''%staging_area%/PAF'';
				           $dir1 =~ s/\\/\//g;
				           mkpath "$dir1";
				           chmod 0777, "$dir1";
				           $dir2 = ''%temp%'';
				           $dir2 =~ s/\\/\//g;
				           $return_val = mkpath("$dir2",0,0700);
				           if ($return_val == 0)
				           {
				               print "failed.\n";
					       exit 1;
					   }
				           print "created: $dir2\n";
				          
				        ', null, null );


END;
END;


-- ENTRIES FOR STEP doArchive
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'doArchive', 1, null, null, 7, 'prepareArchive', 1, null, null, null, null, null, 0, 'transferArchiveSteps', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP doArchive
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doArchive', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doArchive', 'targetName', 1, 0, '%source_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doArchive', 'targetType', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doArchive', 'username', 1, 0, '%sourceUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doArchive', 'password', 1, 0, '%sourcePassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doArchive', 'input', 1, 0, '
			          
			           $dir2 = ''%temp%'';
			           $dir2 =~ s/\\/\//g;
			           $src_dir = ''%source_directory% '';
			           chop $src_dir;
			           $return = chdir($src_dir);
			           print "cd $src_dir\n";
			           if ($return==0)
			           {
			               print "Failed to cd to $src_dir\n";
			               exit 1;
			           }
			           print ''%archive_command%''." $dir2/%archive_filename% %source_file_list%\n";
			           system(''%archive_command%''." $dir2/%archive_filename% %source_file_list%");
			           if ($? >> 8 != 0)
			           {
			               print "Archive command execution failed.\n";
				       exit 1;
				   }
			           print "Successfully executed the archive command.\n";
			          
			        ', null, null );


END;
END;


-- ENTRIES FOR STEP prepareTransfer
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'prepareTransfer', 1, null, null, 7, 'doArchive', 1, null, null, null, null, null, 0, 'transferArchiveSteps', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP prepareTransfer
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareTransfer', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareTransfer', 'targetName', 1, 0, '%dest_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareTransfer', 'targetType', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareTransfer', 'username', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareTransfer', 'password', 1, 0, '%destPassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'prepareTransfer', 'input', 1, 0, '
			          
			           use File::Path;
			           print "Creating temp directory on destination target... ";
			           $dir1 = ''%staging_area%/PAF'';
			           $dir1 =~ s/\\/\//g;
			           mkpath "$dir1";
			           chmod 0777, "$dir1";
			           $dir2 = ''%temp%d'';
			           $dir2 =~ s/\\/\//g;
			           $return_val = mkpath("$dir2",0,0700);
			           if ($return_val == 0)
			           {
			               print "failed.\n";
				       exit 1;
				   }
			           print "created: $dir2\n";
			          
			        ', null, null );


END;
END;


-- ENTRY FOR NESTED JOB transferArchive
BEGIN
DECLARE
    l_gen_iterate_param RAW(16) := SYS_GUID();
    l_temp_stepset_name VARCHAR(96) := SYS_GUID() || 'transferArchive';
    l_gen_stepset_name VARCHAR(64) := substr(l_temp_stepset_name, 1, 64);
BEGIN
    IF MGMT_JOB_ENGINE.is_nested_flatten_candidate(l_job_type_id, 'PAFFileTransferImpl', TRUE) THEN
        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'transferArchive', 12, 'PAFFileTransferImpl', null, 7, 'prepareTransfer', 1, null, null, null, l_gen_iterate_param, null, 0, 'transferArchiveSteps', null, null, 1, null, 1, 1, null, null, 0 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'transferArchive', 6, null, null, 7, 'transferArchive', 12, null, null, null, l_gen_iterate_param, null, 1, 'transferArchiveSteps', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'transferArchive', 2, null, null, 6, 'transferArchive', 6, null, null, null, null, null, 1, 'transferArchive', null, null, 1, null, null, 0, null, null, -1 );

        INSERT INTO MGMT_JOB_EXECPLAN(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default, flattened_targets)  VALUES
	( l_job_type_id, 'transferArchive', 7, 'PAFFileTransferImpl', null, 1, 'transferArchive', 2, null, null, null, l_gen_iterate_param, null, 0, 'transferArchive', null, null, 1, 0, 1, 0, null, null, 1 );

        INSERT INTO MGMT_NESTED_JOB_TARGETS(job_type_id, step_name, step_type, target_name, target_type) VALUES
	( l_job_type_id, 'transferArchive', 12, l_gen_iterate_param, null );

    ELSE
        INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'transferArchive', 7, 'PAFFileTransferImpl', null, 7, 'prepareTransfer', 1, null, null, null, null, null, 0, 'transferArchiveSteps', null, null, 1, 0, 1, 0, null, null, -1 );

    END IF;

END;
END;


--  STEP PARAMETERS FOR STEP transferArchive
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferArchive', 'source_target_name', 1, 0, '%source_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferArchive', 'source_target_type', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferArchive', 'dest_target_name', 1, 0, '%dest_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferArchive', 'dest_target_type', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferArchive', 'source_file_name', 1, 0, '%temp%/%archive_filename%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferArchive', 'sourceUsername', 1, 0, '%sourceUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferArchive', 'sourcePassword', 1, 0, '%sourcePassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferArchive', 'destination_file_name', 1, 0, '%temp%d/%archive_filename%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferArchive', 'destUsername', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferArchive', 'destPassword', 1, 0, '%destPassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'transferArchive', 'ftp_transfer', 1, 0, '%ftp_transfer%', null, null );


END;
END;


-- ENTRIES FOR STEP doRestore
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'doRestore', 1, null, null, 7, 'transferArchive', 7, null, null, null, null, null, 0, 'transferArchiveSteps', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP doRestore
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doRestore', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doRestore', 'targetName', 1, 0, '%dest_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doRestore', 'targetType', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doRestore', 'username', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doRestore', 'password', 1, 0, '%destPassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'doRestore', 'input', 1, 0, '
	            
	           use File::Path;
	           $dest_dir = ''%destination_directory% '';
	           chop $dest_dir;
	           print "cd $dest_dir\n";
	           $return = chdir($dest_dir);
	           if ($return==0)
	           {
	             mkpath("$dest_dir",0,0700);
	           }
	           $return = chdir($dest_dir);
	           if ($return==0)
	           {
	               print "Failed to cd to $dest_dir\n";
	               exit 1;
	           }
	           $dir2 = ''%temp%d'';
	           $dir2 =~ s/\\/\//g;
	           print ''%restore_command%''." $dir2/%archive_filename%\n";
	           system(''%restore_command%''." $dir2/%archive_filename%");
	           if ($? >> 8 != 0)
	           {
	               print "Restore command execution failed.\n";
		       			 exit 1;
		   			}
	           print "Successfully executed the restore command.\n";
	           
	        ', null, null );


END;
END;


-- ENTRIES FOR STEP cleanupSource
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanupSource', 1, null, null, 2, 'doRestore', 1, null, null, null, null, null, 0, 'transferArchiveSteps', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP cleanupSource
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupSource', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupSource', 'targetName', 1, 0, '%source_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupSource', 'targetType', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupSource', 'username', 1, 0, '%sourceUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupSource', 'password', 1, 0, '%sourcePassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupSource', 'input', 1, 0, '
		        
		           use File::Path;
		           $dir = ''%temp%'';
		           $dir =~ s/\\/\//g;
		           rmtree("$dir",1,0);
		           print "Successfully deleted all leftover files and directories."
		        
		      ', null, null );


END;
END;


-- ENTRIES FOR STEP cleanupDestination
INSERT INTO mgmt_job_execplan(job_type_id, step_name, step_type, nested_job_type, nested_job_target_type, incoming_edge_type, origin_step_name, origin_step_type, switch_var_name, switch_var_index, switch_case_val, iterate_param, iterate_param_filter, num_children, stepset_name, stepset_status, command_name, restart_mode, all_params, all_targets, halt_on_failure,step_nlsid ,step_default,trusted)  VALUES
	( l_job_type_id, 'cleanupDestination', 1, null, null, 7, 'cleanupSource', 1, null, null, null, null, null, 0, 'transferArchiveSteps', null, 'remoteOp', 1, 0, 0, 0, null, null, -1 );

--  STEP PARAMETERS FOR STEP cleanupDestination
BEGIN
DECLARE
    l_vector_values MGMT_JOB_VECTOR_PARAMS := MGMT_JOB_VECTOR_PARAMS();
BEGIN
    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupDestination', 'remoteCommand', 1, 0, '%perlbin%/perl', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupDestination', 'targetName', 1, 0, '%dest_target_name%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupDestination', 'targetType', 1, 0, 'host', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupDestination', 'username', 1, 0, '%destUsername%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupDestination', 'password', 1, 0, '%destPassword%', null, null );

    INSERT INTO MGMT_JOB_STEP_PARAMS(job_type_id, step_name, param_name, parameter_type, encrypted, scalar_value, vector_value, value_of) VALUES
	( l_job_type_id, 'cleanupDestination', 'input', 1, 0, '
		        
		           use File::Path;
		           $dir = ''%temp%d'';
		           $dir =~ s/\\/\//g;
		           rmtree("$dir",1,0);
		           print "Successfully deleted all leftover files and directories."
		        
		      ', null, null );


END;
END;


-- DISPLAYINFO ENTRIES
INSERT INTO MGMT_JOB_TYPE_DISPLAY_INFO(job_type_id, nls_bundle,use_default_create_ui)  VALUES
	( l_job_type_id, 'oracle.sysman.pp.paf.ui.resource.PAResourceBundle', 0 );

-- Ensure that all existing scheduled executions use the new jobtype version
MGMT_JOB_ENGINE.reschedule_on_new_jobtype_ver(l_job_type_id);
-- Patch NLS information for backward-compatibility
MGMT_JOB_ENGINE.update_job_type_nls_info(l_job_type_id, l_job_type_name);

END;
END;


MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
EXCEPTION 
    WHEN OTHERS THEN 
        MGMT_JOB_ENGINE.fix_flatten_steps(FALSE); 
        RAISE; 
END; 
/
COMMIT;
SET DEFINE ON

SET SQLPREFIX ON

