Rem
Rem $Header: pa_out_of_box_102020.sql 28-oct-2006.02:24:21 milshah Exp $
Rem
Rem pa_out_of_box_102020.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      pa_out_of_box_102020.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    milshah     10/18/06 - Remove post 10.2.0.2 stuff and put it in
Rem                           pa_out_of_box_102030.sql. Delete register application
Rem                           for PatchOracleSoftware because it is already there in 
Rem                           10.2.0.1 schema
Rem    aloganda    10/10/06 - Adding new parameter 'platform' for
Rem                           StageAndApply_PA job
Rem    rsah        07/13/06 - Adding PatchCRSRolling. 
Rem    vsubrahm    06/27/06 - Adding Execute prereqs once again
Rem    rsah        03/17/06 - Fix for Bug: 5085061. 
Rem    rsah        06/09/06 - XbranchMerge rsah_bug-5089693 from 
Rem                           st_empp_10.2.0.1.0 
Rem    pdasika     03/13/06 - Renaming action to actions for syncing it with job Bug#4760725
Rem    vsubrahm    11/28/05 - Adding Execute Prereqs 
Rem    ranmath     09/30/05 - Remove duplicate JobType registration. 
Rem    ranmath     09/23/05 - Updated application type and NLS ids. 
Rem    ranmath     09/20/05 - Updated to add component type, quoting params,
Rem                           RAC DPs, etc.
Rem    mningomb    08/03/05 - Make changes for path of resource bundle 
Rem    mningomb    07/14/05 - mningomb_p_advisor
Rem    mningomb    07/12/05 - Created
Rem
DECLARE
  l_jobtype_guid  VARCHAR2(32);
BEGIN
 
MGMT_PAF_UTL.REGISTER_APPLICATION(
    p_name  => 'PatchOracleSoftware',
    p_description  => 'PATCH_ORACLE_SOFTWARE',
    p_app_url => '/em/console/pa/selUpdtComponent',
    p_resource_bundle_class_name => 'oracle.sysman.pp.pa.rb.PatchAdvisorResourceBundle'
  );

  MGMT_PAF_UTL.REGISTER_COMP_JOBTYPE_MAPPING(
    p_jobtype => 'StageAndApplyPatches_PA',
    p_component_subtype => 'SUB_OraSoftUpdate',
    p_description => 'Oracle Software Update',
    x_guid => l_jobtype_guid
  );

  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_param_name => 'oracle_home',
    p_implicit => 'Y',
    p_param_value => '${target.oraHome}'
  );
  
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_param_name => 'patchIDs',
    p_implicit => 'Y',
    p_param_value => '${getPatchingInfo( step.guid, ''patchIDs'')}'
  );
  
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_param_name => 'patchSrcs',
    p_implicit => 'Y',
    p_param_value => '${getPatchingInfo( step.guid, ''patchSrcs'')}'
  );
  
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_param_name => 'patchData',
    p_implicit => 'Y',
    p_param_value => '${getPatchingInfo( step.guid, ''patchData'')}'
  );

  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_param_name => 'actions',
    p_implicit => 'Y',
    p_param_value => '${getPatchingInfo( step.guid, ''actions'')}'
  );


  COMMIT;
END;
/
show errors;
