Rem
Rem $Header: ulnpatch_out_of_box_102040.sql 16-aug-2007.05:49:52 somukher Exp $
Rem
Rem ulnpatch_out_of_box_102040.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ulnpatch_out_of_box_102040.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    somukher    08/14/07 - removing entry for registering job command
Rem    tasingh     08/10/07 - Making an entry of GetULNChannels job
Rem    aloganda    07/17/07 - ULNPatching upgrade sql
Rem    aloganda    07/17/07 - Created
Rem

  SET ECHO ON
  SET FEEDBACK 1
  SET NUMWIDTH 10
  SET LINESIZE 80
  SET TRIMSPOOL ON
  SET TAB OFF
  SET PAGESIZE 100

  DECLARE
  l_jobtype_guid  VARCHAR2(32);
  BEGIN


  MGMT_PAF_UTL.REGISTER_APPLICATION(
      p_name  => 'ULNPatchLinux',
      p_description  => 'ULN_DESC',
      p_app_url => '/em/console/pa/ulnpatch/selStagingServer',
      p_resource_bundle_class_name => 'oracle.sysman.pp.pa.rb.ulnpatch.UlnResourceBundle'
      );

  MGMT_PAF_UTL.REGISTER_COMP_JOBTYPE_MAPPING(
      p_jobtype => 'DownloadLatestPkgs',
      p_component_subtype => 'SUB_OraSoftUpdate',
      p_description => 'Oracle Software Update',
      x_guid => l_jobtype_guid
      );

  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
      p_guid => l_jobtype_guid,
      p_param_name => 'scriptURN', 
      p_implicit => 'Y',
      p_param_value => '${data.scriptURN}'
      );


  MGMT_PAF_UTL.REGISTER_COMP_JOBTYPE_MAPPING(
      p_jobtype => 'GetULNChannels',
      p_component_subtype => 'SUB_OraSoftUpdate',
      p_description => 'Get the list of ULN channels subscribed for the stage server',
      x_guid => l_jobtype_guid
      );


  COMMIT;
  END;
  /
  show errors;
