REM drv: <create type="post_creation" pos="jobTypes_sql/pp_jobTypes.sql+"/>
Rem $Header: paf_clonejob_register.sql 03-nov-2006.23:36:18 zsamar Exp $
Rem
Rem paf_clonejob_register.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      paf_clonejob_register.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    zsamar      08/02/06 - Created
Rem
DECLARE
  l_jobtype_guid  VARCHAR2(32);
  l_group_filer_guid  VARCHAR2(32);
  l_group_cloning_guid  VARCHAR2(32);
 
BEGIN

 --register VolCloning job and parameters
  MGMT_PAF_UTL.REGISTER_JOBTYPE(
    p_jobtype => 'VolCloning',
    p_description => 'PAF_JOB_VOL_CLONING_DESCRIPTION@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_target_list_dependent => 'N',
    x_guid => l_jobtype_guid
  );
-- register Filer group
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM_GROUP(
    p_jobtype_guid => l_jobtype_guid,
    p_name => 'PA_VOL_CLONE_FILER_HDR@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_group_order => 1,
    x_guid => l_group_filer_guid
  );
-- register cloning group
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM_GROUP(
    p_jobtype_guid => l_jobtype_guid,
    p_name => 'PA_VOL_CLONE_CLONING_HDR@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_group_order => 2,
    x_guid => l_group_cloning_guid
  );

  -- register parameters for Filer
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_FILER_TARGET_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'filer_name',
    p_order => 1,
    p_group_guid => l_group_filer_guid,
    p_target_type => 'netapp_filer'
    
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_PRIV_USERNAME_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'priv_username',
    p_order => 2,
    p_group_guid => l_group_filer_guid
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_PRIV_PASSWORD_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'priv_passwd',
    p_secret_status => 'ENCRYPTED',
    p_order => 3,
    p_group_guid => l_group_filer_guid
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_PARENT_VOL_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'parent_volume',
    p_order => 4,
    p_group_guid => l_group_cloning_guid
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_NEW_VOL_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'new_volume',
    p_order => 5,
    p_group_guid => l_group_cloning_guid
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_HOSTS_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'hosts',
    p_order => 6,
    p_target_type_choice => 'MULTIPLE',
    p_target_type => 'host',	
    p_group_guid => l_group_cloning_guid
    
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_COMMANDS_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'filer_commands',
    p_param_value => 'vol clone create %new_volume% -s volume -b %parent_volume%; exportfs -io rw=%hosts% /vol/%new_volume%',
    p_order => 7,
    p_group_guid => l_group_cloning_guid
  );
 
 
  COMMIT;
END;
/
