REM drv: <create type="post_creation" pos="jobTypes_sql/pp_jobTypes.sql+"/>
Rem
Rem $Header: paf_jobstep_register.sql 17-jul-2007.01:23:56 rahgupta Exp $
Rem
Rem paf_jobstep_register.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      paf_jobstep_register.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rahgupta    07/17/07 - call paf_filetransfer_register_10204
Rem    ktamtoro    01/09/06 - XbranchMerge 
Rem                           ktamtoro_ui_bugs_4925024_4925037_4927434 from 
Rem                           main 
Rem    fantic      12/13/05 - XbranchMerge fantic_jobs_junits_051204 from main 
Rem    zsamar      12/05/05 - XbranchMerge zsamar_bug-4746852 from main 
Rem    ktamtoro    01/09/06 - XbranchMerge 
Rem                           ktamtoro_ui_bugs_4925024_4925037_4927434 from 
Rem                           main 
Rem    fantic      12/13/05 - XbranchMerge fantic_jobs_junits_051204 from main 
Rem    zsamar      12/05/05 - XbranchMerge zsamar_bug-4746852 from main 
Rem    ktamtoro    01/05/06 - Add display name to file transfer job parameters
Rem    fantic      12/06/05 - additional params for file transfer:
Rem                           source_file_list, archive_filename
Rem    zsamar      11/23/05 - Bug 4746852
Rem    zsamar      11/23/05 - Bug 4746852
Rem    fantic      11/15/05 - changing params for PAFFileTransfer
Rem    fantic      11/03/05 - seting default values for paf file transfer
Rem                           parameters
Rem    fantic      10/13/05 - simplify parameters for PAFFileTransfer
Rem    ktamtoro    09/12/05 - Remove unnecessary param values
Rem    fantic      09/06/05 - fantic_paf_jobs_050905
Rem    fantic      09/06/05 - Created
Rem
DECLARE
  l_jobtype_guid  VARCHAR2(32);
  l_group_source_guid  VARCHAR2(32);
  l_group_archive_guid  VARCHAR2(32);
  l_group_dest_guid  VARCHAR2(32);
BEGIN

 --register PAFFileTransfer job and parameters
  MGMT_PAF_UTL.REGISTER_JOBTYPE(
    p_jobtype => 'PAFFileTransfer',
    p_description => 'PAF_JOB_FILE_TRANSFER_DESCRIPTION@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_target_list_dependent => 'N',
    x_guid => l_jobtype_guid
  );

  -- register SOURCE group
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM_GROUP(
    p_jobtype_guid => l_jobtype_guid,
    p_name => 'PA_FILE_TRANSFER_SOURCE_HDR@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_group_order => 1,
    x_guid => l_group_source_guid
  );

  -- register ARCHIVE group
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM_GROUP(
    p_jobtype_guid => l_jobtype_guid,
    p_name => 'PA_FILE_TRANSFER_ARCHIVE_HDR@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_group_order => 2,
    x_guid => l_group_archive_guid
  );

  -- register DESTINATION group
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM_GROUP(
    p_jobtype_guid => l_jobtype_guid,
    p_name => 'PA_FILE_TRANSFER_DESTINATION_HDR@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_group_order => 3,
    x_guid => l_group_dest_guid
  );

  -- register parameters for SOURCE
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_SOURCE_TARGET_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'source_target_name',
    p_order => 1,
    p_group_guid => l_group_source_guid,
    p_target_type => 'host'
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_SOURCE_DIR_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'source_directory',
    p_order => 2,
    p_group_guid => l_group_source_guid
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_SOURCE_FILE_LIST_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'source_file_list',
    p_param_value => '*',
    p_order => 3,
    p_group_guid => l_group_source_guid
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_ARCHIVE_COMMAND_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'archive_command',
    p_param_value => '%emd_root%/bin/zip -r',
    p_order => 4,
    p_group_guid => l_group_archive_guid
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_ARCHIVE_FILENAME_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'archive_filename',
    p_param_value => 'archive.zip',
    p_order => 5,
    p_group_guid => l_group_archive_guid
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_DEST_TARGET_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'dest_target_name',
    p_order => 6,
    p_group_guid => l_group_dest_guid,
    p_target_type => 'host'
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_DEST_DIR_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'destination_directory',
    p_order => 7,
    p_group_guid => l_group_dest_guid
  );
  MGMT_PAF_UTL.REGISTER_JOBTYPE_PARAM(
    p_guid => l_jobtype_guid,
    p_name => 'PA_RESTORE_COMMAND_INPUT_PROMPT@oracle.sysman.pp.paf.ui.resource.PAResourceBundle',
    p_param_name => 'restore_command',
    p_param_value => '%emd_root%/bin/unzip -o',
    p_order => 8,
    p_group_guid => l_group_dest_guid
  );
  COMMIT;
END;
/

@&EM_SQL_ROOT/pp/latest/paf/paf_filetransfer_register_102040.sql

