REM drv: <create type="pkgdefs"/>
Rem
Rem $Header: empp/source/oracle/sysman/emdrep/sql/pp/latest/paf/paf_pkgdefs.sql /st_empp_10.2.0.4.2db11.2/1 2008/10/30 05:36:16 rahgupta Exp $
Rem
Rem paf_pkgdefs.sql
Rem
Rem Copyright (c) 2005, 2008, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      paf_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rahgupta    10/27/08 - Bug 7479325
Rem    zsamar      11/03/06 - 
Rem    ktamtoro    10/05/06 - Backport ktamtoro_bug-5381533 from main
Rem    rlemos      10/03/06 - Add procedure to register PAF notification rules
Rem    rahgupta    08/21/06 - add procedure to register device rule
Rem    rahgupta    08/18/06 - Create notification package
Rem    rahgupta    08/21/06 - XbranchMerge rahgupta_paf_job_updater_notify from
Rem                           st_empp_10.2
Rem    fantic      04/26/06 - adding procedure update_runtime_data
Rem    ktlaw       03/31/06 -
Rem    ktamtoro    03/02/06 - Add procedure to register group
Rem    ktlaw       02/02/06 - XbranchMerge ktlaw_bug-4997741 from main
Rem    ktamtoro    01/09/06 - XbranchMerge
Rem                           ktamtoro_ui_bugs_4925024_4925037_4927434 from
Rem                           main
Rem    ktamtoro    01/09/06 - XbranchMerge
Rem                           ktamtoro_ui_bugs_4925024_4925037_4927434 from
Rem                           main
Rem    ktlaw       01/26/06 -
Rem    ktamtoro    01/05/06 - Add display name to job parameter registration
Rem    fantic      11/17/05 - add proc/functions start_daemon, stop_daemon,
Rem                           daemon_status
Rem    ktamtoro    09/09/05 - Add secret paramater to REGISTER_JOBTYPE_PARAM
Rem    rahgupta    07/26/05 - Register job param takes implicit argument
Rem    ktlaw       07/13/05 -
Rem    ktlaw       06/14/05 - ktlaw_paf_update_0614
Rem    ktlaw       06/14/05 - Created
Rem

CREATE OR REPLACE PACKAGE MGMT_PAF_UTL AS

  -- API to register a component subtype to jobtype mapping
  -- returns a GUID for the jobtype to be used in further
  -- invocation of register_jobtype_param for registering
  -- the jobtype parameters
  -- @param p_jobtype the jobtype name
  -- @param p_component_subtype the software library component subtype
  -- @param OUT x_guid the GUID of the jobtype.
  PROCEDURE REGISTER_COMP_JOBTYPE_MAPPING
            (
               p_jobtype VARCHAR2,
               p_component_subtype VARCHAR2,
               p_description VARCHAR2 DEFAULT NULL,
               x_guid OUT VARCHAR2
            );

  -- API to register a jobtype
  -- returns a GUID for the jobtype to be used in further
  -- invocation of register_jobtype_param for registering
  -- the jobtype parameters
  -- @param p_jobtype the jobtype name
  -- @param p_description the jobtype description
  -- @param p_target_list_dependent if job requires a target to run or not 'Y' or 'N'
  --        defaults 'Y'
  -- @param OUT x_guid the GUID of the jobtype.
  PROCEDURE REGISTER_JOBTYPE
	    (
               p_jobtype VARCHAR2,
               p_description VARCHAR2 DEFAULT NULL,
               p_target_list_dependent CHAR DEFAULT 'Y',
               x_guid OUT VARCHAR2
            );

  -- API to register group for job parameters for the jobtype mapping
  -- @param p_jobtype_guid the GUID of the registered jobtype that the group is for
  -- @param p_name display name of the group
  -- @param p_description description of the group
  -- @param p_group_order display order of the group
  -- @param OUT x_guid the GUID of the new group.
  PROCEDURE REGISTER_JOBTYPE_PARAM_GROUP
            (
              p_jobtype_guid VARCHAR2,
              p_name         VARCHAR2,
              p_description  VARCHAR2 DEFAULT NULL,
              p_group_order  INTEGER DEFAULT 0,
              x_guid  OUT    VARCHAR2
            );

  -- API to register the job parameter for the jobtype mapping
  -- @param p_guid the GUID of the registered jobtype
  -- @param p_param_name the name of the parameter, this should be the
  --        same as the parameter name used in jobtype
  -- @param p_param_value, optional parameter value to indicate the
  --        expression for binding this parameter
  -- @param p_implicit if parameter is implicit or not 'Y' or 'N'
  --        defaults 'N'
  -- @param p_secret_status if parameter is secret or not 'ENCRYPTED' or 'NOT_ENCRYPTED' or NULL
  --        'ENCRYPTED' means that the parameter is secret and encrypted,
  --        'NOTENCRYPTED' means that the parameter is secret but not encrypted yet,
  --        and NULL means that the parameter is not a secret parameter,
  --        defaults NULL
  -- @param p_target_type if this parameter is to specify a target, then this
  --        defines the type of the target, NULL otherwise
  -- @param p_target_type_choice if this jobtype parameter needs multiple target
  --        selection then set this to 'MULTIPLE' else set it to 'SINGLE' 
  -- @param p_name the jobparam display name
  -- @param p_description the jobparam description
  -- @param p_order display order of the job parameter. It is recommended that
  --        this is the global order and not the order in a particular group
  -- @param p_group_guid GUID of the group that this parameter is in
  PROCEDURE REGISTER_JOBTYPE_PARAM
            (
              p_guid         VARCHAR2,
              p_param_name   VARCHAR2,
              p_param_value  VARCHAR2 DEFAULT NULL,
              p_implicit CHAR DEFAULT 'N',
              p_secret_status VARCHAR2 DEFAULT NULL,
              p_target_type VARCHAR2 DEFAULT NULL,
	      p_target_type_choice VARCHAR2 DEFAULT 'SINGLE',
              p_name         VARCHAR2 DEFAULT NULL,
              p_description  VARCHAR2 DEFAULT NULL,
              p_order         INTEGER DEFAULT 0,
              p_group_guid    VARCHAR2 DEFAULT NULL
            );

  -- API to register the procedure type
  -- @param p_name the name of the procedure type, this name will be use in the
  --        deployment procedure XML as the procedure type attribute
  -- @param p_description a short description of the type
  -- @param p_app_url the url of the application associated with the procedure type
  -- @param p_resource_bundle_class_name the fully qualified Java class name of the resource bundle for
  -- @param p_reinterviewable Enter 'Y' if your application supports saving and re-interviewing
  --        users. By specifying this, PAF will re-launch interview wizard of your application
  --        when users select a saved instance and run it.
  --        the assoicated application and deployment procedures
  PROCEDURE REGISTER_APPLICATION
            (
              p_name  VARCHAR2,
              p_description VARCHAR2,
              p_app_url     VARCHAR2,
              p_resource_bundle_class_name VARCHAR2,
              p_reinterviewable CHAR DEFAULT NULL
            );

  -- API to start the provisioning daemon
  -- @param p_period the period between individual daemon runs (in minutes)
  PROCEDURE START_DAEMON
            (
              p_period NUMBER DEFAULT 5
            );

  -- API to stop the provisioning daemon
  PROCEDURE STOP_DAEMON;

  -- API to get the status of the provisioning daemon
  -- @return integer indicating period of the daemon (in minutes). 0 is returned if daemon is not running
  FUNCTION DAEMON_STATUS RETURN INTEGER;

  PROCEDURE ENCRYPT_STRING
            (
               p_base_guid VARCHAR2 ,
               p_string VARCHAR2 ,
               x_guid OUT VARCHAR
            );

  PROCEDURE DECRYPT_STRING
            (
               p_guid VARCHAR2 ,
               x_value OUT VARCHAR
            );

  -- API to update runtime data
  -- @param p_job_exec_id the execution id of the job from which this API
  --        is being called
  -- @param p_variable_name name of variable to update in the runtime data
  -- @param p_variable_value value of variable to update in the runtime data
  PROCEDURE UPDATE_RUNTIME_DATA
            (
              p_job_exec_id  VARCHAR2,
              p_variable_name       VARCHAR2,
              p_variable_value     VARCHAR2
            );

END MGMT_PAF_UTL ;
/

CREATE OR REPLACE PACKAGE MGMT_PAF_AQ AS

    G_TIMEOUT   CONSTANT VARCHAR2(8)  := 'TIMEOUT' ;
    G_MSGNULL   CONSTANT VARCHAR2(8)  := 'MSGNULL' ;
    G_SUCCESS   CONSTANT VARCHAR2(8)  := 'SUCCESS' ;
    G_SERVER_DOWN   CONSTANT VARCHAR2(8)  := 'SRVDOWN' ;
    G_INVALID_ID   CONSTANT VARCHAR2(11)  := 'INVALID_ID' ;
    G_REQUEST_QUEUE CONSTANT VARCHAR2(64) := '&EM_REPOS_USER'||'.MGMT_PAF_REQUEST_Q' ;
    G_RESPONSE_QUEUE CONSTANT VARCHAR2(64) := '&EM_REPOS_USER'||'.MGMT_PAF_RESPONSE_Q' ;

    --
    --	ENQUEUE_REQUEST
    --  Enqueue request
    --  @param in   p_node_id    the node_id
    --  @param in   p_xml_data   the xml data string
    --  @param out  x_request_id the request id
    --
    PROCEDURE ENQUEUE_REQUEST
    (
        p_node_id           IN  VARCHAR2,
        p_xml_data          IN  VARCHAR2,
        x_request_id        OUT NOCOPY VARCHAR2,
        x_return_status     OUT NOCOPY VARCHAR2
    );

    --
    --	ENQUEUE_RESPONSE
    --  Enqueue response
    --  @param in   p_request_id the request id
    --  @param in   p_xml_data   the xml data string
    --
    PROCEDURE ENQUEUE_RESPONSE
    (
        p_node_id           IN  VARCHAR2,
        p_request_id        IN  VARCHAR2,
        p_xml_data          IN  VARCHAR2,
        x_return_status     OUT NOCOPY VARCHAR2
    );

    --
    --	DEQUEUE_REQUEST
    --  dequeue request
    --  @param in   p_node_id    the node id
    --  @param out  p_xml_data   the xml data string
    --
    PROCEDURE DEQUEUE_REQUEST
    (
        p_node_id           IN  VARCHAR2,
        p_wait              IN  NUMBER,
        x_xml_data          OUT NOCOPY VARCHAR2,
        x_request_id        OUT NOCOPY VARCHAR2,
        x_timestamp         OUT NOCOPY DATE,
        x_return_status     OUT NOCOPY VARCHAR2
    );

    --
    --	DEQUEUE_RESPONSE
    --  dequeue response, used by client
    --  @param in   p_request_id the request id
    --  @param in   p_wait       timeout
    --  @param out  x_xml_data   the xml data string
    --
    PROCEDURE DEQUEUE_RESPONSE
    (
        p_request_id        IN  VARCHAR2,
        p_wait              IN  NUMBER,
        x_xml_data          OUT NOCOPY VARCHAR2,
        x_return_status     OUT NOCOPY VARCHAR2
    );

    -- EXECUTE_SERVER_CMD
    -- execute a generic command
    -- @param in  p_cmd       the cmd xml
    -- @param in  p_server_id the server id
    -- @param out x_result    the return xml
    PROCEDURE EXECUTE_SERVER_CMD
    (
        p_cmd               IN  VARCHAR2,
        p_server_id         IN  VARCHAR2,
        x_result            OUT NOCOPY VARCHAR2,
        x_return_status     OUT NOCOPY VARCHAR2
    );
 /*
    PROCEDURE OMS_FAILOVER_CALLBACK
    (
        p_failover_id       IN NUMBER,
        p_last_updated      IN DATE
    );
*/
END MGMT_PAF_AQ;
/

CREATE OR REPLACE PACKAGE MGMT_PAF_NOTIF AS

  PAF_NOTIF_RULE_NAME constant VARCHAR2(64) := 'Provisioning Engine Notifier';
  PAF_NOTIF_RULE_DESC constant VARCHAR2(256) := 'System-generated notification rule for provisioning engine: Notifies the provisioning engine about any change in job status submitted by it.';

  PAF_NOTIF_PLSQL_DEVICE_NAME constant VARCHAR2(64) := 'Provisioning Job Updater';
  PAF_NOTIF_PLSQL_DEVICE_DESC constant VARCHAR2(256) := 'System generated notification method: pl/sql notication for provisioning jobs';

  PAF_PLSQL_PROC constant VARCHAR2(64) := 'MGMT_PAF_NOTIF.NOTIFY_PAF';

  PROCEDURE NOTIFY_PAF
    (
      p_job_status IN MGMT_NOTIFY_JOB
    );

  FUNCTION NOTIF_RULE_EXISTS
    RETURN INTEGER;

  FUNCTION TGT_TYPE_REG_WITH_NOTIF
    (
      p_target_type IN VARCHAR2
    )
    RETURN INTEGER;

  FUNCTION JOB_TYPE_REG_WITH_NOTIF
    (
      p_job_type IN VARCHAR2
    )
    RETURN INTEGER;

  FUNCTION TGT_JOB_TYPE_REG_WITH_NOTIF
    (
      p_target_type IN VARCHAR2,
      p_job_type IN VARCHAR2
    )
    RETURN INTEGER;

  FUNCTION PLSQL_DEVICE_EXISTS
    RETURN INTEGER;

  FUNCTION PLSQL_DEVICE_REG_WITH_NOTIF
    RETURN INTEGER;

  PROCEDURE REG_NOTIF ;

  PROCEDURE REG_NOTIF_RULE ;

  PROCEDURE REG_PLSQL_DEVICE;

  PROCEDURE REG_PLSQL_DEVICE_WITH_NOTIF;

  PROCEDURE REG_ALL_TGT_TYPES_WITH_NOTIF ;

  PROCEDURE REG_ALL_TGT_TYPES_WITH_NOTIF
    (
      p_job_type IN VARCHAR2
    );

  PROCEDURE REG_TGT_TYPE_WITH_NOTIF
    (
      p_target_type IN VARCHAR2
    );

  PROCEDURE REG_ALL_JOB_TYPES_WITH_NOTIF ;

  PROCEDURE REG_ALL_JOB_TYPES_WITH_NOTIF
    (
      p_target_type IN VARCHAR2
    );

  PROCEDURE REG_JOB_TYPE_WITH_NOTIF
    (
      p_job_type IN VARCHAR2
    );

  PROCEDURE REG_TGT_JOB_TYPE_WITH_NOTIF
    (
      p_target_type IN VARCHAR2,
      p_job_type IN VARCHAR2
    );

  PROCEDURE UNREG_NOTIF ;

  PROCEDURE UNREG_NOTIF_RULE;

  PROCEDURE UNREG_PLSQL_DEVICE;


  ---------------------------------------------------------
  --
  -- PAF Status Notification section
  --
  ---------------------------------------------------------

  PAF_STATUS_NOTIF_RULE_NAME constant VARCHAR2(64) := 'PAF Status Notification';
  PAF_STATUS_NOTIF_RULE_DESC constant VARCHAR2(256) := 'System-generated notification rule for Provisioning Advisor Framework: Notifies the instance creator of any status updates.';

  FUNCTION PAF_STATUS_NOTIF_RULE_EXISTS
    RETURN INTEGER;

  PROCEDURE REGISTER_PAF_STATUS_NOTIF_RULE;

  PROCEDURE UNREG_PAF_STATUS_NOTIF_RULE;

END MGMT_PAF_NOTIF;

/

show errors;



CREATE OR REPLACE PACKAGE MGMT_PAF_JOB_UTIL AS

  PROV_JOB_ID constant VARCHAR2(64) := 'PROV_JOB_ID';
  PROV_JOB_EXEC_ID constant VARCHAR2(64) := 'PROV_JOB_EXEC_ID';
  PROV_JOB_STATUS constant VARCHAR2(64) := 'PROV_JOB_STATUS';
  PROV_JOB_STATUS_BUCKET constant VARCHAR2(64) := 'PROV_JOB_STATUS_BUCKET';

  PROCEDURE UPDATE_PAF_JOB
    (  
      p_job_status IN SMP_EMD_NVPAIR_ARRAY 
    );

END MGMT_PAF_JOB_UTIL;

/

show errors;

