Rem
Rem $Header: paf_post_creation_102040.sql 02-oct-2007.15:30:55 rahgupta Exp $
Rem
Rem paf_post_creation_102040.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      paf_post_creation_102040.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rahgupta    10/02/07 - move content of
Rem                           paf_data_upgrade_102030_sudoshell_oneoff.sql to
Rem                           post creation
Rem    ptorreti    05/21/07 - For changing default staging area
Rem    ktamtoro    04/24/07 - Created
Rem


DECLARE
  NUM_ROWS NUMBER;

BEGIN
  --Changing PAF Default staging area
  SELECT count(*) into NUM_ROWS FROM MGMT_PARAMETERS WHERE PARAMETER_NAME = 'paf.stagingArea';
  
  IF NUM_ROWS = 0
  THEN
    INSERT INTO MGMT_PARAMETERS
    VALUES ( 'paf.stagingArea', '%emd_root%/EMStage',
             'Default staging area', 1 );
  ELSE
    UPDATE MGMT_PARAMETERS
    SET PARAMETER_VALUE  =  '%emd_root%/EMStage'
    WHERE MGMT_PARAMETERS.PARAMETER_NAME = 'paf.stagingArea';
  END IF;

  --Adding default value for shell command to MGMT_PARAMETERS
  SELECT count(*) into NUM_ROWS FROM MGMT_PARAMETERS WHERE PARAMETER_NAME = 'paf.shellCommand';
  IF NUM_ROWS = 0
  THEN
    INSERT INTO MGMT_PARAMETERS
        VALUES ( 'paf.shellCommand', '%perlbin%/perl',
                 'Default shell command to execute jobs', 1 );
  END IF;


  --Adding default value for shell type to MGMT_PARAMETERS
  SELECT count(*) into NUM_ROWS FROM MGMT_PARAMETERS WHERE PARAMETER_NAME = 'paf.shellType';
  IF NUM_ROWS = 0
  THEN
    INSERT INTO MGMT_PARAMETERS
        VALUES ( 'paf.shellType', 'perl',
                 'Default shell type', 1 );
  END IF;

  mgmt_jobs.register_command('PAFStageComponentCommand',
                             'oracle.sysman.pp.paf.jobs.PAFStageComponentCommand',
                             MGMT_JOBS.LONG_RUNNING_COMMAND);

  --Adding default value for buffer size to MGMT_PARAMETERS
  SELECT count(*) into NUM_ROWS FROM MGMT_PARAMETERS WHERE PARAMETER_NAME = 'paf.streamBufferSize';
  IF NUM_ROWS = 0
  THEN
    INSERT INTO MGMT_PARAMETERS
        VALUES ( 'paf.streamBufferSize', '8192',
                 'Buffer size for InputStreams', 1 );  
  END IF;

  COMMIT;
EXCEPTION WHEN OTHERS THEN NULL;
END;
/

COMMIT;

