Rem $Header: paf_tables_102020.sql 31-mar-2006.16:15:30 ktlaw Exp $
Rem
Rem paf_tables.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      paf_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ktlaw       03/31/06 - 
Rem    ktamtoro    03/02/06 - Update MGMT_PAF_PARAM_GROUPS
Rem    ktamtoro    03/02/06 - Update name and description columns from
Rem                           Procedures table
Rem    ktlaw       06/13/05 - Created
Rem

CREATE TABLE MGMT_PAF_OMS_STATUS
(
  OMS_GUID              VARCHAR2(32) NOT NULL ,
  HOST_URL              VARCHAR2(256) NOT NULL ,
  STATUS                CHAR(1),
  LAST_UPDATED          DATE,
  CONSTRAINT MGMT_PAF_OMS_STAT_PK PRIMARY KEY(OMS_GUID),
  CONSTRAINT MGMT_PAF_OMS_STAT_UNIQ UNIQUE (HOST_URL)
) MONITORING;

CREATE TABLE MGMT_PAF_PARAM_GROUPS
(
  JOBTYPE_GUID          VARCHAR2(32) NOT NULL,
  GROUP_GUID            VARCHAR2(32) NOT NULL,
  NAME                  VARCHAR2(256) NOT NULL,
  DESCRIPTION           VARCHAR2(2000) ,
  GROUP_ORDER           INTEGER DEFAULT 0,
  CONTENT0     VARCHAR2(2000),
  CONTENT1     VARCHAR2(2000),
  CONTENT2     VARCHAR2(2000),
  CONTENT3     VARCHAR2(2000),
  CONTENT4     VARCHAR2(2000),
  CONTENT5     VARCHAR2(2000),
  CONTENT6     VARCHAR2(2000),
  CONTENT7     VARCHAR2(2000),
  CONSTRAINT MGMT_PAF_PGROUPS_PK PRIMARY KEY(GROUP_GUID),
  CONSTRAINT MGMT_PAF_PGROUPS_FK FOREIGN KEY( JOBTYPE_GUID )
        REFERENCES MGMT_PAF_JOBTYPES( JOBTYPE_GUID ) ON DELETE CASCADE
) MONITORING;

CREATE TABLE MGMT_PAF_PAR_FILES
(
  PAR_GUID            VARCHAR2(32) NOT NULL,
  FILENAME            VARCHAR2(512),
  APPLICATION_GUID    VARCHAR2(32),
  FILE_PATH           VARCHAR2(2000),
  VERSION             VARCHAR2(32),
  CREATED             DATE,
  LAST_UPDATED        DATE,
  CONTENT0     VARCHAR2(2000),
  CONTENT1     VARCHAR2(2000),
  CONTENT2     VARCHAR2(2000),
  CONTENT3     VARCHAR2(2000),
  CONTENT4     VARCHAR2(2000),
  CONTENT5     VARCHAR2(2000),
  CONTENT6     VARCHAR2(2000),
  CONTENT7     VARCHAR2(2000),
  CONSTRAINT MGMT_PAF_PAR_PK PRIMARY KEY(PAR_GUID)
) MONITORING;


ALTER TABLE MGMT_PAF_INSTANCES
  ADD ( OMS_GUID     VARCHAR2(32),
        CONTENT0     VARCHAR2(2000),
        CONTENT1     VARCHAR2(2000),
        CONTENT2     VARCHAR2(2000),
        CONTENT3     VARCHAR2(2000),
        CONTENT4     VARCHAR2(2000),
        CONTENT5     VARCHAR2(2000),
        CONTENT6     VARCHAR2(2000),
        CONTENT7     VARCHAR2(2000)
      );

ALTER TABLE MGMT_PAF_PROCEDURES
  ADD ( HELPSET      VARCHAR2(512),
        CONTENT0     VARCHAR2(2000),
        CONTENT1     VARCHAR2(2000),
        CONTENT2     VARCHAR2(2000),
        CONTENT3     VARCHAR2(2000),
        CONTENT4     VARCHAR2(2000),
        CONTENT5     VARCHAR2(2000),
        CONTENT6     VARCHAR2(2000),
        CONTENT7     VARCHAR2(2000)
      );

ALTER TABLE MGMT_PAF_PROCEDURES
  MODIFY ( NAME         VARCHAR2(4000),
           DESCRIPTION  VARCHAR2(4000)
         );

ALTER TABLE MGMT_PAF_APPLICATIONS
  ADD ( INTERVIEWABLE  CHAR(1),
        CONTENT0     VARCHAR2(2000),
        CONTENT1     VARCHAR2(2000),
        CONTENT2     VARCHAR2(2000),
        CONTENT3     VARCHAR2(2000),
        CONTENT4     VARCHAR2(2000),
        CONTENT5     VARCHAR2(2000),
        CONTENT6     VARCHAR2(2000),
        CONTENT7     VARCHAR2(2000)
      );

ALTER TABLE MGMT_PAF_JOBTYPE_PARAMS
  ADD ( PARAM_ORDER   INTEGER DEFAULT 0,
        PARAM_GROUP   VARCHAR2(32) ,
        CONTENT0     VARCHAR2(2000),
        CONTENT1     VARCHAR2(2000),
        CONTENT2     VARCHAR2(2000),
        CONTENT3     VARCHAR2(2000),
        CONTENT4     VARCHAR2(2000),
        CONTENT5     VARCHAR2(2000),
        CONTENT6     VARCHAR2(2000),
        CONTENT7     VARCHAR2(2000)
      );

ALTER TABLE MGMT_PAF_JOBTYPES
  ADD (
        CONTENT0     VARCHAR2(2000),
        CONTENT1     VARCHAR2(2000),
        CONTENT2     VARCHAR2(2000),
        CONTENT3     VARCHAR2(2000),
        CONTENT4     VARCHAR2(2000),
        CONTENT5     VARCHAR2(2000),
        CONTENT6     VARCHAR2(2000),
        CONTENT7     VARCHAR2(2000)
      );

ALTER TABLE MGMT_PAF_STATES
  ADD (
        CONTENT0     VARCHAR2(2000),
        CONTENT1     VARCHAR2(2000),
        CONTENT2     VARCHAR2(2000),
        CONTENT3     VARCHAR2(2000),
        CONTENT4     VARCHAR2(2000),
        CONTENT5     VARCHAR2(2000),
        CONTENT6     VARCHAR2(2000),
        CONTENT7     VARCHAR2(2000)
      );

ALTER TABLE MGMT_PAF_COMP_JOBTYPE_MAPPINGS
  ADD (
        CONTENT0     VARCHAR2(2000),
        CONTENT1     VARCHAR2(2000),
        CONTENT2     VARCHAR2(2000),
        CONTENT3     VARCHAR2(2000),
        CONTENT4     VARCHAR2(2000),
        CONTENT5     VARCHAR2(2000),
        CONTENT6     VARCHAR2(2000),
        CONTENT7     VARCHAR2(2000)
      );

CREATE TABLE MGMT_PAF_ENCRYPTED_STRINGS
( 
  STR_GUID              VARCHAR2(32) NOT NULL ,
  BASE_GUID             VARCHAR2(32) NOT NULL ,
  ENCRYPTED             VARCHAR2(2000),
  LAST_UPDATED          DATE,
  CONSTRAINT MGMT_PAF_ENCRYPTED_PK PRIMARY KEY(STR_GUID)
) MONITORING;

