Rem $Header: pp_auto_aru_job_creation.sql 
Rem
Rem pp_auto_aru_job_creation.sql
Rem
Rem Copyright (c) 2003, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      pp_auto_aru_job_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Script to add the 'OpatchPatchUpdate_PA' job in the repository.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    sejain      06/18/07 - bug-6077339: pulling LRG fix
Rem    anursing    04/20/07 - Introducing missing Exception Handler - #6006865
Rem    mningomb    11/22/06 - 
Rem    milshah     11/14/06 - Add OPatch Update (daily) job to repository 
Rem

REM This script will add the 'OpatchPatchUpdate_PA' job in the repository.
set define off

declare
p_job_targets MGMT_JOB_TARGET_LIST := MGMT_JOB_TARGET_LIST();
p_job_params MGMT_JOB_PARAM_LIST := MGMT_JOB_PARAM_LIST();
p_purge_criterion_list MGMT_JOB_PURGE_CRITERION_LIST;
p_mgmt_job_vector MGMT_JOB_VECTOR_PARAMS;
p_schedule MGMT_JOB_SCHEDULE_RECORD;
p_bind_var_index NUMBER;
p_execution raw(16);
p_job raw(16);

begin
-- Send the default value so the job works Out-of-Box
p_job_params.extend(1);
    p_job_params(1) := MGMT_JOB_PARAM_RECORD('dump_dest', MGMT_JOBS.PARAM_TYPE_SCALAR, 'DumpDestNotSpecified', null);

-- Create a schedule to run the job daily.
p_schedule := mgmt_jobs.get_job_schedule_record(3, null, null, 0, 0, 1, null, null, 1, 0, 0, null);

-- Submit the job.
mgmt_jobs.submit_job('OPatch_Patch_Update_Job','Out Of The Box Job. Do Not Delete This Job!','OpatchPatchUpdate_PA', p_job_targets,p_job_params,p_schedule,p_job,p_execution,null,0,null,null);

-- We are going to purge the job on job type.
p_mgmt_job_vector := MGMT_JOB_VECTOR_PARAMS('OpatchPatchUpdate_PA');

-- Create a purge criteria to purge the job on Job_type
p_purge_criterion_list := MGMT_JOB_PURGE_CRITERION_LIST(MGMT_JOB_PURGE_CRITERION(2, 0, p_mgmt_job_vector, null));

-- Register the purge policy to purge the job executions which are more than a week old and which
-- satisfy the purge criteria created above.
mgmt_job_engine.register_purge_policy('OpatchPatchUpdate_PAPurgePolicy', 7, p_purge_criterion_list);
exception WHEN OTHERS then null;
end;
/

set define on

commit;
