REM drv: <create type="pkgbodys"/>
Rem
Rem $Header: ts_pkgbody.sql 27-nov-2006.21:14:34 svengali Exp $
Rem
Rem ts_pkgbody.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ts_pkgbody.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    svengali    11/27/06 - Changes to retrieve targets without version
Rem                           property
Rem    rsah        11/19/06 - Display targets without inventory also
Rem    rrawat      09/25/06 - Bug-5565631
Rem    rrawat      09/25/06 - Bug-5565631
Rem    rrawat      10/03/06 - Backport rrawat_bug-5565631 from main
Rem    svengali    09/01/06 - For rac db target get the cluster name instead of
Rem                           host name
Rem    aloganda    08/14/06 - Added a seperate function for host targets for OS
Rem                           patching
Rem    svengali    08/06/06 - set ispatched pased on all the selected patches
Rem    svengali    07/31/06 - Added an additional input parameter to target
Rem                           selector query to pass the patchID
Rem    tasingh     06/29/06 - Bug:5234163 Modify the advanced search query to 
Rem                           have Dictinct selection of records. 
Rem    tasingh     12/28/05 - Support Advanced Search
Rem    tasingh     12/16/05 - Use target specific property value for version 
Rem                           comparison instead of generic 'Version' string. 
Rem    tasingh     12/08/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

CREATE OR REPLACE PACKAGE BODY MGMT_TS_PKG
IS

  FUNCTION get_property_name(
   p_target_type in VARCHAR2,
   p_version in VARCHAR2
  ) RETURN VARCHAR2
  IS
   l_property_name VARCHAR2(40);
  BEGIN
   IF (p_target_type = 'cluster') THEN
      l_property_name := 'CRSVersion';
   ELSIF (p_target_type = 'oracle_database') THEN
      l_property_name := 'DBVersion';
   ELSIF (p_target_type = 'osm_instance') THEN
      l_property_name := 'DBVersion';
   ELSIF ((p_target_type = 'rac_database') AND (p_version LIKE '10.1.0'||'%')) THEN
      l_property_name := 'DBVersion';
   ELSE
      l_property_name := 'Version';
   END IF;
   RETURN l_property_name;
  END get_property_name;

  --
  -- Get an array of targets matching the simple search criteria.
  --
  FUNCTION get_targets(
    p_target_type in VARCHAR2,
    p_target_name in VARCHAR2,
    p_on_host     in VARCHAR2,
    p_version     in VARCHAR2,
    p_platform_id in VARCHAR2,
    p_patch_ids in MGMT_PATCHID_LIST
  ) RETURN OUTPUT_REF_CURSOR

  IS

  l_target_list  TS_REC_ARRAY := TS_REC_ARRAY( );
  l_result_cur   OUTPUT_REF_CURSOR;
  num_patches_applied INTEGER;
  is_patched VARCHAR2(1);
  hostName VARCHAR2(100);
  p_platform  VARCHAR2(25);
  p_version_var  VARCHAR2(25);

  BEGIN
    
    IF (p_platform_id = '%') THEN 
        p_platform := '%' ;
    ELSE
        p_platform := REPLACE(p_platform_id,'%',NULL);
    END IF;

   if (p_version = '%') then
    p_version_var := NULL;
   else
    p_version_var :=p_version;
   end if;

     
    FOR ts_rec IN (
      SELECT
        tgt.target_guid,
        tgt.target_type,
        tgt.type_display_name,
        tgt.target_name,
        tgt.display_name,
        tgt.host_name,
        tgt.emd_url,
        tgt.timezone_region,
        NVL( avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
        tgt_prop.property_value tgt_version,
        home.container_guid container_guid
      FROM
        MGMT_TARGETS tgt,
        MGMT_TARGET_PROPERTIES tgt_prop,
        MGMT_CURRENT_AVAILABILITY avail,
        MGMT_TARGETS host_tgt,
        MGMT_ECM_SNAPSHOT snap,
        MGMT_TARGET_PROPERTIES home_prop,
        MGMT_INV_CONTAINER home,
        MGMT_INV_CONTAINER_PROPERTY home_con_prop
      WHERE
        tgt.target_type = p_target_type
        AND upper( tgt.target_name) LIKE upper( p_target_name)
        AND upper( NVL( tgt.host_name, '%')) LIKE upper( p_on_host)
        AND tgt.target_guid = avail.target_guid (+)
        AND tgt.target_guid = tgt_prop.target_guid(+)
        AND tgt_prop.property_name(+) = decode( p_target_type, 'cluster', 'CRSVersion', 'oracle_database', 'DBVersion', 'osm_instance', 'DBVersion', 'rac_database','DBVersion','Version')
        AND (tgt_prop.property_value LIKE p_version OR p_version_var is null)
        AND (tgt.host_name=host_tgt.target_name)
        AND host_tgt.target_type = 'host'
        AND host_tgt.target_name = snap.target_name
        AND snap.snapshot_type = 'host_configuration'
        AND snap.target_type = 'host'
        AND snap.is_current = 'Y'
        AND tgt.target_guid = home_prop.target_guid
        AND home_prop.property_name ='OracleHome'
        AND home.snapshot_guid = snap.snapshot_guid 
        AND home.container_location = home_prop.property_value 
        AND home.container_type = 'O'
        AND home.container_guid = home_con_prop.container_guid (+)
        AND 'ARU_PLATFORM_ID' = home_con_prop.property_name (+)
        AND decode(home_con_prop.property_value ,
               null, decode(home.oui_platform,
                            610,    212,
                            87,     87,
                            197,    197,
                            2,      59,
                            211,    209,
                            110,    214,
                            46,     46,
                            912,    912,
                            208,    208,
                            453,    453,
                            23,     23,
                            173,    173
                           ),
                home_con_prop.property_value) LIKE p_platform
        union
-- get the targets for which there is no record in inventory table
      SELECT
        tgt.target_guid,
        tgt.target_type,
        tgt.type_display_name,
        tgt.target_name,
        tgt.display_name,
        tgt.host_name,
        tgt.emd_url,
        tgt.timezone_region,
        NVL( avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
        tgt_prop.property_value tgt_version,
        home.container_guid container_guid
      FROM
        MGMT_TARGETS tgt,
        MGMT_TARGET_PROPERTIES tgt_prop,
        MGMT_CURRENT_AVAILABILITY avail,
        MGMT_TARGETS host_tgt,
        MGMT_ECM_SNAPSHOT snap,
        MGMT_HC_OS_SUMMARY os_summ,
        MGMT_ARU_PLATFORMS aru_plat,
        MGMT_TARGET_PROPERTIES host_tgt_prop,
        MGMT_TARGET_PROPERTIES home_prop,
        MGMT_INV_CONTAINER home
      WHERE
        tgt.target_type = p_target_type
        AND upper( tgt.target_name) LIKE upper( p_target_name)
        AND upper( NVL( tgt.host_name, '%')) LIKE upper( p_on_host)
        AND tgt.target_guid = avail.target_guid (+)
        AND tgt.target_guid = tgt_prop.target_guid(+)
        AND tgt_prop.property_name(+) = decode( p_target_type, 'cluster', 'CRSVersion', 'oracle_database', 'DBVersion', 'osm_instance', 'DBVersion', 'rac_database','DBVersion','Version')
        --AND tgt_prop.property_name = get_property_name(p_target_type, p_version)
        AND ( tgt_prop.property_value LIKE p_version OR p_version_var is null)
        AND (tgt.host_name=host_tgt.target_name)
        AND host_tgt.target_type = 'host'
        AND host_tgt.target_name = snap.target_name
        AND snap.snapshot_type = 'host_configuration'
        AND snap.target_type = 'host'
        AND snap.is_current = 'Y'
        AND snap.snapshot_guid = os_summ.snapshot_guid
        AND host_tgt_prop.target_guid = host_tgt.target_guid
        AND host_tgt_prop.property_name = 'OS'
        AND aru_plat.em_os_name = host_tgt_prop.property_value
        AND os_summ.address_length_in_bits LIKE aru_plat.em_os_bitlength || '%'
        AND aru_plat.platform_id LIKE p_platform_id
        AND tgt.target_guid = home_prop.target_guid
        AND home_prop.property_name ='OracleHome'
        AND home.container_location(+) = home_prop.property_value 
        AND home.container_type(+) = 'O'
        AND home.container_location is null

    )

    LOOP
      l_target_list.extend;

      select count(*) into num_patches_applied from (select id as patch_id from mgmt_inv_patch where container_guid=ts_rec.container_guid) patches_applied, table(p_patch_ids) p where patches_applied.patch_id = p.patchID;

      if(num_patches_applied = p_patch_ids.count) then
          is_patched := 'Y';
      else
          is_patched :='N';
      end if;
      hostName := ts_rec.host_name;
      if( p_target_type = 'rac_database' ) then
        select property_value into hostName from mgmt_target_properties where target_guid=ts_rec.target_guid and property_name='ClusterName';
      end if;
      l_target_list(l_target_list.last) := TS_REC_TYPE(
        ts_rec.target_guid,
        ts_rec.target_type,
        ts_rec.type_display_name,
        ts_rec.target_name,
        ts_rec.display_name,
        hostName,
        ts_rec.emd_url,
        ts_rec.timezone_region,
        ts_rec.cur_status,
        ts_rec.tgt_version,
        is_patched
      );

    END LOOP;

    OPEN l_result_cur FOR
      SELECT * FROM TABLE( CAST( l_target_list AS TS_REC_ARRAY));

    RETURN l_result_cur;
  END get_targets;

-- function to get the target list for os patching

  FUNCTION get_os_targets(
    p_target_type in VARCHAR2,
    p_target_name in VARCHAR2,
    p_on_host     in VARCHAR2,
    p_version     in VARCHAR2,
    p_platform_id in VARCHAR2
  ) RETURN OUTPUT_REF_CURSOR

  IS

  l_target_list  TS_REC_ARRAY := TS_REC_ARRAY( );
  l_result_cur   OUTPUT_REF_CURSOR;
  num_patches_applied INTEGER;
  is_patched VARCHAR2(1);
  p_version_var  VARCHAR2(25);

  BEGIN

  if (p_version = '%') then
    p_version_var := NULL;
  else
    p_version_var :=p_version;
  end if;

    FOR ts_rec IN (
      SELECT
        tgt.target_guid,
        tgt.target_type,
        tgt.type_display_name,
        tgt.target_name,
        tgt.display_name,
        tgt.host_name,
        tgt.emd_url,
        tgt.timezone_region,
        NVL( avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
        tgt_prop.property_value tgt_version
      FROM
        MGMT_TARGETS tgt,
        MGMT_TARGET_PROPERTIES tgt_prop,
        MGMT_CURRENT_AVAILABILITY avail,
        MGMT_TARGETS host_tgt,
        MGMT_ECM_SNAPSHOT snap,
        MGMT_HC_OS_SUMMARY os_summ,
        MGMT_ARU_PLATFORMS aru_plat,
        MGMT_TARGET_PROPERTIES host_tgt_prop
      WHERE
        tgt.target_type = p_target_type
        AND upper( tgt.target_name) LIKE upper( p_target_name)
        AND upper( NVL( tgt.host_name, '%')) LIKE upper( p_on_host)
        AND tgt.target_guid = avail.target_guid (+)
        AND tgt.target_guid = tgt_prop.target_guid(+)
        AND tgt_prop.property_name(+) = decode( p_target_type, 'cluster', 'CRSVersion', 'oracle_database', 'DBVersion', 'osm_instance', 'DBVersion', 'rac_database','DBVersion','Version')
        AND ( tgt_prop.property_value LIKE p_version OR p_version_var is null)
        AND (tgt.host_name=host_tgt.target_name)
        AND host_tgt.target_type = 'host'
        AND host_tgt.target_name = snap.target_name
        AND snap.snapshot_type = 'host_configuration'
        AND snap.target_type = 'host'
        AND snap.is_current = 'Y'
        AND snap.snapshot_guid = os_summ.snapshot_guid
        AND host_tgt_prop.target_guid = host_tgt.target_guid
        AND host_tgt_prop.property_name = 'OS'
        AND aru_plat.em_os_name = host_tgt_prop.property_value
        AND os_summ.address_length_in_bits LIKE aru_plat.em_os_bitlength || '%'
        AND aru_plat.platform_id LIKE p_platform_id
    )

    LOOP
      l_target_list.extend;

      l_target_list(l_target_list.last) := TS_REC_TYPE(
        ts_rec.target_guid,
        ts_rec.target_type,
        ts_rec.type_display_name,
        ts_rec.target_name,
        ts_rec.display_name,
        ts_rec.host_name,
        ts_rec.emd_url,
        ts_rec.timezone_region,
        ts_rec.cur_status,
        ts_rec.tgt_version,
        'N'
      );

    END LOOP;

    OPEN l_result_cur FOR
      SELECT * FROM TABLE( CAST( l_target_list AS TS_REC_ARRAY));

    RETURN l_result_cur;
  END get_os_targets;
  --
  -- Get an array of targets matching the advanced search criteria.
  --
  FUNCTION get_targets_for_adv_search(
    p_member_target_type in VARCHAR2,
    p_member_target_name in VARCHAR2,
    p_on_host     in VARCHAR2,
    p_version     in VARCHAR2,
    p_platform_id in VARCHAR2,
    p_patch_ids in MGMT_PATCHID_LIST,
    p_comp_target_type in VARCHAR2,
    p_comp_target_name in VARCHAR2
  ) RETURN OUTPUT_REF_CURSOR

  IS

  l_target_list  TS_REC_ARRAY := TS_REC_ARRAY( );
  l_result_cur   OUTPUT_REF_CURSOR;
  num_patches_applied INTEGER;
  is_patched VARCHAR2(1);
  p_platform VARCHAR2(25);
  p_version_var  VARCHAR2(25);

  BEGIN
    
    IF (p_platform_id = '%') THEN 
        p_platform := '%' ;
    ELSE
        p_platform := REPLACE(p_platform_id,'%',NULL);
    END IF;

   if (p_version = '%') then
    p_version_var := NULL;
   else
    p_version_var :=p_version;
   end if;


    FOR ts_rec IN (
      SELECT DISTINCT
        tgt.target_guid,
        tgt.target_type,
        tgt.type_display_name,
        tgt.target_name,
        tgt.display_name,
        tgt.host_name,
        tgt.emd_url,
        tgt.timezone_region,
        NVL( avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
        tgt_prop.property_value tgt_version,
        home.container_guid container_guid
      FROM
        MGMT$TARGET_COMPOSITE comp_tgt,
        MGMT_TARGETS tgt,
        MGMT_TARGET_PROPERTIES tgt_prop,
        MGMT_CURRENT_AVAILABILITY avail,
        MGMT_TARGETS host_tgt,
        MGMT_ECM_SNAPSHOT snap,
        MGMT_TARGET_PROPERTIES home_prop,
        MGMT_INV_CONTAINER home,
        MGMT_INV_CONTAINER_PROPERTY home_con_prop
      WHERE
        upper( comp_tgt.composite_name) like upper( p_comp_target_name)
        AND comp_tgt.composite_type = p_comp_target_type
        AND upper( comp_tgt.member_target_name) like upper(p_member_target_name)
        AND comp_tgt.member_target_type = p_member_target_type
        AND comp_tgt.member_target_type = tgt.target_type
        AND upper( comp_tgt.member_target_name) = upper( tgt.target_name)
        AND upper( NVL( tgt.host_name, '%')) LIKE upper( p_on_host)
        AND tgt.target_guid = avail.target_guid (+)
        AND tgt.target_guid = tgt_prop.target_guid(+)
        AND tgt_prop.property_name(+) = decode( p_member_target_type, 'cluster', 'CRSVersion', 'oracle_database', 'DBVersion', 'osm_instance', 'DBVersion', 'Version')
        AND ( tgt_prop.property_value LIKE p_version OR p_version_var is null)
        AND (tgt.host_name = host_tgt.target_name)
        AND host_tgt.target_type = 'host'
        AND host_tgt.target_name = snap.target_name
        AND snap.snapshot_type = 'host_configuration'
        AND snap.target_type = 'host'
        AND snap.is_current = 'Y'
        AND tgt.target_guid = home_prop.target_guid
        AND home_prop.property_name ='OracleHome'
        AND home.snapshot_guid = snap.snapshot_guid 
        AND home.container_location = home_prop.property_value 
        AND home.container_type = 'O'
        AND home.container_guid = home_con_prop.container_guid (+)
        AND 'ARU_PLATFORM_ID' = home_con_prop.property_name (+)
        AND decode(home_con_prop.property_value ,
               null, decode(home.oui_platform,
                            610,    212,
                            87,     87,
                            197,    197,
                            2,      59,
                            211,    209,
                            110,    214,
                            46,     46,
                            912,    912,
                            208,    208,
                            453,    453,
                            23,     23,
                            173,    173
                           ),
                home_con_prop.property_value)  LIKE p_platform
   -- get targets without inventory
    union
      SELECT DISTINCT
        tgt.target_guid,
        tgt.target_type,
        tgt.type_display_name,
        tgt.target_name,
        tgt.display_name,
        tgt.host_name,
        tgt.emd_url,
        tgt.timezone_region,
        NVL( avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
        tgt_prop.property_value tgt_version,
        home.container_guid container_guid
      FROM
        MGMT$TARGET_COMPOSITE comp_tgt,
        MGMT_TARGETS tgt,
        MGMT_TARGET_PROPERTIES tgt_prop,
        MGMT_CURRENT_AVAILABILITY avail,
        MGMT_TARGETS host_tgt,
        MGMT_ECM_SNAPSHOT snap,
        MGMT_HC_OS_SUMMARY os_summ,
        MGMT_ARU_PLATFORMS aru_plat,
        MGMT_TARGET_PROPERTIES host_tgt_prop,
        MGMT_TARGET_PROPERTIES home_prop,
        MGMT_INV_CONTAINER home
      WHERE
        upper( comp_tgt.composite_name) like upper( p_comp_target_name)
        AND comp_tgt.composite_type = p_comp_target_type
        AND upper( comp_tgt.member_target_name) like upper(p_member_target_name)
        AND comp_tgt.member_target_type = p_member_target_type
        AND comp_tgt.member_target_type = tgt.target_type
        AND upper( comp_tgt.member_target_name) = upper( tgt.target_name)
        AND upper( NVL( tgt.host_name, '%')) LIKE upper( p_on_host)
        AND tgt.target_guid = avail.target_guid (+)
        AND tgt.target_guid = tgt_prop.target_guid(+)
        AND tgt_prop.property_name(+) = decode( p_member_target_type, 'cluster', 'CRSVersion', 'oracle_database', 'DBVersion', 'osm_instance', 'DBVersion', 'Version')
        AND ( tgt_prop.property_value LIKE p_version OR p_version_var is null )
        AND (tgt.host_name = host_tgt.target_name)
        AND host_tgt.target_type = 'host'
        AND host_tgt.target_name = snap.target_name
        AND snap.snapshot_type = 'host_configuration'
        AND snap.target_type = 'host'
        AND snap.is_current = 'Y'
        AND snap.snapshot_guid = os_summ.snapshot_guid
        AND host_tgt_prop.target_guid = host_tgt.target_guid
        AND host_tgt_prop.property_name = 'OS'
        AND aru_plat.em_os_name = host_tgt_prop.property_value
        AND os_summ.address_length_in_bits LIKE aru_plat.em_os_bitlength || '%'
        AND aru_plat.platform_id LIKE p_platform_id
        AND tgt.target_guid = home_prop.target_guid
        AND home_prop.property_name ='OracleHome'
        AND home.container_location(+) = home_prop.property_value 
        AND home.container_type(+) = 'O'
        AND home.container_location is null
    )

    LOOP
      l_target_list.extend;
      select count(*) into num_patches_applied from (select id as patch_id from mgmt_inv_patch where container_guid=ts_rec.container_guid) patches_applied, table(p_patch_ids) p where patches_applied.patch_id = p.patchID;

      if(num_patches_applied = p_patch_ids.count) then
          is_patched := 'Y';
      else
          is_patched :='N';
      end if;

      l_target_list(l_target_list.last) := TS_REC_TYPE(
        ts_rec.target_guid,
        ts_rec.target_type,
        ts_rec.type_display_name,
        ts_rec.target_name,
        ts_rec.display_name,
        ts_rec.host_name,
        ts_rec.emd_url,
        ts_rec.timezone_region,
        ts_rec.cur_status,
        ts_rec.tgt_version,
        is_patched
      );
    END LOOP;

    OPEN l_result_cur FOR
      SELECT * FROM TABLE( CAST( l_target_list AS TS_REC_ARRAY));

    RETURN l_result_cur;

  END get_targets_for_adv_search;
  --
  -- Get an array of targets matching the advanced search criteria for os patching.
  --
  FUNCTION get_os_targets_for_adv_search(
    p_member_target_type in VARCHAR2,
    p_member_target_name in VARCHAR2,
    p_on_host     in VARCHAR2,
    p_version     in VARCHAR2,
    p_platform_id in VARCHAR2,
    p_comp_target_type in VARCHAR2,
    p_comp_target_name in VARCHAR2
  ) RETURN OUTPUT_REF_CURSOR

  IS

  l_target_list  TS_REC_ARRAY := TS_REC_ARRAY( );
  l_result_cur   OUTPUT_REF_CURSOR;
  num_patches_applied INTEGER;
  is_patched VARCHAR2(1);
  p_version_var  VARCHAR2(25);


  BEGIN

  if (p_version = '%') then
   p_version_var := NULL;
  else
    p_version_var :=p_version;
  end if;

    FOR ts_rec IN (
      SELECT DISTINCT
        tgt.target_guid,
        tgt.target_type,
        tgt.type_display_name,
        tgt.target_name,
        tgt.display_name,
        tgt.host_name,
        tgt.emd_url,
        tgt.timezone_region,
        NVL( avail.current_status, MGMT_GLOBAL.G_STATUS_UNKNOWN) cur_status,
        tgt_prop.property_value tgt_version
      FROM
        MGMT$TARGET_COMPOSITE comp_tgt,
        MGMT_TARGETS tgt,
        MGMT_TARGET_PROPERTIES tgt_prop,
        MGMT_CURRENT_AVAILABILITY avail,
        MGMT_TARGETS host_tgt,
        MGMT_ECM_SNAPSHOT snap,
        MGMT_HC_OS_SUMMARY os_summ,
        MGMT_ARU_PLATFORMS aru_plat,
        MGMT_TARGET_PROPERTIES host_tgt_prop
      WHERE
        upper( comp_tgt.composite_name) like upper( p_comp_target_name)
        AND comp_tgt.composite_type = p_comp_target_type
        AND upper( comp_tgt.member_target_name) like upper(p_member_target_name)
        AND comp_tgt.member_target_type = p_member_target_type
        AND comp_tgt.member_target_type = tgt.target_type
        AND upper( comp_tgt.member_target_name) = upper( tgt.target_name)
        AND upper( NVL( tgt.host_name, '%')) LIKE upper( p_on_host)
        AND tgt.target_guid = avail.target_guid (+)
        AND tgt.target_guid = tgt_prop.target_guid(+)
        AND tgt_prop.property_name(+) = decode( p_member_target_type, 'cluster', 'CRSVersion', 'oracle_database', 'DBVersion', 'osm_instance', 'DBVersion', 'Version')
        AND ( tgt_prop.property_value LIKE p_version OR p_version_var is null)
        AND (tgt.host_name = host_tgt.target_name)
        AND host_tgt.target_type = 'host'
        AND host_tgt.target_name = snap.target_name
        AND snap.snapshot_type = 'host_configuration'
        AND snap.target_type = 'host'
        AND snap.is_current = 'Y'
        AND snap.snapshot_guid = os_summ.snapshot_guid
        AND host_tgt_prop.target_guid = host_tgt.target_guid
        AND host_tgt_prop.property_name = 'OS'
        AND aru_plat.em_os_name = host_tgt_prop.property_value
        AND os_summ.address_length_in_bits LIKE aru_plat.em_os_bitlength || '%'
        AND aru_plat.platform_id LIKE p_platform_id
    )

    LOOP
      l_target_list.extend;

      l_target_list(l_target_list.last) := TS_REC_TYPE(
        ts_rec.target_guid,
        ts_rec.target_type,
        ts_rec.type_display_name,
        ts_rec.target_name,
        ts_rec.display_name,
        ts_rec.host_name,
        ts_rec.emd_url,
        ts_rec.timezone_region,
        ts_rec.cur_status,
        ts_rec.tgt_version,
        'N'
      );
    END LOOP;

    OPEN l_result_cur FOR
      SELECT * FROM TABLE( CAST( l_target_list AS TS_REC_ARRAY));

    RETURN l_result_cur;

  END get_os_targets_for_adv_search;

END MGMT_TS_PKG;
/

show errors
