REM drv: <create type="pkgdefs"/>
Rem
Rem $Header: ts_pkgdefs.sql 14-aug-2006.03:46:30 aloganda Exp $
Rem
Rem ts_pkgdefs.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ts_pkgdefs.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    aloganda    08/14/06 - Added a seperate function for host targets for OS
Rem                           patching
Rem    svengali    08/06/06 - set is_patched based on all patches selected
Rem    svengali    07/31/06 - Added an additional input parameter to target
Rem                           selector query to pass the patchID
Rem    tasingh     12/28/05 - Support Advanced Search 
Rem    tasingh     12/08/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

CREATE OR REPLACE PACKAGE MGMT_TS_PKG
IS

TYPE OUTPUT_REF_CURSOR IS REF CURSOR;

  --
  -- NAME: get_targets
  --
  -- PACKAGE: mgmt_ts_pkg
  --
  -- PURPOSE:
  --   Get the targets matching the simple search criteria.
  --
  -- IN PARAMETERS:
  --   p_target_type VARCHAR2 the Target Type.
  --   p_target_name VARCHAR2 the Target Name.
  --   p_on_host     VARCHAR2 the host name on which the target is running.
  --   p_version     VARCHAR2 the target's version.
  --   p_platform_id VARCHAR2 the platform ID of the host on which target is
  --                          running.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  --
FUNCTION get_property_name(
  p_target_type in VARCHAR2,
  p_version     in VARCHAR2
) RETURN VARCHAR2;

FUNCTION get_os_targets(
  p_target_type in VARCHAR2,
  p_target_name in VARCHAR2,
  p_on_host     in VARCHAR2,
  p_version     in VARCHAR2,
  p_platform_id in VARCHAR2
) RETURN OUTPUT_REF_CURSOR;

FUNCTION get_targets(
  p_target_type in VARCHAR2,
  p_target_name in VARCHAR2,
  p_on_host     in VARCHAR2,
  p_version     in VARCHAR2,
  p_platform_id in VARCHAR2,
  p_patch_ids in MGMT_PATCHID_LIST
) RETURN OUTPUT_REF_CURSOR;

  --
  -- NAME: get_os_targets_for_adv_search
  --
  -- PACKAGE: mgmt_ts_pkg
  --
  -- PURPOSE:
  --   Get the targets matching the simple search criteria.
  --
  -- IN PARAMETERS:
  --   p_comp_target_type   VARCHAR2 the Composite Target Type.
  --   p_comp_target_name   VARCHAR2 the Composite Target Name.
  --   p_member_target_type VARCHAR2 the Member Target Type
  --   p_member_target_name VARCHAR2 the Member Target Name.
  --   p_on_host            VARCHAR2 the host name on which the member target
  --                        is running.
  --   p_version            VARCHAR2 the member target's version.
  --   p_platform_id        VARCHAR2 the platform ID of the host on which member
  --                        target is running.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  --
FUNCTION get_os_targets_for_adv_search(
  p_member_target_type in VARCHAR2,
  p_member_target_name in VARCHAR2,
  p_on_host     in VARCHAR2,
  p_version     in VARCHAR2,
  p_platform_id in VARCHAR2,
  p_comp_target_type in VARCHAR2,
  p_comp_target_name in VARCHAR2
) RETURN OUTPUT_REF_CURSOR;
  --
  -- NAME: get_targets_for_adv_search
  --
  -- PACKAGE: mgmt_ts_pkg
  --
  -- PURPOSE:
  --   Get the targets matching the simple search criteria.
  --
  -- IN PARAMETERS:
  --   p_comp_target_type   VARCHAR2 the Composite Target Type.
  --   p_comp_target_name   VARCHAR2 the Composite Target Name.
  --   p_member_target_type VARCHAR2 the Member Target Type
  --   p_member_target_name VARCHAR2 the Member Target Name.
  --   p_on_host            VARCHAR2 the host name on which the member target
  --                        is running.
  --   p_version            VARCHAR2 the member target's version.
  --   p_platform_id        VARCHAR2 the platform ID of the host on which member
  --                        target is running.
  --
  -- OUT PARAMETERS:
  --   None.
  --
  -- ERROR CODES:
  --   None.
  --
  -- NOTES:
  --   None.
  --
FUNCTION get_targets_for_adv_search(
  p_member_target_type in VARCHAR2,
  p_member_target_name in VARCHAR2,
  p_on_host     in VARCHAR2,
  p_version     in VARCHAR2,
  p_platform_id in VARCHAR2,
  p_patch_ids in MGMT_PATCHID_LIST,
  p_comp_target_type in VARCHAR2,
  p_comp_target_name in VARCHAR2
) RETURN OUTPUT_REF_CURSOR;

END;
/

show errors
