Rem
Rem $Header: ts_type.sql 06-aug-2006.04:32:55 svengali Exp $
Rem
Rem ts_type_10203.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ts_type.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    svengali    08/06/06 - Added a types MGMT_PATCHID and MGMT_PATCHID_LIST
Rem    svengali    08/01/06 - Addded a new column is_patchset
Rem    tasingh     12/09/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

DECLARE
 l_type_name VARCHAR2(30);
BEGIN

BEGIN
   select type_name into l_type_name from all_types where type_name='TS_REC_ARRAY';
   execute immediate 'drop type TS_REC_ARRAY';
EXCEPTION
  WHEN NO_DATA_FOUND THEN
    NULL;
END;


BEGIN
   select type_name into l_type_name from all_types where type_name='TS_REC_TYPE';
   execute immediate 'drop type TS_REC_TYPE';
EXCEPTION
  WHEN NO_DATA_FOUND THEN
    NULL;
END;


BEGIN
   select type_name into l_type_name from all_types where type_name='MGMT_PATCHID_LIST';
   execute immediate 'drop type MGMT_PATCHID_LIST';
EXCEPTION
  WHEN NO_DATA_FOUND THEN
    NULL;
END;


BEGIN
   select type_name into l_type_name from all_types where type_name='MGMT_PATCHID';
   execute immediate 'drop type MGMT_PATCHID';
EXCEPTION
  WHEN NO_DATA_FOUND THEN
    NULL;
END;

END;
/ 


create or replace type TS_REC_TYPE is OBJECT
  (
    target_guid         RAW(16),
    target_type         VARCHAR2(64),
    type_display_name   VARCHAR2(128),
    target_name         VARCHAR2(256),
    display_name        VARCHAR2(256),
    host_name           VARCHAR2(256),
    emd_url             VARCHAR2(1024),
    timezone_region     VARCHAR2(64),
    cur_status          NUMBER,
    property_value      VARCHAR2(1024),
    is_patched          VARCHAR2(10)
  );
/

create or replace type TS_REC_ARRAY is table of TS_REC_TYPE;
/

create or replace type MGMT_PATCHID is OBJECT
  (
    patchID varchar2(64)
  );
/
create or replace type MGMT_PATCHID_LIST is table of MGMT_PATCHID;
/
show errors;

