#!/usr/bin/perl
#
# hasdConfig.pl
#
# Copyright (c) 2002, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      hasdConfig.pl
#
#    DESCRIPTION
#
#
#    NOTES
#
# Usage:
#
#    MODIFIED   (MM/DD/YY)
#    jleys       12/10/08 - Fix olr info to allow emulated hosts
#    jleys       12/09/08 - Remove creation of config files, added for upgrade
#                           only
#    jleys       11/29/08 - Create config files if they do not exist
#    jleys       11/16/08 - Use use for crsconfig_lib
#    jleys       10/30/08 - Read params from params file
#    jleys       04/02/08 - Move guts to crsconfig_lib.pm
#    dpham       06/27/08 - add trace options & rerout to trace file (bug 6903750)
#    priagraw    04/11/08 - add gipc resource
#    jleys       04/01/08 - Disable reboot in dev mode
#    hkanchar    04/01/08 - Fix bug#6933794
#    hkanchar    03/27/08 - Update Copyright info
#    minzhu      03/24/08 - change asm owner
#    hkanchar    03/24/08 - Add Daemontype as the base type
#    hkanchar    03/24/08 - Use info from types
#    minzhu      03/21/08 - add an attr for cssd users
#    minzhu      03/03/08 - move attr to type file
#    smurala     02/21/08 - no group on windows
#    ahabbas     02/19/08 - add the ability to detect Multi-node emu
#    spommere    02/13/08 - remove tdf file after use
#    spommere    02/08/08 - create tdf in host-specific directory
#    smurala     01/16/08 - fix for windows
#    hkanchar    01/28/08 - Reenable ctssd
#    averhuls    01/23/08 - Add the usm resource.
#    agusev      01/11/08 - temporarily removed auto_start of ctssd
#    ysharoni    12/15/07 - add mdns, gpnp resources, port fixes
#    ysharoni    12/13/07 - add mdns, gpnp resources, port fixes
#    diguma      12/14/07 - changing the restart attempts for cssd 
#    hkanchar    12/07/07 - Add register type ASM
#    minzhu      11/12/07 - verify cssd.type
#    minzhu      11/09/07 - add ACL for cssdagent
#    minzhu      11/08/07 - change to cssuser
#    minzhu      10/26/07 - enable cssdagent excu
#    agusev      11/29/07 - set CHECK_INTERVAL to 0 for cssd to turn off the
#                           check action
#    hkanchar    10/29/07 - Use orarootagent and oraagent
#    rvenkate    10/22/07 - add asm resource
#    smurala     10/05/07 - bug_6445862
#    smurala     08/22/07 - set auto_start for cssd to always 
#    minzhu      08/09/07 - enable cssdagent
#    gdbhat      08/20/07 - Change the call signature for resource types
#    gdbhat      08/09/07 - Add support for SIHA(HAS)
#    hkanchar    08/08/07 - Remove start dep of crsd on evmd
#    samjo       08/01/07 - Add CTSS resource
#    hkanchar    06/29/07 - Update daemon.type location
#    jtellez     06/27/07 - fix bug 6153308
#    smurala     06/06/07 - Separate users for css, crs, evm
#    hkanchar    05/11/07 - Update types for oradaemonagent
#    rajayar     04/03/07 - replace username with $OWNER
#    rajayar     03/22/07 - register crsd, cssd and evmd
#    rajayar     03/16/07 - register cssd, crsd and evmd resources 
#    jtellez     03/12/07 - add creation of crs daemons
#    rajayar     02/13/07 - removed dummy type creation
#    sowong      02/13/07 - remove type creation for siha
#    jtellez     02/07/07 - fix runCommand
#    jtellez     02/07/07 - separate command from args in runCommand
#    jtellez     02/06/07 - massage paths
#    jtellez     02/04/07 - add service
#    rajayar     02/03/06 - Creation
#    jtellez     02/02/07 - Renamed and moved
#

use strict;
use Getopt::Long;
use English;
use Env;
use POSIX;
use Sys::Hostname;
use File::Spec::Functions;
use File::Basename;

push @INC, dirname ($0);

use crsconfig_lib;
use ConfigTest;

my $CRSCFG_TRACE_FILE;

my $rc = 0;
my $mode;          # has / crs    -- mandatory arg
my $owner;         # user /owner of the daemons  --mandatory arg..
my $grp;           # user pgroup
my $pusr;          # privileged user in case of shiphome / current user in case of ADE
my $hostname;

GetOptions('mode:s'        => \$mode,
           'owner:s'       => \$owner,
           'grp:s'         => \$grp,
           'pusr:s'        => \$pusr,
           'host=s'        => \$hostname,
           'debug'         => \$DEBUG
        );
$hostname=~s/\..*$//;

if ($mode eq  "" || $owner eq "" || $pusr eq "")
{
  print_usage();
  $rc = 1;
}
else {
  my $is_siha;
  if ($mode eq "has") { $is_siha = TRUE; }

  # Replace functions in the crsconfig_lib symbol table with test env
  # friendly functions
  ConfigTest::ModifySymbols();

  my $ORACLE_USER = $ENV{'ORACLE_USER'};
  my $superuser = check_SuperUser ();
  my $userdir   = $superuser;

  if (!$superuser || $OSNAME eq "MSWin32") {
    $userdir = $ORACLE_USER;
  }

  my %param_override =
    ( DIRPREFIX => catfile($ENV{'T_HAS_WORK'}, $userdir)
    );

  my $params_file = catfile($ENV{'T_HAS_WORK_GLOBAL'}, 'crsconfig_params');
  my $osdparams  = catfile($ENV{'T_HAS_WORK_GLOBAL'}, 's_crsconfig_defs');

  if (! -e $params_file) {
    my $template = catfile($ENV{'SRCHOME'}, 'has', 'install',
                           'crsconfig', 'crsconfig_params.sbs');
    CreateConfigFile($template, $params_file, \%param_override);
  }

  if (! -e $osdparams) {
    my $template = catfile($ENV{'SRCHOME'}, 'has', 'lib',
                           's_crsconfig_defs');
    CreateConfigFile($template, $osdparams, \%param_override);
  }

  $CRSCFG_TRACE_FILE = catfile($ENV{'T_HAS_WORK'}, 
                             "hasdconfig_${hostname}_$PID.log");

  my $cfg =
    crsconfig_lib->new(paramfile           => $params_file,
                       osdfile             => $osdparams,
                       IS_SIHA             => $is_siha,
                       crscfg_trace        => TRUE,
                       crscfg_trace_file   => $CRSCFG_TRACE_FILE,
                       HAS_USER            => $superuser,
                       HOST                => $hostname,
                       s_run_as_user_v2p   => \&ConfigTest::run_as_user,
                       s_run_as_user2_v2p  => \&ConfigTest::run_as_user2,
                       DEBUG               => 1
                      );

  if ($cfg->platform_family eq 'unix') {
    $cfg->params('OLRLOC', 'olr.loc.' . $cfg->HOST);
    $cfg->params('OLRCONFIG',
                 catfile($cfg->params('OLRCONFIGDIR'),
                         $cfg->params('OLRLOC')));
  }

  configure_hasd($mode, $hostname, $owner, $pusr, $grp);
}

exit $rc;

#----------------------------(  print_usage )-----------------------------#
#                                                                         #
#  FUNCTION:	print_usage                                               #
#                                                                         #
#  PURPOSE:	Prints the usage message for this program                 #
#                                                                         #
#-------------------------------------------------------------------------#
sub print_usage()
{
    print "USAGE: $PROGRAM_NAME [-mode has|crs  -owner <owner> -grp <group> -pusr <puser>]\n";
}
