/* Copyright (c) 2005, 2010, Oracle and/or its affiliates. 
All rights reserved. */

/*
   DESCRIPTION
    This defines all the Install Constants 

   MODIFIED    (MM/DD/YY)
    dschrein    02/16/10 - windows port range constants from client to install
                           constants
    dchriste    01/26/09 - Add ASM OS group defaults for validation
    poosrini    03/24/08 - 
    dschrein    03/03/08 - add demos
    wyou        02/18/08 - add string[] supported language,
    dschrein    02/14/08 - more client things
    dschrein    02/04/08 - add client
    msubbann    01/22/08 - default names for Sys OS groups
    poosrini    01/17/08 - HA option transition to CRS shiphome
    ssampath    11/26/07 - XbranchMerge ssampath_dummy_tb_txn from
                           st_install_tb
    msubbann    10/17/07 - Add product version variable
    vtapadia    09/13/07 - Added Default Inventory Location directory
    aqazi       12/12/06 - 
    bktripat    10/11/06 - Creation
 */
package oracle.install.library.util;

import oracle.install.commons.util.Version;

public interface InstallConstants 
{
	
	public static final String CRS_IVW_ERR_RB = "oracle.install.ivw.crs.resource.CRSErrorResID";
    public static final String CRS_IVW_DLG_RB = "oracle.install.ivw.crs.resource.CRSDialogLabelResID";
    public static final String DB_IVW_ERR_RB = "oracle.install.ivw.db.resource.DBErrorResID";
    public static final String DB_IVW_DLG_RB = "oracle.install.ivw.db.resource.DBDialogLabelResID";
    public static final String CLIENT_IVW_ERR_RB = "oracle.install.ivw.client.resource.ClientErrorResID";
    public static final String CLIENT_IVW_DLG_RB = "oracle.install.ivw.client.resource.ClientDialogLabelResID";
    public static final String COMMON_IVW_ERR_RB = "oracle.install.ivw.common.resource.CommonErrorResID";
    public static final String COMMON_IVW_DLG_RB = "oracle.install.ivw.common.resource.CommonDialogLabelResID";
    public static final String DEMOS_IVW_ERR_RB = "oracle.install.ivw.demos.resource.DemosErrorResID";
    public static final String DEMOS_IVW_DLG_RB = "oracle.install.ivw.demos.resource.DemosDialogLabelResID";
    
    public static final String COMMON_UTIL_ERR_RB = "oracle.install.library.resource.CommonErrorResID";
    public static final String OUI_LIBRARY_LOC  = "oracle.installer.library_loc";
    public static final String INVPTR_LOC     = "oracle.installer.invPtrLoc";
    public static final String SOURCE_LOC  = "oracle.installer.sourceLoc";
    public static final String SCRATCH_PATH  = "oracle.installer.scratchPath";
    /*public static final int MIN_FREE_DISK_SPACE_SWONLY = 2600;
    public static final int MIN_FREE_DISK_SPACE_CRS_SWONLY = 2200;
    public static final int MIN_FREE_DISK_SPACE_CLIENT = 1024;
    public static final int MIN_FREE_DISK_SPACE_DEMOS = 1024;*/
    public static final long ORADATA_DISK_SPACE_REQUIRED = 1800;
    
    public static final int MAX_ORACLE_HOME_NAME_LENGTH = 128;
    
    public static final String INVENTORY_LOCATION= "oraInventory";
    
    public static final Version VERSION = Version.parseVersion("@<DB_VERSION>@");

    public static final String SYSDBA_DEFAULT_NAME = "dba";
    public static final String SYSOPER_DEFAULT_NAME = "oper";
    public static final String SYSASM_DEFAULT_NAME = "asmadmin";
    public static final String ASM_SYSDBA_DEFAULT_NAME = "asmdba";
    public static final String ASM_SYSOPER_DEFAULT_NAME = "asmoper";
    public static final String [] OUI_SUPPORTED_LANGUAGES = {"en","fr","ar","bn","pt_BR","bg","fr_CA","ca","hr","cs","da","nl","ar_EG","en_GB","et","fi","de","el","iw","hu","is","in","it","ja","ko","es","lv","lt","ms","es_MX","no","pl","pt","ro","ru","zh_CN","sk","sl","es_ES","sv","th","zh_TW","tr","uk","vi"};
    public static final int PORT_NUMBER_LENGTH_CONSTANT=5;    
    public static final String  DEFAULT_LANGUAGE = "en";
    public static final String  CVUQDISK_RPM_NAME="cvuqdisk";
    public static final String  CVUQDISK_RPM_MIN_VERSION="0";
	public static final String GETSHAREDPARTITIONLISTCVU_CONTROL_PROPERTY="oracle.install.cvu.getSharedPartitionList";

    // Constants used for determining the default OraMTS Port Number
    // These represent the user-available range of ports on Windows
    public static final Integer WIN_PORT_NUMBER_RANGE_MIN=new Integer(49152);
    public static final Integer WIN_PORT_NUMBER_RANGE_MAX=new Integer(65535);
}
