# $Header: ASDBClone-Install-directives.pl 25-jan-2006.21:21:26 rattipal Exp $
#
# ASDBClone-Install-directives.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#     ASDBClone-Install-directives.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#     Install directive for use with App Server (AS) and Database Clone components 
#
#    NOTES
#    This directive creates the specified clone install user (if needed). This also creates clone home location and working directory.
#    In case NIS accounts are going to be used, the user creation step is not necessary.  
#
#    MODIFIED   (MM/DD/YY)
#    rattipal    25/01/06 - Creation
#


$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";
use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

main();

sub main()
{
    
#constants

    my $CLONE_USER   = "NAME_CloneUser";
    my $DEST_HOME  = "NAME_DestHomeLocation";
    my $WORKING_DIR = "NAME_DestWorkDir";
    
# Get all the properties specified by user during assignment creation time.

    my $m_cloneUser = get_oraComponentProperty($CLONE_USER);
    my $m_workingDir = get_oraComponentProperty($WORKING_DIR);
    my $m_dbcloneloc = get_oraComponentProperty($DEST_HOME);
    my $m_exitstatus = 0;

# Not needed if using NIS, only uncomment if user account needs to be created on host
    #my $m_encryptedpasswd = "XaEe2.h7j0qWs";
    #system("useradd -p $m_encryptedpasswd -g dba $m_cloneUser");

#Adding entry to sudo file
    my $m_sudo_entry="\n $m_cloneUser ALL=(ALL)  ALL";
    my $m_sudoers_path="/etc/sudoers";
    open OUT, ">>$m_sudoers_path" or die "Cannot open $m_sudoers_path  file : $!" ;
    print OUT "$m_sudo_entry";
    close OUT;

# Creating clone home location

    system("mkdir  -p $m_dbcloneloc");
    system("chown $m_cloneUser $m_dbcloneloc");
    system("chgrp dba $m_dbcloneloc");
    $m_exitstatus = $? >> 8;
    if ($m_exitstatus != 0)
    {
	print "\nFailed while creating $m_dbcloneloc directory with $m_cloneUser as owner  and dba as group..";
	exit $m_exitstatus;
    }
# Creating working directory
    
    system("mkdir -m 777 -p $m_workingDir");
    $m_exitstatus = $? >> 8;
    if ($m_exitstatus != 0)
    {
        print "\nFailed while creating $m_workingDir directory.";
        exit $m_exitstatus;
    }
    
}
