#!/usr/local/bin/perl
# 
# $Header: DB-SOFTWAREONLY-10.2.pl 09-nov-2005.05:39:07 rattipal Exp $
#
# DB-SOFTWAREONLY-10.2.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      DB-SOFTWAREONLY-10.2.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rattipal    11/09/05 - Creation
# 
$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";


main();

sub main()
{
    print "\nInstalling Database (Software Only)";
    my $exitstatus ;

    # Location of the Components dir.
    my $currentfolder_cmd="pwd";
    my $currentfolder=`$currentfolder_cmd`;
    chomp $currentfolder;
    print "\nCurrent folder is: $currentfolder";

    # Tar file associated with the component.
    my $binaryFile = get_oraComponentFilename();

    print "\nComponent binary filename is $binaryFile";
    my $installFilePath="$currentfolder/$binaryFile";
    print "\nComponent binary filepath is $installFilePath";


    # Constants
    my $ORACLE_HOME = "ORACLE_HOME";
    my $ORACLE_HOME_NAME = "ORACLE_HOME_NAME";
    my $INSTALL_TYPE = "INSTALL_TYPE";
    my $LANGUAGE = "LANGUAGE";
    my $INSTALL_USER = "INSTALL_USER";
    my $WORKING_DIR = "WORKING_DIR";

    # Get the property value specifed by the user.
    my $oracleHome = get_oraComponentProperty($ORACLE_HOME);
    my $oracleHomeName = get_oraComponentProperty($ORACLE_HOME_NAME);
    my $installType = get_oraComponentProperty($INSTALL_TYPE);
    my $language = get_oraComponentProperty($LANGUAGE);
    my $workingDir = get_oraComponentProperty($WORKING_DIR);
    my $installUser = get_oraComponentProperty($INSTALL_USER);

    my $logFile = "/tmp/db-install.out";
    my $defaultResponseFile = $workingDir."/Disk1/response/10.2DBSoftwareOnlyInstall.rsp";

    # Data Structure to hold property value.
    my %cmdLineParam;

    my $errorMsg = "";
    my $flag = 0;

    if (!($oracleHome=~/null/ || $oracleHome eq '')) 
    {
        $cmdLineParam{$ORACLE_HOME} = $oracleHome;
    }
    else
    {
    	$errorMsg = $errorMsg." $ORACLE_HOME";
	$flag = 1;
    }

    if (!($oracleHomeName=~/null/ || $oracleHomeName eq ''))
    {
        $cmdLineParam{$ORACLE_HOME_NAME} = $oracleHomeName;
    }
    else
    {
    	$errorMsg = $errorMsg." $ORACLE_HOME_NAME";
	$flag = 1;
    }

    if ($workingDir=~/null/ || $workingDir eq '')
    {
    	$errorMsg = $errorMsg." $WORKING_DIR";
	$flag = 1;
    }

    if ($installUser=~/null/ || $installUser eq '')
    {
    	$errorMsg = $errorMsg." $INSTALL_USER";
	$flag = 1;
    }


    if ($flag) {
	print "\nUser didnt specify $errorMsg. Specify as DB Component's property. Installation aborted. Exiting ....";
	exit 1;
    }

    if (!($installType=~/null/ || $installType eq ''))
    {
        $cmdLineParam{$INSTALL_TYPE} = $installType;
    }


    if (!($language=~/null/ || $language eq ''))
    {
        $cmdLineParam{"SELECTED_LANGUAGES"} = "{\"$language\"}";
        $cmdLineParam{"COMPONENT_LANGUAGES"} = "{\"$language\"}";
    }

    my $commandLine = &updateCommand(\%cmdLineParam);
    
    # Create the directory as install user.
    system("sudo -u $installUser mkdir -p $workingDir");  
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while creating $workingDir directory.";
        exit $exitstatus;
    }

    chdir $workingDir; 
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while changing the directory.";
        cleanup($workingDir, $installUser);
        exit $exitstatus;
    } 

    # Untar the shiphome as $installUser user.
    print "\nUntaring the DB Shiphome, This will take sometime. Please wait...";
    my $command = `sudo -u $installUser tar -zxvf $installFilePath`;
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while untaring the DB Shiphome.";
        cleanup($workingDir, $installUser);
        exit $exitstatus;
    }


    # Run runInstaller command.
    my $runInstaller = $workingDir."/Disk1/runInstaller -silent -ignoreSysPrereqs -waitForCompletion -noConfig $commandLine -responseFile $defaultResponseFile  > $logFile";

    print "\nExecuting runInstaller This will take sometime. Please wait...";
    print "\n$runInstaller";


    $command = `sudo -u $installUser $runInstaller`;
    $exitstatus = $? >> 8;
    
    if ($exitstatus != 0)
    {
        print "\nFailed while Executing runInstaller";
        print "\nSee log file:$logFile for details";
        cleanup($workingDir, $installUser);
        exit $exitstatus;
    }



    # run root.sh also 
    print "\nExecuting root.sh This will take sometime. Please wait...";

    my $rootExec=`$oracleHome/root.sh -silent -waitForCompletion`;
    $exitstatus = $? >> 8;                                                  

    if ($exitstatus != 0)
    {
        print "\n Failed while executing root.sh";
        cleanup($workingDir, $installUser);
        exit $exitstatus;
    }

    cleanup($workingDir, $installUser);
    print "\nSuccessfully Installed the DB";
    exit 0;
}

sub cleanup()
{
    my $workingDir = $_[0];
    my $installUser = $_[1];
    system("sudo -u $installUser rm -rf $workingDir");  

    my $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while removing $workingDir dir";
        exit $exitstatus;
    }
}

sub updateCommand()
{
    my $hashref = $_[0];
    my $command;
    while ( my ($key, $value) = each(%$hashref) ) {
        $command = "$command $key=\"$value\"";
    }
    return $command;
}

