# $Header: RACClone-Install-directive.pl 25-jan-2006.21:21:26 rattipal Exp $
#
# RACClone-Install-directive.pl
# 
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#     RACClone-Install-directive.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#    This directive creates clone home location and working directory with user rights to those.
#      
#
#    MODIFIED   (MM/DD/YY)
#    adeb    25/01/06 - Creation
#


$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";
use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

main();

sub main()
{
    
#constants

    my $CLONE_USER   = "NAME_CloneUser";
    my $DEST_HOME  = "NAME_DestHomeLocation";
    my $WORKING_DIR = "NAME_DestWorkDir";
    
# Get all the properties specified by user during assignment creation time.

    my $m_cloneUser = get_oraComponentProperty($CLONE_USER);
    my $m_workingDir = get_oraComponentProperty($WORKING_DIR);
    my $m_dbcloneloc = get_oraComponentProperty($DEST_HOME);
    my $m_exitstatus = 0;



    
# Creating clone home location

    system("mkdir  -p $m_dbcloneloc");
    system("chown $m_cloneUser $m_dbcloneloc");
    system("chgrp dba $m_dbcloneloc");
    $m_exitstatus = $? >> 8;
    if ($m_exitstatus != 0)
    {
	print "\nFailed while creating $m_dbcloneloc directory with $m_cloneUser as owner  and dba as group..";
	exit $m_exitstatus;
    }
# Creating working directory
    
    system("mkdir -m 777 -p $m_workingDir");
    $m_exitstatus = $? >> 8;
    if ($m_exitstatus != 0)
    {
        print "\nFailed while creating $m_workingDir directory.";
        exit $m_exitstatus;
    }
    
}
