# 
# $Header: disklayout-stage-directive.pl 09-oct-2006.02:09:27 rattipal Exp $
#
# disklayout_stage.pl
# 
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      disklayout_stage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rattipal    10/09/06 - XbranchMerge rattipal_final from
#                           st_emcore_10.2.0.1.0
#    rshetty     09/07/06 - making changes for RAID and LVM
#    pshroff     08/05/05 - pshroff_stagepath_dirs
#    pshroff     06/30/05 - Creation

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";
#require "provisionCommon.pl";

#Staging directive for disk layout component

main();

sub main()
{
    print "Creating kickstart file\n";
    
    createAndAppendToKickstart("\n#Disk Layout Part of Kickstart\n");
    createAndAppendToPreKickstart("\n#Pre Part of Kickstart for removal of partition entries\n");
    #appendToKickstart("clearpart --all --initlabel\n");
    #will be replaced by the following 
    appendToKickstart("zerombr yes\n");
    #root (/) partition information
    
    createPartitionEntry();	
    createRaidEntry();
    createLogicalVolumeGroupEntry();
    createLogicalVolumeEntry();		
    appendToKickstart("\n\n");
    
}

sub createPartitionEntry()
{
    my $diskDeviceNameProperty="NAME_Partitions[0].NAME_DiskDeviceName";
    
    my $diskDeviceName = get_oraComponentProperty($diskDeviceNameProperty);
    my $i = 0;
    
    while ($diskDeviceName)
    {
        my $fileSystemType = get_oraComponentProperty("NAME_Partitions[$i].NAME_FileSysType");
        my $partitionSize = get_oraComponentProperty("NAME_Partitions[$i].NAME_PartitionSize");
     
        my $partition_entry;
 
        $diskDeviceName =~ s/\/dev\///;
    
        if ($fileSystemType=~/FS_swap/)
        {
            $fileSystemType="swap"; 

            $partition_entry="part $fileSystemType --ondisk $diskDeviceName --size $partitionSize";
        }

	elsif ($fileSystemType=~/FS_unspecified/)
	{
		my $mountPoint = get_oraComponentProperty("NAME_Partitions[$i].NAME_MountPoint");
		$partition_entry="part $mountPoint --ondisk $diskDeviceName --size $partitionSize";
		
	}
	
	elsif ($fileSystemType=~/FS_Raid/)
	{
		my $mountPoint = get_oraComponentProperty("NAME_Partitions[$i].NAME_MountPoint");
		$mountPoint = "raid.". $mountPoint;
		
		$partition_entry="part $mountPoint --ondisk $diskDeviceName --size $partitionSize";
		
	}
	
	elsif ($fileSystemType=~/FS_LVM/)
	{
		my $mountPoint = get_oraComponentProperty("NAME_Partitions[$i].NAME_MountPoint");
		$mountPoint = "pv.". $mountPoint;
		
		$partition_entry="part $mountPoint --ondisk $diskDeviceName --size $partitionSize";
		
	}

	
       
       else
       {
           if ($fileSystemType=~/FS_ext3/)
           {
                $fileSystemType = "ext3";
           }
           else
           {
                if ($fileSystemType=~/FS_ext2/)
                {
                    $fileSystemType = "ext2";
                }
           }
           
           my $mountPoint = get_oraComponentProperty("NAME_Partitions[$i].NAME_MountPoint");
     
           $partition_entry="part $mountPoint --fstype $fileSystemType --ondisk $diskDeviceName --size $partitionSize";
          
        }
        print "partition entry to add for partition-$i is $partition_entry\n";
        appendToKickstart("$partition_entry\n");
 	
	#insert the entries for pre section here
   	my $preKickStartEntry = "dd if=/dev/zero of=/dev/$diskDeviceName bs=512 count=1";
        appendToPreKickstart("$preKickStartEntry\n");    
        # go for next partition ..
        $i = $i + 1;
        $diskDeviceNameProperty= "NAME_Partitions[$i].NAME_DiskDeviceName";
        $diskDeviceName = get_oraComponentProperty($diskDeviceNameProperty);
        if ($diskDeviceName eq "")
        {
            last;
        }
    }
 
}
sub createRaidEntry()
{
    my $mountPointProperty="NAME_RAIDs[0].NAME_MountPoint";
    
    my $mountPoint = get_oraComponentProperty($mountPointProperty);
    my $i = 0;
    
    while ($mountPoint)
    {
        my $fileSystemType = get_oraComponentProperty("NAME_RAIDs[$i].NAME_FileSysType");
	$fileSystemType=~s/FS_//;

	my $raidLevel = get_oraComponentProperty("NAME_RAIDs[$i].NAME_RAIDLevel");
	$raidLevel=~s/RAID_//;

	my $raidDeviceName = "md".$i;

        my $partition_entry;
 
    	my $j = 0;
	my $partition = get_oraComponentProperty("NAME_RAIDs[$i].NAME_Partitions[0]");
	my $partitionList = "";
	
	while($partition)
	{
		$partitionList = $partitionList . " " ."raid.". $partition;
		
		$j = $j + 1;
		$partition = get_oraComponentProperty("NAME_RAIDs[$i].NAME_Partitions[$j]");
	}
     
	if ($fileSystemType eq "swap")
	{
		$mountPoint =  $fileSystemType;
	}



        $partition_entry="raid $mountPoint --level $raidLevel --device $raidDeviceName --fstype $fileSystemType $partitionList ";
 	if ($fileSystemType eq "LVM")
	{
		$mountPoint =  "pv.".$mountPoint;

        	$partition_entry="raid $mountPoint --level $raidLevel --device $raidDeviceName  $partitionList ";
	}
         
        
        print "partition entry to add for partition-$i is $partition_entry\n";
        appendToKickstart("$partition_entry\n");
     
        # go for next raid device ..
        $i = $i + 1;
        $mountPoint = get_oraComponentProperty("NAME_RAIDs[$i].NAME_MountPoint");
        if ($mountPoint eq "")
        {
            last;
        }
    }
 
}

sub createLogicalVolumeGroupEntry()
{
    
    my $logicalVolumeGroupName = get_oraComponentProperty("NAME_LogicalVolumeGroups[0].NAME_LogicalGroupName");
    my $i = 0;
    
    while ($logicalVolumeGroupName)
    {

        my $partition_entry;
 
    	my $j = 0;
	my $partition = get_oraComponentProperty("NAME_LogicalVolumeGroups[$i].NAME_Partitions[$j]");
	my $partitionList = "";
	
	while($partition)
	{
		$partitionList = $partitionList . " " ."pv.". $partition;
		
		$j = $j + 1;
		$partition = get_oraComponentProperty("NAME_LogicalVolumeGroups[$i].NAME_Partitions[$j]");
	}
       	
	$j = 0;
	$partition = get_oraComponentProperty("NAME_LogicalVolumeGroups[$i].NAME_RAIDs[$j]");
	
	
	while($partition)
	{
		$partitionList = $partitionList . " " ."pv.". $partition;
		
		$j = $j + 1;
		$partition = get_oraComponentProperty("NAME_LogicalVolumeGroups[$i].NAME_RAIDs[$j]");
	} 

        $partition_entry="volgroup $logicalVolumeGroupName  $partitionList ";
          
        
        print "partition entry to add for partition-$i is $partition_entry\n";
        appendToKickstart("$partition_entry\n");
     
        # go for next logical volume group  ..
        $i = $i + 1;
        $logicalVolumeGroupName = get_oraComponentProperty("NAME_LogicalVolumeGroups[$i].NAME_LogicalGroupName");
        if ($logicalVolumeGroupName eq "")
        {
            last;
        }
    }
 
}

sub createLogicalVolumeEntry()
{
    
    my $logicalVolumeName = get_oraComponentProperty("NAME_LogicalVolumes[0].NAME_LogicalVolumeName");
    my $i = 0;
    
    while ($logicalVolumeName)
    {
    	my $mountPoint = get_oraComponentProperty("NAME_LogicalVolumes[$i].NAME_MountPoint");
	
        my $fileSystemType = get_oraComponentProperty("NAME_LogicalVolumes[$i].NAME_FileSysType");
	$fileSystemType=~s/FS_//;

	my $logicalGroupName = get_oraComponentProperty ("NAME_LogicalVolumes[$i].NAME_LogicalGroupName");
	my $partitionSize = get_oraComponentProperty ("NAME_LogicalVolumes[$i].NAME_PartitionSize");
	
        my $partition_entry;
 
     
	if ($fileSystemType eq "swap")
	{
		$mountPoint =  $fileSystemType;
	}

        $partition_entry="logvol $mountPoint --vgname $logicalGroupName --size $partitionSize --fstype $fileSystemType --name $logicalVolumeName ";
          
        
        print "partition entry to add for partition-$i is $partition_entry\n";
        appendToKickstart("$partition_entry\n");
     
        # go for next logical volume ..
        $i = $i + 1;
        $logicalVolumeName = get_oraComponentProperty("NAME_LogicalVolumes[$i].NAME_LogicalVolumeName");
        if ($logicalVolumeName eq "")
        {
            last;
        }
    }
 
}



sub appendToKickstart()
{
    my ($entry)=@_;
    
    my $ksfilename="disklayout-kickstart";
    print "Writing entry $entry to kickstart file\n";
    
    open OUT, ">>$ksfilename" or die "Can find kickstart file" ;
    
    print OUT $entry;
    
    close OUT;
}


sub createAndAppendToKickstart()
{
    my ($entry)=@_;
    my $ksfilename="disklayout-kickstart";
    print "Writing entry $entry to kickstart file\n";
    
    open OUT, ">$ksfilename" or die "Can find kickstart file" ;
    
    print OUT $entry;
    
    close OUT;
}

sub appendToPreKickstart()
{
    my ($entry)=@_;
    
    my $ksfilename="pre-ks.cfg";
    print "Writing entry $entry to kickstart file\n";

    open OUT, ">>$ksfilename" or die "Can find kickstart file" ;
    
    print OUT $entry;
    
    close OUT;
}


sub createAndAppendToPreKickstart()
{
    my ($entry)=@_;
    my $ksfilename="pre-ks.cfg";
    print "Writing entry $entry to kickstart file\n";

    open OUT, ">$ksfilename" or die "Can find kickstart file" ;

    print OUT $entry;
    print OUT "\n%pre\n";

    close OUT;
}

