# 
# $Header: network-stage-directive.pl 29-jul-2007.23:27:08 rattipal Exp $
#
# network_stage.pl
# 
# Copyright (c) 2005, 2007, Oracle. All rights reserved.  
#
#    NAME
#      network_stage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rattipal    07/29/07 - dns servers fix
#    rattipal    09/11/06 - Backport ssdas_suse_fix from main
#    ssdas       07/27/06 - creating for suse 
#    rattipal    09/13/06 - Backport rattipal_clear_ippool from main
#    ssdas       07/27/06 - creating for suse 
#    rattipal    08/08/06 - bonding support
#    rattipal    08/08/06 - bonding support
#    pshroff     08/05/05 - pshroff_stagepath_dirs
#    pshroff     06/30/05 - Creation
#

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

main();

sub main()
{
	print "\nCreating Network kickstart file and Network post-section kickstart file\n";
	createAndAppendToPost("\n#Network Part Of Post-section\n");
	createAndAppendToKickstart("\n#Network Part Of Kickstart\n");
	my $i=0;
	my $deviceName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DeviceName");
	my $maxDevices = 0;
	print "Device name is $deviceName";
	while(!($deviceName eq ""))
	{
		my $isBonding = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_IsBonding");
		my $dnsLine = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DNSServers");
		my @dnsServers = split /,/ , $dnsLine;
		my $noOfServers = $#dnsServers;

		print "Isbonding value is $isBonding\n";
		if($isBonding =~ /^yes/)
		{
			$maxDevices = $maxDevices + 1;
		}
	
		my $j = 0;
		my $dnsEntry="";
		for($j = 0; $j < $noOfServers; $j++)
		{
			$dnsEntry = "\necho \"nameserver $dnsServers[$j]\" >> /etc/resolv.conf\n";
			appendToPost($dnsEntry);
		}
		
		$i = $i + 1;
		$deviceName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DeviceName");
		if($deviceName eq "")
		{
			last;
		}
		print "Device name is $deviceName";
	}
	print "Max bonds is $maxDevices\n";
	$i = 0;
	$deviceName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DeviceName");
	while(!($deviceName eq ""))
	{
		print "Device name is $deviceName";
		my $isBonding = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_IsBonding");
		if($isBonding =~/^yes/)
		{
			addBondingEntry($i, $deviceName, $maxDevices);
		}
		else
		{
			addNonBondingEntry($i, $deviceName);
		}
		$i = $i + 1;
		$deviceName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DeviceName");
		if($deviceName eq "")
		{
			last;
		}

	}
}

sub addNonBondingEntry()
{
	my ($i, $deviceName) = @_;
	print "\nIn bonding with $i and $deviceName\n";
	my $addrType = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_AddrType");
	my $networkEntry = "";
	if($addrType =~ /ADDR_Dynamic/)
	{
		$networkEntry = getDynamicEntry($i, $deviceName);
	}
	else
	{
		$networkEntry = getStaticEntry($i, $deviceName);	
	}
	appendToPost($networkEntry);
	if($deviceName eq "eth0")
	{
		my $defaultGatewayEntry = getdefaultGateway($i);
		appendToKickstart($defaultGatewayEntry);
	}
}


sub addBondingEntry()
{
	my ($i, $deviceName, $maxDevices) = @_;
	print "\nIn bonding with $i and $deviceName and $maxDevices\n";
	my $addrType = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_AddrType");

	my $optionsEntry = getOptionsEntry($i, $deviceName, $maxDevices);
	appendToPost($optionsEntry);

	my $slaveDevicesString = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_SlaveDevicesList");
	my @slaveDevices = split /,/ , $slaveDevicesString;
	my $noOfSlaves = $#slaveDevices;
	@slaveDevices = trim(@slaveDevices);
	print "List of slaves is @slaveDevices\n";
	my $j = 0;
	my @slaveEntries;
	for($j = 0; $j < $noOfSlaves; $j++)
	{
		$slaveEntries[$j] = getSlaveEntry($slaveDevices[$j], $deviceName);
		appendToPost($slaveEntries[$j]);
		if($slaveDevices[$j] eq "eth0")
		{
			my $defaultGatewayEntry = getdefaultGateway($i);
			appendToKickstart($defaultGatewayEntry);
		}
	}
	
	my $masterEntry = "";
	if($addrType =~ /ADDR_Dynamic/)
	{
		$masterEntry = getMasterEntryDynamic($i, $deviceName);
	}
	else
	{
		$masterEntry = getStaticEntry($i, $deviceName);	
	}
	appendToPost($masterEntry);
}


sub getSlaveEntry()
{
	my ($slaveDevice, $masterDevice) = @_;
	my $slaveEntry = "";
	my $filePrefix = "/etc/sysconfig/network-scripts/ifcfg-";
	$slaveEntry = "\nrm -rf $filePrefix$slaveDevice\ncat >> $filePrefix$slaveDevice <<EOF \nDEVICE=$slaveDevice\nUSERCTL=no\nONBOOT=yes\nMASTER=$masterDevice\nSLAVE=yes\nBOOTPROTO=none\nEOF";
	print $slaveEntry;
	return $slaveEntry;
}


sub getOptionsEntry()
{
	my ($i, $deviceName, $maxDevices) = @_;

	my $primarySlave  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_PrimarySlave");
	my $primarySlaveEntry = "";
	if(!($primarySlave eq ""))
	{
		$primarySlaveEntry = " primary=$primarySlave ";
	}
	
	my $mode  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_BondingMode");
	my $modeEntry = "";
	if(!($mode eq ""))
	{
		$modeEntry = " mode=$mode ";
	}
	
	my $arpInterval  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_ARPInterval");
	my $arpIntervalEntry = "";
	if(!($arpInterval eq ""))
	{
		$arpIntervalEntry = " arp_interval=$arpInterval ";
	}
	
	my $arpTargets  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_ARPIPTarget");
	my $arpTargetsEntry = "";
	if(!($arpTargets eq ""))
	{
		$arpTargetsEntry = " arp_ip_target=$arpTargets ";
	}

	my $miiIntervalEntry = "";
	my $downDelayEntry = "";
	my $upDelayEntry = "";

	if(($arpInterval eq ""))
	{
		my $miiInterval  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_MIIInterval");

		if(!($miiInterval eq ""))
		{
			$miiIntervalEntry = " miimon=$miiInterval ";
		}

		my $downDelay  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DownDelay");
		if(!($downDelay eq ""))
		{
			$downDelayEntry = " downdelay=$downDelay ";
		}

		my $upDelay  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_UpDelay");
		if(!($upDelay eq ""))
		{
			$upDelayEntry = " updelay=$upDelay ";
		}
	}
	my $maxBondsEntry = " max_bonds=$maxDevices ";
	
	my $switch = "\nif [ `uname -r | cut -b 1,2,3` = \"2.4\" ]\nthen\nconfigfile=\"/etc/modules.conf\"\nelse\nconfigfile=\"/etc/modprobe.conf\"\nfi\n";

	my $optionsEntry = "\n$switch\ncat >> \$configfile <<EOF\nalias $deviceName bonding\noptions $deviceName $primarySlaveEntry $modeEntry $arpIntervalEntry $arpTargetsEntry $miiIntervalEntry $downDelayEntry $upDelayEntry $maxBondsEntry \nEOF\n";
	print $optionsEntry;
	return $optionsEntry;
	
}

sub getStaticEntry()
{
	my ($i, $deviceName) = @_;
    my $ipAddr = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_IPAddr");
	my $subnetMask = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_SubnetMask");

	my $filePrefix = "/etc/sysconfig/network-scripts/ifcfg-";
	my $staticEntry = "\nrm -rf $filePrefix$deviceName\ncat >> $filePrefix$deviceName <<EOF\nDEVICE=$deviceName\nIPADDR=$ipAddr\nNETMASK=$subnetMask\nONBOOT=yes\nUSERCTL=no\nBOOTPROTO=none\nEOF\n";
	print $staticEntry;
	return $staticEntry;
}

sub getDynamicEntry()
{
	my ($i, $deviceName) = @_;
	my $filePrefix = "/etc/sysconfig/network-scripts/ifcfg-";
	my $dynamicEntry = "\nrm -rf $filePrefix$deviceName\ncat >> $filePrefix$deviceName <<EOF\nDEVICE=$deviceName\nONBOOT=yes\nUSERCTL=no\nBOOTPROTO=dhcp\nEOF\n";
	print $dynamicEntry;
	return $dynamicEntry;
}

sub getMasterEntryDynamic()
{
	my ($i, $deviceName) = @_;
	my $filePrefix = "/etc/sysconfig/network-scripts/ifcfg-";
	my $masterEntry = "\nrm -rf $filePrefix$deviceName\ncat >> $filePrefix$deviceName <<EOF\nDEVICE=$deviceName\nONBOOT=yes\nUSERCTL=no\nBOOTPROTO=dhcp\nType=Bonding\nEOF\n";
	print $masterEntry;
	return $masterEntry;
}


sub trim {
    for (@_) {
        s/^\s*//; # trim leading spaces
        s/\s*$//; # trim trailing spaces
    }
    return @_;
}

sub appendToPost()
{
    my ($entry)=@_;
	`pwd`;    
    my $ksfilename="network-ks.cfg";
	chomp($ksfilename);
	print "\nWriting entry $entry to $ksfilename\n";
    
    open OUT, ">>$ksfilename" or die "Cannot find $ksfilename file $!" ;
    
    print OUT $entry;
	print "\nWritten\n";    
    close OUT;
}


sub createAndAppendToPost()
{
    my ($entry)=@_;
    my $ksfilename="network-ks.cfg";
	chomp($ksfilename);
    print "\nWriting entry $entry to $ksfilename\n";
	`pwd`;    
    open OUT, ">$ksfilename" or die "Cannot open $ksfilename file $!" ;
    
    print OUT $entry;
	print "\nWritten\n";    
    close OUT;
}

sub getdefaultGateway()
{
	my ($i)=@_;
	print "In default gateway method with i = $i";
        my $addrType = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_AddrType");
        if($addrType =~ /ADDR_Dynamic/)
        {
            my $networkProfileEntry="network --device eth0 --bootproto dhcp\n";
            print "Returned network entyr is $networkProfileEntry";
            return $networkProfileEntry;
        }
        else
        {
	my $hostName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_Hostname");
    my $domainName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DomainName");
    my $ipAddr = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_IPAddr");
    my $subnetMask = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_SubnetMask");
	my $gwLine = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_Gateways");
        my $dnsserverLine=get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DNSServers");
	my @gateways = split /,/ , $gwLine;
        my @dnsservers =  split /,/ , $dnsserverLine;

	my $networkProfileEntry="network --device eth0 --bootproto static --ip $ipAddr --netmask $subnetMask --gateway $gateways[0] --nameserver $dnsservers[0] --hostname $hostName.$domainName\n";
	print "Returned network entyr is $networkProfileEntry";
	return $networkProfileEntry;
    }
}
		
sub appendToKickstart()
{
    my ($entry)=@_;
    
    my $ksfilename="network-kickstart";
    print "Writing entry $entry to kickstart file\n";
    
    open OUT, ">>$ksfilename" or die "Can find kickstart file" ;
    
    print OUT $entry;
    
    close OUT;
}


sub createAndAppendToKickstart()
{
    my ($entry)=@_;
    my $ksfilename="network-kickstart";
    print "Writing entry $entry to kickstart file\n";
    
    open OUT, ">$ksfilename" or die "Can find kickstart file" ;
    
    print OUT $entry;
    
    close OUT;
}

