$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";
use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

my $g_privnodeslist="";

main();


sub main()
{
    
    my $IS_EXTEND = "NAME_Image.CRS_Component.NAME_IsExtend";
    my $isExtend = get_oraProperty($IS_EXTEND);
    if($isExtend eq "true")
    {
	print "Cluster Extend case, no need to format the shared disks. Exiting";
        exit 0;
        
    }
    print "\nInstalling OCFS Format component";
    my $exitstatus ;
    
    #get the path where the tar file is located on the target machine.
    my $currentfolder_cmd="pwd";
    my $currentfolder=`$currentfolder_cmd`;
    chomp $currentfolder;
    print "\nCurrent folder is: $currentfolder";
    
    
    #get the name of the tar file associated with the Orarun component.
    my $binaryFile = get_oraComponentFilename();

    # installFilePath variable stores the location of the ocfs format tar file.
    print "\nComponent binary filename is $binaryFile";
    my $installFilePath="$currentfolder/$binaryFile";
    print "\nComponent binary filepath is $installFilePath";

    my $workingDir="/ocfs_format_tar";

    system("mkdir -p $workingDir");
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while creating $workingDir directory.";
        exit $exitstatus;
    }

    chdir $workingDir;
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while changing the directory.";
        cleanup($workingDir);
        exit $exitstatus;
    }

    my $command = `tar -zxvf $installFilePath`;
    $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while untaring the OCFS Format component binary\n";
        cleanup($workingDir);
        exit $exitstatus;
    }


    my $OCFS_FILES   = "NAME_Image.Component_Orarun.NAME_OCFS_rpms";
    my $OCFS_TOOLFILES   = "NAME_Image.Component_Orarun.NAME_OCFSTOOL_rpms";
    my $CLONE_USER   = "NAME_Image.Component_Orarun.NAME_CloneUser";
    my $INSTALLGRP = "NAME_Image.Component_Orarun.NAME_InstallGroup";
    my $NODE_PROPERTY = "NAME_Image.CRS_Component.NAME_NodePropertyList[0]";

    my $OCFS_RPMS= get_oraProperty($OCFS_FILES);
    my $OCFS_TOOLRPMS= get_oraProperty($OCFS_TOOLFILES);
    my $cloneUser = get_oraProperty($CLONE_USER);
    my $instGroup = get_oraProperty($INSTALLGRP); 

    my $base_url = get_oraProperty("NAME_StageBaseUrl");
	


	print "\nInstalling OCFS rpm(s)";
	
	#specific to OCFS, in case of nfs, mount the location and prepare the ocfsDir, other wise for http get the base url.

		
	my (@url_info, $len, $count, $url_entry, $dir, $nfs_host_name, $nfs_host_dir, $ocfsDir, $mount_ocfs);
	$nfs_host_dir="";
	my $mount_ocfs_onto = "/ocfs_rpms";
    	@url_info = split /\/+/ ,$base_url ;
    	$len = $#url_info;
    	if($base_url=~ /^file:/  || $base_url =~/^FILE:/)
    	{
		for($count=1;$count<=$len;$count++)
		{
			$url_entry=$url_info[$count];
			if($count ==1)
			{
				$nfs_host_name = $url_info[$count];
			}
			if($count >1)
			{
				$nfs_host_dir = $nfs_host_dir."/".$url_info[$count];
			}
		}
		#create the directory and mount the stage base url
		system("mkdir -m 777 $mount_ocfs_onto");
		system("mount $nfs_host_name:$nfs_host_dir $mount_ocfs_onto");
		$ocfsDir = $mount_ocfs_onto;
		$mount_ocfs="true";
	
		
	}
	else
	{
		$ocfsDir = $base_url;
	}

	#install the rpm(s)
	
	if($OCFS_TOOLRPMS ne '')
    	{
		my @list_rpms = split(/ /, $OCFS_TOOLRPMS);
		my $temp;
		foreach $temp (@list_rpms)
		{
			system("rpm","-Uvh", $ocfsDir."/".$temp);	
		}
    	}
	
	if($OCFS_RPMS ne '')
    	{
		my @list_rpms = split(/ /, $OCFS_RPMS);
		my $temp;
		foreach $temp (@list_rpms)
		{
			system("rpm","-Uvh", $ocfsDir."/".$temp);	
		}
    	}

    # unmount the ocfs directories
    my $partitionInfo = get_oraProperty("NAME_Image.Component_OcfsFormat.NAME_PartitionInfo[0]");
    my @partitionArray= ();
    my $itr = 0;
    while ($partitionInfo)
    {
        
       	@partitionArray=split(/%/,$partitionInfo);
	
       	my $partitionMountStr = $partitionArray[2];
	
	system("umount $partitionMountStr");
	system("rm -rf $partitionMountStr");

	$itr = $itr + 1;
        $partitionInfo = get_oraProperty("NAME_Image.Component_OcfsFormat.NAME_PartitionInfo[$itr]");
        if ($partitionInfo eq "")
        {
            last;
        }
    }



	#now using the mountinfo, check the ocfs format checker inputs
	#read all mount locations, typically user will have three for voting disks  
    
    my $mountInfo = get_oraProperty("NAME_Image.Component_Orarun.NAME_MountInfo[0]");
    my @mountArray= ();
    my $mountDirLoc="";
    my $deviceInfo = "";
    my $mountString = "";
    @mountArray=split(/%/,$mountInfo);
    my $mountDir1=$mountArray[2];
    my $i = 0;
    while ($mountInfo)
    {
        
       	@mountArray=split(/%/,$mountInfo);
       	
	$mountDirLoc=$mountArray[2];
		
	#create the mount location for bare metal box
        
	system("mkdir -p $mountDirLoc");
        system("chgrp $instGroup  $mountDirLoc");
        system("chmod 777  $mountDirLoc");
        
	$deviceInfo=$mountArray[1]."%1320%".$mountArray[0]."%".$mountArray[2]."%".$mountArray[0];
	
	$mountString=$mountString .$deviceInfo. ",";
        # go for next row ..
        $i = $i + 1;
        $mountInfo = get_oraProperty("NAME_Image.Component_Orarun.NAME_MountInfo[$i]");
        if ($mountInfo eq "")
        {
            last;
        }
    }

    my  @nodeArray= ();
    #the complete string of all mount locations to be passed in  response file
    # NOTE:we should get this property from the CRS clone component
    my $nodeProperty = get_oraProperty($NODE_PROPERTY);
    print "\n read  node property:$nodeProperty";
    my $i = 0;
    #read all rows
    while ($nodeProperty)
    {
        push(@nodeArray,$nodeProperty);
	print "\nUser supplied node property:$nodeProperty";
        # go for next row ..
        $i = $i + 1;
        $NODE_PROPERTY= "NAME_Image.CRS_Component.NAME_NodePropertyList[$i]";
        $nodeProperty = get_oraProperty($NODE_PROPERTY);
        if ($nodeProperty eq "")
        {
            last;
        }
    }

    # Location of the orarun Response file.
    my $defaultResponseFile = $workingDir."/orarun.response";

    # Location of the enable file.
    my $enableFile = $workingDir."/orarun.enable";

    # Location of the orarun script file.
    my $scriptFile = $workingDir."/orarun.sh";

    # Location of the formatOCFS script file.
    my $ocfsScriptFile = $workingDir."/formatOCFS.sh";



    # Modify the response file to include username,group, and vip,internal ip info
    readNodeProperties(@nodeArray);
    system("chmod 777 $defaultResponseFile");
    system("chmod 777 $enableFile");

    update_file($defaultResponseFile,"<%PRIVATE_NODES%>",$g_privnodeslist,"ignorecase");
    
    system("chmod 777 $scriptFile");
    system("chmod 777 $ocfsScriptFile");
    system("chmod 755 $defaultResponseFile");
    system("chmod 755 $enableFile");
    
    # Run orarun.sh as root user.
    my $runOrarun = $workingDir."/orarun.sh  $defaultResponseFile $enableFile";

    print "\nExecuting orarun script This will take sometime. Please wait...";
    print "\n$runOrarun";

    $command = `$runOrarun`;
    $exitstatus = $? >> 8;
    print "\n Exit Code: $exitstatus";

    if ($exitstatus != 0 && $exitstatus !=1)
    {
        print "\nFailed while Executing runOrarun";
        cleanup($workingDir);
        exit $exitstatus;
    }
     
    my $runOcfsFormat = $workingDir."/formatOCFS.sh  $mountString $cloneUser";

    $command = `$runOcfsFormat`;
    $exitstatus = $? >> 8;
    print "\n Exit Code: $exitstatus";

    if ($exitstatus != 0 && $exitstatus !=1)
    {
        print "\nFailed while Executing runOcfsFormat";
        cleanup($workingDir);
        exit $exitstatus;
    }

	if($mount_ocfs eq "true")
	{
		system("umount $mount_ocfs_onto");
		system("rm -rf $mount_ocfs_onto");
	}
    cleanup($workingDir);
}


sub cleanup()
{
    my $workingDir = $_[0];
    system("rm -rf $workingDir");

    my $exitstatus = $? >> 8;
    if ($exitstatus != 0)
    {
        print "\nFailed while removing $workingDir dir";
        exit $exitstatus;
    }
}

sub readNodeProperties()
{
   my $hostname="";
   my $nodename="";
   my $tmpdir="";
   my $priv="";
   my $vip="";
   foreach (@_) {
        ($hostname,$nodename,$tmpdir,$priv,$vip) = split(/;/);
        $g_privnodeslist=$g_privnodeslist.$nodename."_priv"." ";
        my $priv_name = $nodename."_priv";
        #also append the entry to /etc/hosts
        system("echo \"$priv    $priv_name\" >> /etc/hosts");
        }
    print "privnodeslist = $g_privnodeslist \n";
}


sub update_file
{
   my $file_name="";
   my $search_string="";
   my $replace_string="";
   my $case_sensitive_switch="";
   my $backup_file="";
   my $line="";
   my @array= ();

   ($file_name, $search_string, $replace_string, $case_sensitive_switch)=@_;
   $backup_file = $file_name."\.backup";
   open (ORIG_FILE, $file_name);
   @array=<ORIG_FILE>;
   close (ORIG_FILE);
   open (ORIG_FILE_TMP, ">".$backup_file);
   foreach $line (@array)
   {
       if ($line =~ /$search_string/)
       {
           if ($case_sensitive_switch eq "ignorecase")
           {
               $line=~s/$search_string/$replace_string/gi;
           }
           else
           {
               $line=~s/$search_string/$replace_string/g;
           }
       }
       print ORIG_FILE_TMP $line;
   }
   close (ORIG_FILE_TMP);
   #unlinking the file as behavior of the rename call varies wildly depending on the system implementation
   unlink $file_name;
   rename($backup_file, $file_name);
}
