$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";
use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";


main();


sub main()
{
    my $IS_EXTEND = "NAME_Image.CRS_Component.NAME_IsExtend";
    my $isExtend = get_oraProperty($IS_EXTEND);
    if($isExtend eq "true")
    {
	print "Cluster Extend case, no need to format the shared disks. Exiting";
        exit 0;
        
    }
    #need to put partition info
    createAndAppendToDiskKickstart("\n#partition entry for ocfs disks\n");
    createAndAppendToPreKickstart("\n#dd entries for ocfs disks\n");
    my $mountInfo = get_oraComponentProperty("NAME_PartitionInfo[0]");
    my @mountArray= ();
    my $mountDirLoc="";
    my $deviceInfo = "";
    my $mountString = "";
    @mountArray=split(/%/,$mountInfo);
    my $mountDir1=$mountArray[2];
    my $i = 0;
    while ($mountInfo)
    {
        
       	@mountArray=split(/%/,$mountInfo);
	
       	my $partStr;
	$partStr = "part $mountArray[2] --ondisk $mountArray[0] --size $mountArray[3]";
	appendToDiskKickstart($partStr."\n");
	
	my $ddStr;
	$ddStr = "dd if=/dev/zero of=/dev/$mountArray[0] bs=512 count=1";
	appendToPreKickstart($ddStr."\n");

	$i = $i + 1;
        $mountInfo = get_oraComponentProperty("NAME_PartitionInfo[$i]");
        if ($mountInfo eq "")
        {
            last;
        }
    }
    
}

sub appendToDiskKickstart()
{
    my ($entry)=@_;

    my $ksfilename="ocfs-disklayout-kickstart";
    print "Writing entry $entry to kickstart file\n";

    open OUT, ">>$ksfilename" or die "Can find kickstart file" ;

    print OUT $entry;

    close OUT;
}

sub createAndAppendToDiskKickstart()
{
    my ($entry)=@_;

    my $ksfilename="ocfs-disklayout-kickstart";
    print "Writing entry $entry to kickstart file\n";

    open OUT, ">$ksfilename" or die "Can find kickstart file" ;

    print OUT $entry;

    close OUT;
}


sub appendToPreKickstart()
{
    my ($entry)=@_;

    my $ksfilename="ocfs-pre-ks.cfg";
    print "Writing entry $entry to kickstart file\n";

    open OUT, ">>$ksfilename" or die "Can find kickstart file" ;

    print OUT $entry;

    close OUT;
}

sub createAndAppendToPreKickstart()
{
    my ($entry)=@_;

    my $ksfilename="ocfs-pre-ks.cfg";
    print "Writing entry $entry to kickstart file\n";

    open OUT, ">$ksfilename" or die "Can find kickstart file" ;

    print OUT $entry;

    close OUT;
}
