#    NAME
#      orarunstagedirectives.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#     Staging directive for orarun (generic) component
#
#    NOTES
#	This directive has to be associated with the generic Orarun component whicle provisioning a CRS RAC component. Please
#	refer to the best practices guide for the usage.


use File::Find;
use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";
#my $hosts;
my $usrID="";
my $name="";
my $g_nodelist="";
main();
sub main()
{
    	my $USRID   = "NAME_UsrID"; 
	my $CLUSTERNAME="NAME_Image.CRS_Component.NAME_ClusterName";
 	$name=get_oraProperty($CLUSTERNAME);
	#$name=$name ."_agent";
	print "Name of agent cluster is $name";
	$usrID= get_oraComponentProperty($USRID); 
	my $NODE_PROPERTY = "NAME_Image.CRS_Component.NAME_NodePropertyList[0]";
#$hosts= get_oraComponentProperty(NAME_Image.CRS_Component.NAME_ClusterHosts);
    my  @nodeArray= ();
    my $nodeProperty = get_oraProperty($NODE_PROPERTY);
 #   print "\n read  node property:$nodeProperty";
    my $i = 0;
    #read all rows
    while ($nodeProperty)
    {
        push(@nodeArray,$nodeProperty);
        print "\nUser supplied node property:$nodeProperty";
        # go for next row ..
        $i = $i + 1;
        $NODE_PROPERTY= "NAME_Image.CRS_Component.NAME_NodePropertyList[$i]";
        $nodeProperty = get_oraProperty($NODE_PROPERTY);
        if ($nodeProperty eq "")
        {
            last;
        }
    }
    readNodeProperties(@nodeArray);
my $currentdir=`pwd`;
chdir "..";
chomp $currentdir;
my $imagedir=`pwd`;
chdir $currentdir;
chomp $imagedir;
find(\&appendoms, $imagedir);
}

sub readNodeProperties()
{
   my $hostname="";
   my $nodename="";
   my $tmpdir="";
   my $priv="";
   my $vip="";
   foreach (@_) {
        ($hostname,$nodename,$tmpdir,$priv,$vip) = split(/;/);
         $g_nodelist=$g_nodelist . $nodename . ",";
#         $g_viplist=$g_viplist . $vip . ":". $nodename . "_vip" . " ";

#         $g_priviplist=$g_priviplist. $priv . ":" . $nodename . "_priv" . " ";
    }
    #remove trailing comma
    chop($g_nodelist);

#    print "viplist = $g_viplist \n";
#    print "priviplist = $g_priviplist \n";

}


sub appendoms
{
	my $agentpropPath;
	print "Looking for agent.properties... now:"."$_" ;
    if(/agent.properties$/)
    {
        $agentpropPath = "$File::Find::dir/$_" ;
        chomp($agentpropPath);
        open OUT ,">>$agentpropPath" or die "Can not write to $agentpropPath : $!";
        print OUT "\nCLUSTER_NODES={".$g_nodelist."}";
        print OUT "\ns_clusterName=$name";
        print OUT "\nagentUserID=$usrID";
	close OUT;
    }
}

