#!/usr/local/bin/perl
# $Header: suse-disk-layout-directive.pl21556 15-nov-2006.22:11:05 ssdas Exp $
#
# linuxos-stage-directive.pl
#
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      suse-disk-layout-directive.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#     Staging directive for suse disk layout component
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gaurgupt    09/19/06 - changing the LVM
#    gaurgupt    09/18/06 - created disklayout


$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";
use LWP::Simple;

use strict;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";


main();

sub main(){
	print "Creating DiskLayout kickstart file \n";
	createAndAppendToKickstart();
	createPrimaryPartition();
	createRaidPartition();
	createLogicalVolumeGroupPartition();
	closeKickstart();
}

sub createLogicalVolumeGroupPartition(){
	my $ksfilename="suse-disk-layout-kickstart";
        open OUT, ">>$ksfilename" or die "Can find kickstart file $!" ;

	my $mountPointProperty="NAME_LogicalVolumeGroups[0].NAME_LogicalGroupName";

	my $mountPoint = get_oraComponentProperty($mountPointProperty);
	my $i = 0;
	while($mountPoint){
		chomp($mountPoint);
		print OUT "<drive>\n";
                print OUT "<device>/dev/$mountPoint</device>\n";
		print OUT "<is_lvm_vg config:type=\"boolean\">true</is_lvm_vg>\n";
		print OUT "<lvm2 config:type=\"boolean\">true</lvm2>\n";
                print OUT "<partitions config:type=\"list\">\n";
		my $j = 0;
		my $partition = get_oraComponentProperty("NAME_LogicalVolumes[$j].NAME_LogicalVolumeName");
		while($partition){
			my $lvm_grp_name =  get_oraComponentProperty("NAME_LogicalVolumes[$j].NAME_LogicalGroupName");
			chomp ($partition);
			chomp($lvm_grp_name);
			if($mountPoint eq $lvm_grp_name){
				my $lv_mt_pt = get_oraComponentProperty("NAME_LogicalVolumes[$j].NAME_MountPoint");
				my $lv_size = get_oraComponentProperty("NAME_LogicalVolumes[$j].NAME_PartitionSize");
				my $lv_fs = get_oraComponentProperty("NAME_LogicalVolumes[$j].NAME_FileSysType");
				$lv_fs=~s/FS_//;

				if ($lv_fs eq "swap")
				{
					$lv_mt_pt =  "swap";
				}
				print OUT "<partition>\n";
				print OUT "<filesystem  config:type=\"symbol\">$lv_fs</filesystem>\n";
				print OUT "<format config:type=\"boolean\">true</format>\n";
				print OUT "<lv_name>$partition</lv_name>\n";
				print OUT "<mount>$lv_mt_pt</mount>\n";
				print OUT "<size>$lv_size"."mb</size>\n";
				print OUT "</partition>\n";
				

			}
			$j =$j+1;
			$partition = get_oraComponentProperty("NAME_LogicalVolumes[$j].NAME_LogicalVolumeName");
		}
		print OUT "</partitions>\n";
		print OUT "<use>all</use>\n";
		print OUT "</drive>\n";

		$i = $i + 1;
		$mountPointProperty="NAME_LogicalVolumeGroups[$i].NAME_LogicalGroupName";
		$mountPoint = get_oraComponentProperty($mountPointProperty);

	}
	close OUT;
}


sub createRaidPartition(){
        my $ksfilename="suse-disk-layout-kickstart";
        open OUT, ">>$ksfilename" or die "Can find kickstart file $!" ;
	
	my $mountPointProperty="NAME_RAIDs[0].NAME_MountPoint";
    
    	my $mountPoint = get_oraComponentProperty($mountPointProperty);
    	my $i = 0;
	if($mountPoint){
		print OUT "<drive>\n";
		print OUT "<device>/dev/md</device>\n";
		print OUT "<partitions config:type=\"list\">\n";
	}
	else{
		return;
	}
	while ($mountPoint){
		chomp($mountPoint);
		my $fileSystemType = get_oraComponentProperty("NAME_RAIDs[$i].NAME_FileSysType");
		$fileSystemType=~s/FS_//;
		my $raidLevel = get_oraComponentProperty("NAME_RAIDs[$i].NAME_RAIDLevel");
		$raidLevel=~s/RAID_//;
		if ($fileSystemType eq "swap"){
			$mountPoint = $fileSystemType;
		}

		print OUT "<partition>\n";
		if($fileSystemType eq "LVM"){
			my $lvm_grp = getLVMGroupForRaid($mountPoint);
			print OUT "<lvm_group>$lvm_grp</lvm_group>\n";
		}else{
			print OUT "<filesystem config:type=\"symbol\">$fileSystemType</filesystem>\n";
			print OUT "<format config:type=\"boolean\">true</format>\n";
			print OUT "<mount>$mountPoint</mount>\n";
		}
		print OUT "<partition_nr config:type=\"integer\">$i</partition_nr>\n";
		print OUT "<raid_options>\n";
		print OUT "<persistent_superblock config:type=\"boolean\">true</persistent_superblock>\n";
		print OUT "<raid_type>raid$raidLevel</raid_type>\n";
		print OUT "</raid_options>\n";
		print OUT "<size>max</size>\n";
		print OUT "</partition>\n";
		
		$i = $i +1;
		$mountPointProperty="NAME_RAIDs[$i].NAME_MountPoint";

	        $mountPoint = get_oraComponentProperty($mountPointProperty);
	}
	print OUT "</partitions>\n";
	print OUT "<use>all</use>\n";
	print OUT "</drive>\n";

	close OUT;
}

sub getLVMGroupForRaid(){
	my($raid_mount)= (@_);
        my $logicalVolumeGroupName = get_oraComponentProperty("NAME_LogicalVolumeGroups[0].NAME_LogicalGroupName");
        my $i = 0;
        while ($logicalVolumeGroupName){
                my $j = 0;
                my $partition = get_oraComponentProperty("NAME_LogicalVolumeGroups[$i].NAME_RAIDs[$j]");
                chomp($partition);
                while($partition){
                        if($partition eq $raid_mount){
                                return $logicalVolumeGroupName;
                        }
                        $j = $j + 1;
                        $partition = get_oraComponentProperty("NAME_LogicalVolumeGroups[$i].NAME_RAIDs[$j]");
                }
                $i = $i + 1;
                $logicalVolumeGroupName = get_oraComponentProperty("NAME_LogicalVolumeGroups[$i].NAME_LogicalGroupName");
                if ($logicalVolumeGroupName eq "")
                {
                        last;
                }
        }
}

sub createPrimaryPartition(){
	my $diskDeviceNameProperty="NAME_HardDisks[0].NAME_DiskDeviceName";
	my $ksfilename="suse-disk-layout-kickstart";
        open OUT, ">>$ksfilename" or die "Can find kickstart file $!" ;
    	
    	my $diskDeviceName = get_oraComponentProperty($diskDeviceNameProperty);
	my @diskDeviceNameArr;
    	my $i = 0;
	while ($diskDeviceName){
		push(@diskDeviceNameArr,$diskDeviceName);
		$i = $i + 1;
		$diskDeviceNameProperty="NAME_HardDisks[$i].NAME_DiskDeviceName";
		$diskDeviceName =get_oraComponentProperty($diskDeviceNameProperty);
		if ($diskDeviceName eq "")
        	{
            		last;
        	} 	
	}
    	foreach  $diskDeviceName (@diskDeviceNameArr){
		chomp($diskDeviceName);
		$i = 0;	
		print OUT "<drive>\n";			
		print OUT "<initialize config:type=\"boolean\">true</initialize>\n";
		$diskDeviceName =~ s/\/dev\///;
		print OUT "<device>/dev/$diskDeviceName</device>\n";
		print OUT "<partitions config:type=\"list\">\n";
		$diskDeviceNameProperty="NAME_Partitions[$i].NAME_DiskDeviceName";
		my $deviceName = get_oraComponentProperty($diskDeviceNameProperty);
		chomp($deviceName);
		while($deviceName){
			$deviceName =~ s/\/dev\///;
			if($deviceName eq $diskDeviceName){
				my $fileSystemType = get_oraComponentProperty("NAME_Partitions[$i].NAME_FileSysType");
				my $partitionSize = get_oraComponentProperty("NAME_Partitions[$i].NAME_PartitionSize");
				
				if($fileSystemType=~/FS_swap/){
					print OUT "<partition>\n";
					print OUT "<format config:type=\"boolean\">true</format>\n";
					print OUT "<mount>swap</mount>\n";
					print OUT "<size>$partitionSize"."M</size>\n";
					print OUT "</partition>\n";
					
				}
				elsif ($fileSystemType=~/FS_unspecified/)
				{	
					my $mountPoint = get_oraComponentProperty("NAME_Partitions[$i].NAME_MountPoint");
					print OUT "<partition>\n";
					print OUT "<format config:type=\"boolean\">true</format>\n";
                                        print OUT "<mount>$mountPoint</mount>\n";
                                        print OUT "<size>$partitionSize"."M</size>\n";
                                        print OUT "</partition>\n";
		
				}
				elsif ($fileSystemType=~/FS_Raid/){
					my $mountPoint = get_oraComponentProperty("NAME_Partitions[$i].NAME_MountPoint");
					chomp($mountPoint);
					my $raid_name = getRaidName($mountPoint);
					print OUT "<partition>\n";
					print OUT "<format config:type=\"boolean\">true</format>\n";
                                        print OUT "<raid_name>$raid_name</raid_name>\n";
                                        print OUT "<raid_type>raid</raid_type>\n";
					print OUT "<size>$partitionSize"."M</size>\n";
                                        print OUT "</partition>\n";
				}
				elsif ($fileSystemType=~/FS_LVM/){
					my $mountPoint = get_oraComponentProperty("NAME_Partitions[$i].NAME_MountPoint");
					chomp($mountPoint);
					my $lvmg_name = getLVMGroupName($mountPoint);
					print OUT "<partition>\n";
					print OUT "<format config:type=\"boolean\">true</format>\n";
                                        print OUT "<lvm_group>$lvmg_name</lvm_group>\n";
					print OUT "<size>$partitionSize"."M</size>\n";
                                        print OUT "</partition>\n";
				#	@lvm_list = getLvmList($mountPoint,@lvm_list);
				}
				else{
					if ($fileSystemType=~/FS_ext3/){
			                	$fileSystemType = "ext3";
           				}
           				elsif ($fileSystemType=~/FS_ext2/){
			                    $fileSystemType = "ext2";
                			}
					my $mountPoint = get_oraComponentProperty("NAME_Partitions[$i].NAME_MountPoint");
					print OUT "<partition>\n";
					print OUT "<filesystem  config:type=\"symbol\">$fileSystemType</filesystem>\n";
					print OUT "<format config:type=\"boolean\">true</format>\n";
                                        print OUT "<mount>$mountPoint</mount>\n";
                                        print OUT "<size>$partitionSize"."M</size>\n";
                                        print OUT "</partition>\n";
				}
			}
			$i = $i + 1;
			$diskDeviceNameProperty= "NAME_Partitions[$i].NAME_DiskDeviceName";
			$deviceName = get_oraComponentProperty($diskDeviceNameProperty);
			if ($deviceName eq ""){
				last;
			}
			
		}
		print OUT "</partitions>\n";			
		print OUT "<use>all</use>\n";
		print OUT "</drive>\n";			
	}
	close OUT;
}

sub getLVMGroupName(){
	my($lvn_name) = (@_);
	my $logicalVolumeGroupName = get_oraComponentProperty("NAME_LogicalVolumeGroups[0].NAME_LogicalGroupName");
    	my $i = 0;
	while ($logicalVolumeGroupName){
		my $j = 0;
		my $partition = get_oraComponentProperty("NAME_LogicalVolumeGroups[$i].NAME_Partitions[$j]");
		chomp($partition);
		while($partition){
			if($partition eq $lvn_name){
				return $logicalVolumeGroupName;
			}
			$j = $j + 1;
			$partition = get_oraComponentProperty("NAME_LogicalVolumeGroups[$i].NAME_Partitions[$j]");
		}
		$i = $i + 1;
        	$logicalVolumeGroupName = get_oraComponentProperty("NAME_LogicalVolumeGroups[$i].NAME_LogicalGroupName");
        	if ($logicalVolumeGroupName eq "")
        	{
            		last;
        	}
	}
}

sub getRaidName(){
	my ($partName) = (@_);
	my $i = 0;
	my $mountPointProperty="NAME_RAIDs[0].NAME_MountPoint";
	
	my $mountPoint = get_oraComponentProperty($mountPointProperty);

	while($mountPoint){
		my $raidDeviceName = "/dev/md".$i;
		my $j = 0;
		my $partition = get_oraComponentProperty("NAME_RAIDs[$i].NAME_Partitions[$j]");
		chomp($partition);
		while($partition){
			if($partition eq $partName){
				return $raidDeviceName;
			}
			$j = $j + 1;
			$partition = get_oraComponentProperty("NAME_RAIDs[$i].NAME_Partitions[$j]");
		}
		$i = $i + 1;
		$mountPoint = get_oraComponentProperty("NAME_RAIDs[$i].NAME_MountPoint");
        	if ($mountPoint eq "")
        	{
            		last;
        	}
	}
}

sub closeKickstart(){
	my $ksfilename="suse-disk-layout-kickstart";
        open OUT, ">>$ksfilename" or die "Can find kickstart file $!" ;
        print OUT "</partitioning>\n";
        close OUT;
}
sub createAndAppendToKickstart(){
	my $ksfilename="suse-disk-layout-kickstart";
	open OUT, ">$ksfilename" or die "Can find kickstart file $!" ;
	print OUT "<partitioning config:type=\"list\">\n";
    	close OUT;
}
