#!/usr/local/bin/perl
#
# $Header: suse_image-stage-directive.pl 08-aug-2007.20:20:32 gaurgupt Exp $
#
# defaultimage_stage.pl
#
# Copyright (c) 2005, 2007, Oracle. All rights reserved.  
#
#    NAME
#      defaultimage_stage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      Stage Directives for Default Image
#      This script will create a final kickstart file by combining all
#      the smaller kickstart files
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gaurgupt    08/08/07 - changing the location where the initrd is copied
#    ssdas       11/02/06 - changing the permissions of the initrd
#    rattipal    10/03/06 - making changes for the install job 
#    gaurgupt    09/18/06 - adding disklayout
#    gaurgupt    09/14/06 - changing the access properties of the autoyast file
#    gaurgupt    09/01/06 - adding bonding
#    gaurgupt    08/28/06 - adding nis and nfs
#    ssdas       08/02/06 - suse image directive
#    gaurgupt    07/19/06 - Creation
#

use File::Find;

require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

my $SAMPLE_BOOT_FILE = "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/SAMPLE-PXE-BOOTFILE_SUSE";
my $INITRD_URL = "_initrd_"; 
my $PXECONFIGDIR  = "pxelinux.cfg";
my $PWD_COMMAND = "pwd";
my $CHMOD_COMMAND = "chmod -f";
my $CAT_COMMAND = "cat";
my $NAME_MAC_ADDRESS_PROP = "NAME_MacAddress";
my $BOOT_SERVER_PATH_PROP = "NAME_BootServerPath";
my $STAGE_BASE_URL_PROP = "NAME_StageBaseUrl";
my $g_pathSeparator = "/";
my $g_image_kickstart_path;
my $relative_image_kickstart_path="";
my $g_imageFolder;
my $OS_URL = "OS_URL";
main();

sub main(){
    my $KICKSTART_SUFFIX = "-ks.xml";
    # Local
    my $m_imageFolder;
    my $m_mac_address;
    my $m_kickstart;
    my $m_ref_kickstart_name;
    my $m_image_kickstart_path;
    my $m_ref_kickstart_file;
    
    my $m_imageFolder=`$PWD_COMMAND`;
    chomp $m_imageFolder;
    $g_imageFolder = $m_imageFolder;
	my $stage_top_dir=get_oraProperty("NAME_StageSharedMountPoint");
    print "Current image folder is: $m_imageFolder\n"; 

    #image kickstart name
    $m_mac_address = get_oraProperty($NAME_MAC_ADDRESS_PROP); 
    $m_kickstart = $KICKSTART_SUFFIX;

    my $current_path=`pwd`;
	chomp $current_path;
	my $parent_path="..";
	chdir $parent_path;
	my $top_image_path=`pwd`;
	chomp $top_image_path;
	chdir $current_path;
	my $image_hw_name=$current_path;
	my $temp_top_image_path=$top_image_path.$g_pathSeparator;
	$image_hw_name=~ s/$temp_top_image_path//;


    # kickstart file name will be the imageHw name appended with "-ks.cfg" suffix
    $g_image_kickstart_path = $m_imageFolder.$g_pathSeparator.$image_hw_name.$m_kickstart; 

    createAndAppendToKickstart();

    apendConfigureTag();
    apendPostTag();
    #adding postsection
    find(\&addPostSection,$m_imageFolder);
    appendPostScriptTag();
    find(\&addNetworkPostSection,$m_imageFolder);
    closePostScritpTag();
    closePostTag(); 
    #adding the network components in the main file
    find(\&addNetworkSection,$m_imageFolder);
    #adding the nis component in the main file
    find(\&addNISSection,$m_imageFolder);
    #adding the nfs component in the main file
    find(\&addNFSSection,$m_imageFolder);
    #adding the nts component in the main file
    find(\&addNTPSection,$m_imageFolder);
    
    closeConfigureTag();
    #adding the OS components in the main file
    find(\&addOSSection,$m_imageFolder);
    #adding the disklayout components in the main file
    find(\&addDiskLayoutSection,$m_imageFolder);

    #final completion of the file
    appendToKickstart();

   my $top_os_path=$stage_top_dir."/OS";
	system("mv -f $g_image_kickstart_path $top_os_path");
	system("chmod -R 777 $top_os_path");
    $relative_image_kickstart_path="/OS".$g_pathSeparator.$image_hw_name.$m_kickstart; 
	#now at this point, kickstart file is ready, modify boot server , update bootfile 
    # and use the kickstart file in ks-url
    $g_image_kickstart_path=$top_os_path.$g_pathSeparator.$image_hw_name.$m_kickstart;
	modifyBootServer();  
}
sub closePostTag(){
	 open OUT,">> $g_image_kickstart_path" or die " cann't opent kickstartfile : $!\n";
	# print OUT "</init-scripts>\n";
         print OUT "</scripts>\n";
         close OUT;

}
sub apendPostTag(){
	 open OUT,">> $g_image_kickstart_path" or die " cann't opent kickstartfile : $!\n";
	 print OUT "<scripts>\n";
	# print OUT "<init-scripts config:type=\"list\">\n";
	 close OUT;
}

sub apendConfigureTag(){
	open OUT,">> $g_image_kickstart_path" or die " cann't opent kickstartfile : $!\n";
	print OUT "<configure>\n";
        print OUT "<start_autofs config:type=\"boolean\">false</start_autofs>\n";
	close OUT;
}

sub closeConfigureTag(){
	open OUT,">> $g_image_kickstart_path" or die " cann't opent kickstartfile : $!\n";
	print OUT "</configure>\n";
	close OUT;
}
# Purpose
# Modify boot server, copy sample-boot file and then 
# modify the URL to point to proper kickstart file
# available on stage server
# @throws: will exit if any error is found during execution
sub modifyBootServer()
{ 
    # Local
    my $m_chmod_command;
    my $m_bootFilename;
    my $m_bootServerPath;
    my $m_bootFilePath;
    my $m_exitStatus;

    #chmod 755 to final kickstart on stage server
    my $m_chmod_command = "$CHMOD_COMMAND 755 $g_image_kickstart_path";
    system($m_chmod_command);
    $m_exitStatus = $? >> 8;

    if ($m_exitStatus != 0)
    {
        print "\nFailed to Change te Permission of the kickstart File \n";
        exit $m_exitStatus;
    }

    my $m_bootFilename = getBootFilename(); 

    #copying final kickstart file to boot server
    my $m_bootServerPath=get_oraProperty($BOOT_SERVER_PATH_PROP);  
    system("mkdir -p $PXECONFIGDIR");
    my $m_bootFilePath = $PXECONFIGDIR.$g_pathSeparator.$m_bootFilename;
    my $m_initrdFilePath =$m_bootServerPath.$g_pathSeparator."suse/"; 

    print "boot path is $m_bootFilePath \n";

    # change ks url  in boot file
    changeKickstartUrl($m_bootFilePath,$m_initrdFilePath);
}

# Purpose
# Reads the sample boot file, modifies kickstart URL Info and 
# adds each line into boot file, specified by input param.
# @params: boot filepath
# @throws: will exit if any error is found during execution
sub changeKickstartUrl()
{
    # Local
    my $m_bootUrl;
    my $m_chmod_command;
    my $m_exitStatus;

    my ($m_bootFilePath,$m_initrdFilePath) = @_;

    my $m_bootUrl = getBootUrl();
    
    #changes the initrd
    changeInitrd($m_bootUrl);
    my $stage_top_dir=get_oraProperty("NAME_StageSharedMountPoint");
    my $m_tempinitrd_name = $stage_top_dir."/suseInitrdDir/"."initrd_".getBootFilename();
    system("mv initrd_ $m_tempinitrd_name");

#bug 5638875
    my $m_chmod_command = "$CHMOD_COMMAND 777 $m_tempinitrd_name";
    system($m_chmod_command);

#finished

    $m_tempinitrd_name = "initrd_".getBootFilename();
    open IN_BOOT_FILEHANDLE, "$SAMPLE_BOOT_FILE" or die "Can't open sample boot file $SAMPLE_BOOT_FILE $!";
    open OUT_BOOT_FILEHANDLE, "> $m_bootFilePath" or die "Can't create boot file $m_bootFilePath $!";

    while (my $m_entry = <IN_BOOT_FILEHANDLE> )
    {
        chomp $m_entry; 

        if ($m_entry =~ $INITRD_URL)
        {
            $m_entry = findAndReplace($m_entry, $INITRD_URL, $m_tempinitrd_name); 
        } 
        print OUT_BOOT_FILEHANDLE "$m_entry\n";
    }

    close IN_BOOT_FILEHANDLE;
    close OUT_BOOT_FILEHANDLE;

    my $m_chmod_command = "$CHMOD_COMMAND 777 $m_bootFilePath";
    system($m_chmod_command);
    $m_exitStatus = $? >> 8;

    if ($m_exitStatus != 0)
    {
        print "\nFailed to Change the Permission of the boot File: Please check \n";
    }

    return;
}
                     
															   
# Purpose
# Returns boot(kickstart) file name
# @returns: boot filename
sub getBootFilename()
{
    # Local Variable
    my $m_mac_address;
    my $m_bootFilename;

    $m_mac_address=get_oraProperty($NAME_MAC_ADDRESS_PROP);  

    # replace ":" with "-" as per pxe boot standard
    $m_mac_address = findAndReplace($m_mac_address, ":", "-"); 

    # convert all hex uppercase letter to lowercase
    $m_mac_address = lc($m_mac_address);

    # append "01-" as prefix as per pxe format
    my $m_bootFilename = "01-".$m_mac_address;

    return $m_bootFilename;
} 


# Purpose
# Returns Boot Url for a given assignment
# @returns: bool url
sub getBootUrl()
{
    # Constants;
    my $COLON = ":";
    my $DOUBLE_SLASH = "//";

    # Local Variables
    my $m_baseUrl;
    my $m_host_name;
    my @m_urlInfo;
    my $m_len;
    my $m_count;
    my $m_urlEntry;
    my $m_url;


    $m_baseUrl = get_oraProperty($STAGE_BASE_URL_PROP); 

	if($m_baseUrl=~ /^file:/ || $m_baseUrl=~ /^FILE:/)
    {
		my $m_host_dir;
		$m_host_dir="";
		@m_urlInfo = split /\/+/ ,$m_baseUrl ;
		$m_len = $#m_urlInfo;
		for($m_count=1;$m_count<=$m_len;$m_count++)
		{
			$m_urlEntry=$m_urlInfo[$m_count];
			if($m_count ==1)
			{
				$m_host_name = $m_urlInfo[$m_count];
			}
			if($m_count >1)
			{
				$m_host_dir = $m_host_dir."/".$m_urlInfo[$m_count];
			}
		}

   
        $m_url = "nfs".$COLON.$DOUBLE_SLASH.$m_host_name.$COLON.$m_host_dir.$relative_image_kickstart_path;
    }
    else
    {
        $m_url = $m_baseUrl.$relative_image_kickstart_path;
    }

    print "kickstart url is $m_url\n";

    return $m_url;
}

sub addDiskLayoutSection(){
	my $m_smallKickstartPath;

    if(/suse-disk-layout-kickstart/)
    {
        $m_smallKickstartPath = "$File::Find::dir/$_" ;
        print "Appending smaller kickstart $m_smallKickstartPath to final kickstart file \n";
        open READ,"$m_smallKickstartPath" or die "Can not read $m_smallKickstartPath : $!";
        open WRITE,">> $g_image_kickstart_path" or die " cann't opent kickstartfile : $!\n";
        while(my $line = <READ>)
        {
                print WRITE $line;
        }
        print WRITE "</install>";
        close READ;
        close WRITE;
    }

}	

sub addOSSection(){
    my $m_smallKickstartPath;

    if(/suseos-kickstart/)
    {
        $m_smallKickstartPath = "$File::Find::dir/$_" ;
        print "Appending smaller kickstart $m_smallKickstartPath to final kickstart file \n";
        open READ,"$m_smallKickstartPath" or die "Can not read $m_smallKickstartPath : $!";
        open WRITE,">> $g_image_kickstart_path" or die " cann't opent kickstartfile : $!\n";
        print WRITE "<install>";
        while(my $line = <READ>)
        {
		print WRITE $line;
        }
      #  print WRITE "</install>";
        close READ;
        close WRITE;
    }

}


sub appendPostScriptTag(){
    open FILE,">>$g_image_kickstart_path" or die "Cann't opent the $g_image_kickstart_path in appendPostScriptTag $!";
    print FILE "<post-scripts config:type=\"list\">\n";
    close FILE;
}

sub closePostScritpTag(){
     open OUT,">>$g_image_kickstart_path" or die "Cann't opent the $g_image_kickstart_path in appendPostScriptTag $!";
     print OUT "<script>\n";
     print OUT "<interpreter>perl</interpreter>\n";
     print OUT "<source><![CDATA[\n";
     print OUT "#!/usr/bin/perl\n";

                     
     print OUT " main();\n";
     print OUT "sub main(){\n";
     print OUT "my \$input = \"/etc/sudoers\";\n";
     print OUT "my \$output = \"/etc/sudoers_bak\";\n";
     print OUT "open IN ,\"\$input\" or die \"Cann't open the \$input \$!\"; \n";
     print OUT "open OUT ,\">\$output\" or die \"Cann't open the \$output \$!\"; \n";
     print OUT "my \$line;\n";
     print OUT "while(\$line = <IN>){\n";
     print OUT "next if(\$line =~ m/^#/);\n";
     print OUT "my \@arr = split(/\\s+/,\$line);\n";
     print OUT "if(\$arr[0] eq \"Defaults\" && \$arr[1] eq \"targetpw\"){\n";
     print OUT "next;} \n";
     print OUT " print OUT \"\$line\";\n } \n";
     print OUT "close IN;\n";
     print OUT "close OUT;\n";
     print OUT "system(\"mv /etc/sudoers_bak /etc/sudoers\");\n";
     print OUT "system(\"chmod 640 /etc/sudoers\");\n }\n";
     
     print OUT "]]>\n";
     print OUT "</source>\n";
     print OUT "</script>\n";
     print OUT "</post-scripts>\n";
     close OUT;
}

sub addNetworkPostSection()
{
    # Constants;
    my $POST_SUFFIX = "network-post-ks.cfg";
    
    # Local Variables
    my $m_packageFilePath;
    my $m_appendCommand;
    my $m_exitStatus;
    
    if($_=~$POST_SUFFIX)
    {
        $m_packageFilePath = "$File::Find::dir/$_";

        print "Appending post section file $m_packageFilePath to final kicktstart file\n";
        $m_appendCommand = "$CAT_COMMAND $m_packageFilePath >> $g_image_kickstart_path";
        system($m_appendCommand);
        $m_exitStatus = $? >> 8;
        if ($m_exitStatus != 0)
        {
            print "\nFailed to Copy post section into the kickstart File \n";
            exit $m_exitStatus;
        }
    }
}
# @throws: will exit if any error is found during execution
sub addPostSection()
{
    # Constants;
    my $POST_SUFFIX = "os-post-ks.cfg";

    # Local Variables
    my $m_packageFilePath;
    my $m_appendCommand;
    my $m_exitStatus;

    if($_=~$POST_SUFFIX)
    {
        $m_packageFilePath = "$File::Find::dir/$_";

        print "Appending post section file $m_packageFilePath to final kicktstart file\n";
        $m_appendCommand = "$CAT_COMMAND $m_packageFilePath >> $g_image_kickstart_path";
        system($m_appendCommand);
        $m_exitStatus = $? >> 8;
        if ($m_exitStatus != 0)
        {
            print "\nFailed to Copy post section into the kickstart File \n";
            exit $m_exitStatus;
        }
    }
}
sub addNTPSection(){
	 # Local Variables
    my $m_packageFilePath;
    my $m_appendCommand;
    my $m_exitStatus;
    if(/ntp-ks.cfg/)
    {
         $m_packageFilePath = "$File::Find::dir/$_";

        print "Appending post section file $m_packageFilePath to final kicktstart file\n";
        $m_appendCommand = "$CAT_COMMAND $m_packageFilePath >> $g_image_kickstart_path";
        system($m_appendCommand);
        $m_exitStatus = $? >> 8;
        if ($m_exitStatus != 0)
        {
            print "\nFailed to Copy post section into the kickstart File \n";
            exit $m_exitStatus;
        }
    }

	
}
sub addNFSSection(){
     # Local Variables
    my $m_packageFilePath;
    my $m_appendCommand;
    my $m_exitStatus;
    if(/nfs-ks.cfg/)
    {
	 $m_packageFilePath = "$File::Find::dir/$_";

        print "Appending post section file $m_packageFilePath to final kicktstart file\n";
        $m_appendCommand = "$CAT_COMMAND $m_packageFilePath >> $g_image_kickstart_path";
        system($m_appendCommand);
        $m_exitStatus = $? >> 8;
        if ($m_exitStatus != 0)
        {
            print "\nFailed to Copy post section into the kickstart File \n";
            exit $m_exitStatus;
        }
    }
}


sub addNISSection(){
     # Local Variables
    my $m_packageFilePath;
    my $m_appendCommand;
    my $m_exitStatus;
    if(/nis-ks.cfg/)
    {
	 $m_packageFilePath = "$File::Find::dir/$_";

        print "Appending post section file $m_packageFilePath to final kicktstart file\n";
        $m_appendCommand = "$CAT_COMMAND $m_packageFilePath >> $g_image_kickstart_path";
        system($m_appendCommand);
        $m_exitStatus = $? >> 8;
        if ($m_exitStatus != 0)
        {
            print "\nFailed to Copy post section into the kickstart File \n";
            exit $m_exitStatus;
        }
    }
}
sub addNetworkSection(){
    my $m_smallKickstartPath;

    if(/network-kickstart/)
    {
        $m_smallKickstartPath = "$File::Find::dir/$_" ;
        print "Appending smaller kickstart $m_smallKickstartPath to final kickstart file \n";
        open READ,"$m_smallKickstartPath" or die "Can not read $m_smallKickstartPath : $!";
        open WRITE,">> $g_image_kickstart_path" or die " cann't opent kickstartfile : $!\n";
        while(my $line = <READ>)
        {
		print WRITE $line;
        }
        close READ;
        close WRITE;
    }

}
# Purpose
# @throws: will exit if any error is found during execution
sub appendToKickstart()
{
    open OUT, ">> $g_image_kickstart_path" or die "Can't open kickstart file $g_image_kickstart_path $!";
    print OUT "</profile>";
    close OUT;
}

# Purpose
# Writes a string to a file
# @params: string to be appended to the file
# @throws: will exit if any error is found during execution
sub createAndAppendToKickstart()
{
    open OUT, "> $g_image_kickstart_path" or die "Can't open kickstart file $g_image_kickstart_path $!";
    print OUT "<?xml version=\"1\.0\"?>\n";
    print OUT "<!DOCTYPE profile SYSTEM \"/usr/share/autoinstall/dtd/profile\.dtd\">\n";
    print OUT "<profile xmlns=\"http://www\.suse\.com/1\.0/yast2ns\" xmlns:config=\"http://www\.suse\.com/1\.0/configns\">\n";
    close OUT;
}

sub changeInitrd(){
	my $bootUrl = @_[0];
	my $temp = $g_imageFolder."/temp";
	my $initrd = $g_imageFolder."/initrd";
	system("mkdir -p $temp");
	system("cp $initrd $temp/initrd\.gz");
	chdir "$temp";
	system("gunzip initrd\.gz");
	system("cpio -iv < initrd");
	open LINUX, ">>linuxrc\.config";
	open OS_DIR,"../OS_PATH" or die " Cann't update the os path : $!";
        my $m_temp_os_path = <OS_DIR>;
        chomp $m_temp_os_path;
        close OS_DIR;
	print LINUX "Install:	$m_temp_os_path\n";
	print LINUX "AutoYaST:	$bootUrl";
	close LINUX;
	system("rm -rf initrd");
	system("find \. -print | cpio -H newc -o -O initrd ");
	system("gzip initrd");
	system("mv initrd\.gz ../initrd_");
	chdir "..";
	system("rm -rf temp");
}
