# 
# $Header: suse_network-stage-directive.pl 29-jul-2007.23:32:25 rattipal Exp $
#
# network_stage.pl
# 
# Copyright (c) 2005, 2007, Oracle. All rights reserved.  
#
#    NAME
#      network_stage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rattipal    07/29/07 - dns servers fix
#    rattipal    09/28/06 - 
#    gaurgupt    09/01/06 - adding bonding
#    ssdas       08/02/06 - suse network directive
#    ssdas       07/27/06 - creating for suse 
#    adeb        05/25/06 - fix hostname change issue 
#    pshroff     08/05/05 - pshroff_stagepath_dirs
#    pshroff     06/30/05 - Creation
#
 

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

use LWP::Simple;
use strict;
require "$ENV{EMDROOT}/sysman/admin/scripts/provisioning/provisionCommon.pl";

#Staging directive for network profile component

main();

sub main()
{
    print "Creating Network Kickstart file\n";
   
    createAndAppendToPost();
    createAndAppendToKickstart();

    my $i = 0;
    my $deviceName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DeviceName");;
   

    my $maxDevices = 0;
    print "Device name is $deviceName";

     while(!($deviceName eq ""))
        {
                my $isBonding = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_IsBonding");
                my $dnsLine = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DNSServers");
                my @dnsServers = split /,/ , $dnsLine;
                my $noOfServers = $#dnsServers;

                print "Isbonding value is $isBonding\n";
                if($isBonding =~ /^yes/)
                {
                        $maxDevices = $maxDevices + 1;
                }

                my $j = 0;
                my $dnsEntry="";
                for($j = 0; $j < $noOfServers; $j++)
                {
                        $dnsEntry = "\necho \"nameserver $dnsServers[$j]\" >> /etc/resolv.conf\n";
                        appendToPost($dnsEntry);
                }

                $i = $i + 1;
                $deviceName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DeviceName");
                if($deviceName eq "")
                {
                        last;
                }
                print "Device name is $deviceName";
        }
        print "Max bonds is $maxDevices\n";


    $i = 0;
    $deviceName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DeviceName");
     while(!($deviceName eq ""))
        {
                print "Device name is $deviceName";
                my $isBonding = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_IsBonding");
                if($isBonding =~/^yes/)
                {
                        addBondingEntry($i, $deviceName, $maxDevices);
                }
                else
                {
                        addNonBondingEntry($i, $deviceName);
                }
                $i = $i + 1;
                $deviceName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DeviceName");
                if($deviceName eq "")
                {
                        last;
                }

        }
	#appendToPost("/etc/init\.d/network restart");
	closePost();


}


sub addBondingEntry()
{
        my ($i, $deviceName, $maxDevices) = @_;
        print "\nIn bonding with $i and $deviceName and $maxDevices\n";
        my $addrType = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_AddrType");

        my $optionsEntry = getOptionsEntry($i, $deviceName, $maxDevices);
        appendToPost($optionsEntry);

        my $slaveDevicesString = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_SlaveDevicesList");
        my @slaveDevices = split /,/ , $slaveDevicesString;
        my $noOfSlaves = $#slaveDevices;
        @slaveDevices = trim(@slaveDevices);
        print "List of slaves is @slaveDevices\n";
        my $j = 0;
        my @slaveEntries;
        for($j = 0; $j < $noOfSlaves; $j++)
        {
                $slaveEntries[$j] = getSlaveEntry($slaveDevices[$j], $deviceName);
                appendToPost($slaveEntries[$j]);
                if($slaveDevices[$j] eq "eth0")
                {
                        my $defaultGatewayEntry = getdefaultGateway($i,$slaveDevices[$j]);
                }
        }

        my $masterEntry = "";
        if($addrType =~ /ADDR_Dynamic/)
        {
                $masterEntry = getMasterEntryDynamic($i, $deviceName);
        }
        else
        {
                $masterEntry = getMasterStaticEntry($i, $deviceName);
              #  $masterEntry = getStaticEntry($i, $deviceName);
        }
        appendToPost($masterEntry);
}


sub getMasterStaticEntry()
{
        my ($i, $deviceName) = @_;
    	my $ipAddr = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_IPAddr");
        my $subnetMask = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_SubnetMask");

        my $filePrefix = "/etc/sysconfig/network/ifcfg-";
        my $staticEntry = "\nrm -rf $filePrefix$deviceName\ncat >> $filePrefix$deviceName <<EOF\nDEVICE=$deviceName\nIPADDR=$ipAddr\nNETMASK=$subnetMask\nSTARTMODE=onboot\nUSERCTL=no\nBOOTPROTO=none\nBONDING_MASTER=yes\n";

	my $slaveDevicesString = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_SlaveDevicesList");
        my @slaveDevices = split /,/ , $slaveDevicesString;
        my $noOfSlaves = #@slaveDevices; 
        @slaveDevices = trim(@slaveDevices);
	 my $j=0;
        for($j=0;$j < $noOfSlaves; $j++){
                $staticEntry = $staticEntry."BONDING_SLAVE$j=$slaveDevices[$j]\n";
        }
	$staticEntry = $staticEntry."EOF\n";


        print $staticEntry;
        return $staticEntry;
}

sub getMasterEntryDynamic()
{       
        my ($i, $deviceName) = @_;
	my $slaveDevicesString = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_SlaveDevicesList");
	my @slaveDevices = split /,/ , $slaveDevicesString; 
        my $noOfSlaves = #@slaveDevices; 
        @slaveDevices = trim(@slaveDevices);

        my $filePrefix = "/etc/sysconfig/network/ifcfg-";
        my $masterEntry = "\nrm -rf $filePrefix$deviceName\ncat >> $filePrefix$deviceName <<EOF\nDEVICE=$deviceName\nSTARTMODE=onboot\nUSERCTL=no\nBOOTPROTO=dhcp\nBONDING_MASTER=yes\n";
	my $j=0;
	for($j=0;$j < $noOfSlaves; $j++){
		$masterEntry = $masterEntry."BONDING_SLAVE$j=$slaveDevices[$j]\n";
	}
	$masterEntry = $masterEntry."EOF\n";
        print $masterEntry;
        return $masterEntry;
}


sub getSlaveEntry()
{
        my ($slaveDevice, $masterDevice) = @_;
        my $slaveEntry = "";    
        my $filePrefix = "/etc/sysconfig/network/ifcfg-";
        $slaveEntry = "\nrm -rf $filePrefix$slaveDevice\ncat >> $filePrefix$slaveDevice <<EOF \nDEVICE=$slaveDevice\nUSERCTL=no\nSTARTMODE=onboot\nMASTER=$masterDevice\nSLAVE=yes\nBOOTPROTO=none\nEOF";
        print $slaveEntry;
        return $slaveEntry;
}


        
sub trim { 
    for (@_) {
        s/^\s*//; # trim leading spaces
        s/\s*$//; # trim trailing spaces
    }
    return @_;
}

sub getOptionsEntry()
{
        my ($i, $deviceName, $maxDevices) = @_;

        my $primarySlave  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_PrimarySlave");
        my $primarySlaveEntry = "";
        if(!($primarySlave eq ""))
        {
                $primarySlaveEntry = " primary=$primarySlave ";
        }

        my $mode  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_BondingMode");
        my $modeEntry = "";
        if(!($mode eq ""))
        {
                $modeEntry = " mode=$mode ";
        }

        my $arpInterval  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_ARPInterval");
        my $arpIntervalEntry = "";
        if(!($arpInterval eq ""))
        {
                $arpIntervalEntry = " arp_interval=$arpInterval ";
        }

        my $arpTargets  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_ARPIPTarget");
        my $arpTargetsEntry = "";
        if(!($arpTargets eq ""))
        {
                $arpTargetsEntry = " arp_ip_target=$arpTargets ";
        }

        my $miiIntervalEntry = "";
        my $downDelayEntry = "";
        my $upDelayEntry = "";

        if(($arpInterval eq ""))
        {
                my $miiInterval  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_MIIInterval");

                if(!($miiInterval eq ""))
                {
                        $miiIntervalEntry = " miimon=$miiInterval ";
                }

                my $downDelay  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DownDelay");
                if(!($downDelay eq ""))
                {
                        $downDelayEntry = " downdelay=$downDelay ";
                }

                my $upDelay  = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_UpDelay");
                if(!($upDelay eq ""))
                {
                        $upDelayEntry = " updelay=$upDelay ";
                }
        }
	 my $maxBondsEntry = " max_bonds=$maxDevices ";

        my $switch = "\nif [ `uname -r | cut -b 1,2,3` = \"2.4\" ]\nthen\nconfigfile=\"/etc/modules.conf\"\nelse\nconfigfile=\"/etc/modprobe.conf\"\nfi\n";

        my $optionsEntry = "\n$switch\ncat >> \$configfile <<EOF\nalias $deviceName bonding\noptions $deviceName $primarySlaveEntry $modeEntry $arpIntervalEntry $arpTargetsEntry $miiIntervalEntry $downDelayEntry $upDelayEntry $maxBondsEntry \nEOF\n";
        print $optionsEntry;
        return $optionsEntry;

}



sub addNonBondingEntry()
{
        my ($i, $deviceName) = @_;
        print "\nIn bonding with $i and $deviceName\n";
        my $addrType = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_AddrType");
        my $networkEntry = "";
        if($addrType =~ /ADDR_Dynamic/)
        {
                $networkEntry = getDynamicEntry($i, $deviceName);
        }
        else
        {
                $networkEntry = getStaticEntry($i, $deviceName);
        }
        appendToPost($networkEntry);
        if($deviceName eq "eth0")
        {
                my $defaultGatewayEntry = getdefaultGateway($i,$deviceName);
                #appendToKickstart($defaultGatewayEntry,$deviceName);
        }
}

sub getdefaultGateway()
{
        my ($i,$deviceName)=@_;
	$deviceName = "eth0";
        print "In default gateway method with i = $i";
        my $addrType = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_AddrType");
	my $networkProfileEntry;
	if($addrType =~ /ADDR_Dynamic/){
		appendDynamicToKickstart($deviceName);
	}else{
        my $hostName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_Hostname");
    my $domainName = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DomainName");
    my $ipAddr = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_IPAddr");
    my $subnetMask = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_SubnetMask");
        my $gwLine = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_Gateways");
        my @gateways = split /,/ , $gwLine;
 my $dnsserver = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_DNSServers");	
        my @dnsservers = split /,/, $dnsserver;

        my $networkProfileEntry="network --device eth0 --bootproto static --ip $ipAddr --netmask $subnetMask --gateway $gateways[0] --hostname $hostName.$domainName\n";
	appendStaticToKickstart($deviceName,$hostName,$domainName,$ipAddr,$subnetMask,$gateways[0],$dnsservers[0]);

	}
        #return $networkProfileEntry;
}

sub getStaticEntry()
{
        my ($i, $deviceName) = @_;
    my $ipAddr = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_IPAddr");
        my $subnetMask = get_oraComponentProperty("NAME_NetworkConfig[$i].NAME_SubnetMask");

        my $filePrefix = "/etc/sysconfig/network/ifcfg-";
        my $staticEntry = "\nrm -rf $filePrefix$deviceName\ncat >> $filePrefix$deviceName <<EOF\nDEVICE=$deviceName\nIPADDR=$ipAddr\nNETMASK=$subnetMask\nSTARTMODE=onboot\nUSERCTL=no\nBOOTPROTO=none\nEOF\n";
        print $staticEntry;
        return $staticEntry;
}



sub getDynamicEntry()
{
        my ($i, $deviceName) = @_;
        my $filePrefix = "/etc/sysconfig/network/ifcfg-";
        my $dynamicEntry = "\nrm -rf $filePrefix$deviceName\ncat >> $filePrefix$deviceName <<EOF\nDEVICE=$deviceName\nSTARTMODE=onboot\nUSERCTL=no\nBOOTPROTO=dhcp\nEOF\n";
        print $dynamicEntry; 
        return $dynamicEntry;
}

sub appendToPost(){
    my ($entry)=@_;
        `pwd`;
    my $ksfilename="network-post-ks.cfg";
        chomp($ksfilename);
        print "\nWriting entry $entry to $ksfilename\n";

    open OUT, ">>$ksfilename" or die "Cannot find $ksfilename file $!" ;

    print OUT $entry;
        print "\nWritten\n";
    close OUT;
}



sub appendStaticToKickstart(){
	my($deviceName,$hostName,$domainName,$ipAddr,$subnetMask,$gateway,$dnsserver) = @_;
        open OUT,">>network-kickstart" or die "Cann't open network kickstart file";
	
        print OUT "<networking>\n";
        print OUT "<dns>\n";
        print OUT "<dhcp_hostname config:type=\"boolean\">false</dhcp_hostname>\n";
        print OUT "<dhcp_resolv config:type=\"boolean\">false</dhcp_resolv>\n";
        print OUT "<domain>$domainName</domain>\n";
        print OUT "<hostname>$hostName</hostname>\n";
	print OUT "<nameservers config:type=\"list\">\n";
	my $temp_var;
	chomp($dnsserver);
	my @m_nameserver_list = split(/,/,$dnsserver);
	foreach $temp_var (@m_nameserver_list){
		print OUT "<nameserver>$temp_var</nameserver>\n";
	}
	print OUT "</nameservers>\n";
	print OUT "<searchlist config:type=\"list\">\n<search>$domainName</search>\n</searchlist>\n";
	print OUT "</dns>\n";
	print OUT "<interfaces config:type=\"list\">\n";
        print OUT "<interface>\n";
        print OUT "<bootproto>static</bootproto>\n";
	print OUT "<device>$deviceName</device>\n";
	print OUT "<ipaddr>$ipAddr</ipaddr>\n";
	print OUT "<netmask>$subnetMask</netmask>\n";
	print OUT "<startmode>onboot</startmode>\n";
	print OUT "</interface>\n";
        print OUT "</interfaces>\n";
	print OUT "<routing>\n";
        print OUT "<ip_forward config:type=\"boolean\">false</ip_forward>\n";
        print OUT "<routes config:type=\"list\">\n";
	chomp($gateway);
	my @m_gateways_list = split(/,/,$gateway);
	my $m_gateways_list_len = @m_gateways_list;
	print OUT "<route>\n<destination>default</destination>\n<device>-</device>\n";
	print OUT "<gateway>@m_gateways_list[0]</gateway>\n<netmask>-</netmask>\n";
	print OUT "</route>\n";
	my $i;
	for ($i=1;$i<$m_gateways_list_len;$i++){
		print OUT "<route>\n";
		print OUT "<gateway>@m_gateways_list[$i]</gateway>\n";
		print OUT "</route>\n";
	}
	print OUT "</routes>\n";
	print OUT "</routing>\n";
        print OUT "</networking>\n";

        close OUT;
    appendFinalToKickstart();


}

sub appendFinalToKickstart(){
        open OUT,">>network-kickstart" or die "Cann't open network kickstart file";
	print OUT "<runlevel>\n";
        print OUT "<default>3</default>\n";
        print OUT "<services config:type=\"list\">\n";
        print OUT "<service/>\n";
        print OUT "</services>\n";
        print OUT "</runlevel>\n";
        #print OUT "</configure>\n";
	close OUT;
}
sub appendDynamicToKickstart(){
	my ($m_deviceName) = @_;
        open OUT,">>network-kickstart" or die "Cann't open network kickstart file";
	print OUT "<networking>\n";
        print OUT "<dns>\n";
        print OUT "<dhcp_hostname config:type=\"boolean\">true</dhcp_hostname>\n";
        print OUT "<dhcp_resolv config:type=\"boolean\">true</dhcp_resolv>\n";
        print OUT "<domain>local</domain>\n";
        print OUT "<hostname>linux</hostname>\n";
        print OUT "</dns>\n";
        print OUT "<interfaces config:type=\"list\">\n";
        print OUT "<interface>\n";
        print OUT "<bootproto>dhcp</bootproto>\n";
        print OUT "<device>$m_deviceName</device>\n";
        print OUT "<startmode>onboot</startmode>\n";
        print OUT "</interface>\n";
        print OUT "</interfaces>\n";
        print OUT "<routing>\n";
        print OUT "<ip_forward config:type=\"boolean\">false</ip_forward>\n";
        print OUT "<routes config:type=\"list\"/>\n";
        print OUT "</routing>\n";
        print OUT "</networking>\n";

	close OUT;
    appendFinalToKickstart();
}

sub createAndAppendToPost(){
     my $ksfilename="network-post-ks.cfg";

    open OUT, ">$ksfilename" or die "Can find kickstart file $!" ;
    #print OUT "<post-scripts config:type=\"list\">\n";
    print OUT "<script>\n";
    print OUT "<interpreter>shell</interpreter>\n";
    print OUT "<source><![CDATA[\n";
    print OUT "#!/bin/sh\n";
    print OUT "rm -rf /etc/sysconfig/network/ifcfg-eth-id*\n";
   # print OUT "<configure>\n";
   # print OUT "<start_autofs config:type=\"boolean\">false</start_autofs>\n"; 

    close OUT;
}
sub closePost(){
    my $ksfilename="network-post-ks.cfg";

    open OUT, ">>$ksfilename" or die "Can find kickstart file $!" ;


    print OUT "]]>\n";
        print OUT "</source>\n";
        print OUT "</script>\n";
        #print OUT "</post-scripts>\n";
   close OUT;
}
sub createAndAppendToKickstart()
{
    my $ksfilename="network-kickstart";
    
    open OUT, ">$ksfilename" or die "Can find kickstart file $!" ;

   # print OUT "<configure>\n";
   # print OUT "<start_autofs config:type=\"boolean\">false</start_autofs>\n"; 
    
    close OUT;
}


