#
# Copyright (c) 2001, 2004, Oracle. All rights reserved.  
#
#  $Id: sUtilities.pm 14-sep-2004.19:49:11 ajdsouza Exp $ 
#
#
# NAME  
# sUtilities.pm
#
# DESC 
# Platform generic utility subroutines 
#
# NOTES
#
# MODIFIED      (MM/DD/YY)
# ajdsouza	04/06/04 - Created
#
#

package storage::sUtilities;

require v5.6.1;

use strict;
use warnings;
use locale;
use File::Basename;
use File::Spec::Functions;
use storage::Utilities;

BEGIN
{

 use POSIX qw(locale_h);

 my $clocale='C';

 for ( qw ( LC_ALL LC_COLLATE LC_CTYPE LC_TIME LC_NUMERIC LC_MESSAGES LC_MONETARY LANG LANGUAGE ) )
 {
   $ENV{$_}=$clocale;
 }

 setlocale(LC_ALL,$clocale) or warn " Failed to set locale to $clocale \n ";

}

#-----------------------------------------------------------------------------------------
# Global package variable to hold sub name
our $AUTOLOAD;

#-------------------------------------------------------------------
# Variables with package scope
#-------------------------------------------------------------------
#------------------------------------------------------------------------------------
# Static Configuration
#------------------------------------------------------------------------------------
my %config;
#------------------------------------------------------------------------------------
# exports
#---------------------------------------------------------------------------------------
# No exports

#-----------------------------------------------------------------------------------------
# subs declared
#-----------------------------------------------------------------------------------------

#-----------------------------------------------------------------------------------------
# FUNCTION : AUTOLOAD
#
# DESC 
# If sub is not defined here then look for it in sUtilities.pm
#
# ARGUMENTS
# Args to be passed to the sub
#
#-----------------------------------------------------------------------------------------
sub AUTOLOAD
{
  my ( @args ) = @_;
    
  my $sub = $AUTOLOAD;
    
  $sub =~ s/.*:://;	
    
  my $sub_path = "storage::Utilities::$sub";

  my $sub_ref = \&$sub_path;

  return &$sub_ref(@args);

}

1; #Returning a true value at the end of the module
