@echo off
setlocal
if (%1)==() goto usage

rem  ##################################################
rem  # initilize my environment local to this bat file

set RET=
call %ORACLE_HOME%\javavm\demo\common.bat
if not (%RET%)==(1) (
   echo - Fatal: %ORACLE_HOME%\javavm\demo\common.bat failed!
   goto end
)
set MAKE_CLASSPATH=%JDK12_CLASSPATH%
set NCMP_CLASS=ncomp/Test
set NCMP_ZIP=ncompDemo.zip
set GRANT_SQL=grant.sql

rem ##################################################
rem # act on user request

if (%1)==(codegen) call :codegen & goto end
if (%1)==(all) call :all & goto end
if (%1)==(compile) call :compile  & goto end
if (%1)==(grant) call :grant  & goto end
if (%1)==(ncomp) call :ncomp  & goto end
if (%1)==(run) call :run  & goto end
if (%1)==(clean) call :clean  & goto end
echo - Fatal: Unknown option %1 & goto usage
goto end

rem ##################################################
rem # option all
:all

call :compile
if not exist %NCMP_ZIP% goto :eof

call :grant
if not exist grantstamp goto :eof

call :ncomp
if not exist ncompstamp goto :eof

call :run

goto :eof

rem ##################################################
rem # option codegen
:codegen

set JASPER_MAIN=oracle.aurora.ncomp.jasper.Main 
set JASPER_ARGS=-d ncomp -env oracle.aurora.ncomp.javac.ExtensibleBatchEnvironment -notree -replaceJavaSource 
set MACROSJSL=ncomp\Macros
set TESTJSL=ncomp\Test
set MAKE_CLASSPATH=%MAKE_CLASSPATH%;%ORACLE_HOME%\javavm\lib\ncomp.zip

echo + Building %MACROSJSL%.java and %MACROSJSL%.class ...
if not exist %MACROSJSL%.jsl echo - Fatal: %MACROSJSL%.jsl not found & goto :eof
if exist %MACROSJSL%.java del %MACROSJSL%.java
java -classpath %MAKE_CLASSPATH% %JASPER_MAIN% %JASPER_ARGS% %MACROSJSL%.jsl
if not exist %MACROSJSL%.java echo - Fatal: code generation failed, %MACROSJSL%.java not found & goto :eof
if exist %MACROSJSL%.class del %MACROSJSL%.class
javac -g -classpath %MAKE_CLASSPATH% %MACROSJSL%.java
if not exist %MACROSJSL%.class echo - Fatal: compilation failed, %MACROSJSL%.class not found & goto :eof

echo + Building %TESTJSL%.java and %TESTJSL%.class ...
if not exist %TESTJSL%.jsl echo - Fatal: %TESTJSL%.jsl not found & goto :eof
if exist %TESTJSL%.java del %TESTJSL%.java
java -classpath %MAKE_CLASSPATH% %JASPER_MAIN% %JASPER_ARGS% %TESTJSL%.jsl
if not exist %TESTJSL%.java echo - Fatal: code generation failed, %TESTJSL%.java not found & goto :eof
if exist %TESTJSL%.class del %TESTJSL%.class
javac -g -classpath %MAKE_CLASSPATH% %TESTJSL%.java
if not exist %TESTJSL%.class echo - Fatal: compilation failed, %TESTJSL%.class not found & goto :eof

echo + Code generation succeeded, continuing with 'all' ...
call :all

goto :eof

rem ##################################################
rem # option compile
:Compile
echo + Compiling ...

if exist %NCMP_ZIP% del %NCMP_ZIP% 

javac -g -classpath %MAKE_CLASSPATH% %NCMP_CLASS%.java
if not exist %NCMP_CLASS%.class (
   echo - Fatal: javac did not generate %NCMP_CLASS%.class
   goto :eof
)

zip %NCMP_ZIP% %NCMP_CLASS%.class
if not exist %NCMP_ZIP% (
   echo - Fatal: Failed to generate %NCMP_ZIP%
   goto :eof
)

goto :eof


rem ##################################################
rem # option grant
:grant

echo + Granting ...

if exist grantstamp (
  echo +  Already granted.
  goto :eof
)

if not exist %GRANT_SQL% (
  echo - Fatal: %GRANT_SQL% does not exist
  goto :eof
)

sqlplus /nolog @%GRANT_SQL%
echo . > grantstamp

goto :eof

rem ##################################################
rem # option ncomp
:ncomp
echo + Ncomping ...

if exist ncompstamp del /q ncompstamp

if not exist %NCMP_ZIP% (
   echo - Fatal:  %NCMP_ZIP% not found
   goto :eof
)

if not exist tmp (
  md tmp
)

cd tmp
copy ..\%NCMP_ZIP% . > nul
call ncomp -load -force -verbose -u scott/tiger %NCMP_ZIP% > ncomp.log 2>&1
cd ..
echo . > ncompstamp

goto :eof


rem ##################################################
rem # option run
:run
echo + Running ...
if not exist run.txt (
  echo - Fatal: run.txt not found
  goto : eof
)

call ojvmjava -u scott/tiger@ < run.txt

goto :eof

rem ##################################################
rem # option clean
:clean
echo + Cleaning ...
if exist *.class        del /q *.class
if exist ncomp\*.class  del /q ncomp\*.class
if exist %NCMP_ZIP%     del /q %NCMP_ZIP%
if exist *stamp         del /q *stamp
if exist tmp\*.*        rd /q /s tmp

goto :eof

rem ##################################################
rem # usage
:usage
echo +
echo + usage: 
echo +     makeit [options]
echo +     options can be one of: all compile grant ncomp run clean [codegen]
echo +     Note: codegen is optional and implies 'all'
echo +
echo + example:
echo +    makeit all
echo +

goto end

rem ##################################################
rem # End

:end
endlocal
set RET=%RET%

