#  $Header: emdb/sysman/admin/scripts/db/dg/dgPerf.pl /st_emdbsa_11.2/2 2009/02/24 09:50:41 ngade Exp $
#
# Copyright (c) 2002, 2009, Oracle and/or its affiliates.All rights reserved. 
#
#    NAME
#      dgPerf.pl
#
#    DESCRIPTION
#      This metric test determines performance metric information for a Data Guard configuration. .
#
#    OUTPUT:
#	For 10.2:
#	DB Object Name, Failover Time (secs), LAG Time (secs), Apply Rate (KB/sec)
#	Potential Data Loss (secs), Status 
#
#    NOTES
#      DBI handles automatic error checking.
#
#    MODIFIED   (MM/DD/YY)
#      ngade     02/17/09 - Code slap 10.2.0.5.0 -> 11.2 round 2
#      gallison  11/12/08 - Pass version to getMetrics102
#      sjconnol  09/12/08 - Allow non-SYSDBA
#      rimmidi   05/04/08 - Code slap from 11GC to 10.2.0.5
#      ngade     11/12/07 - fix bug 6524798
#      ngade     05/25/07 - fix bug 5951219
#      sjconnol  08/15/06 - 11g changes
#      gallison  09/01/05 - Fix lag calculations 
#      gallison  03/23/05 - Update with new names 
#      gallison  02/25/05 - Rename metrics
#      gallison  01/05/05 - Fix table name 
#      gallison  11/03/04 - gallison_dg_perf2
#      gallison  09/22/04 - 10.2 support 
#

use strict;
use DBI;
use DBI qw(:sql_types);

require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/dg/dgutil.pl";

# RaiseError
$SIG{__DIE__} = \&handleError;
# PrintError
$SIG{__WARN__} = \&handleWarning;

# Trace the target name.
EMD_PERL_DEBUG("Database target=$ENV{EM_TARGET_NAME}, role=$ENV{EM_TARGET_ROLE}");

# This metric supports 10.2 and up
my $db_version = $ENV{VersionCategory};
verify_dbversion_102($db_version);

# Connect to the instance.
my %stdinArgs = get_stdinvars();
my $username = $stdinArgs{EM_TARGET_USERNAME};
my $password = $stdinArgs{EM_TARGET_PASSWORD};
my $role = $ENV{EM_TARGET_ROLE};
my $mode = 0;
if($role =~ /SYSDBA/i)
{
  $mode = 2;
}

my $address = $ENV{EM_TARGET_ADDRESS};
my $lda = DBI->connect('dbi:Oracle:', "$username@".$address, "$password", {ora_session_mode => $mode, PrintError => 0, RaiseError => 1});

# Register this test once we're connected.
register_metric_call($lda);

my($fot,$lag,$pdl,$blocks) = getMetrics102($lda,$db_version); 
my $result = "em_result=$fot|$lag|$pdl|$blocks\n";
EMD_PERL_DEBUG("$result");
print $result;

$lda->disconnect;

exit 0;

