Rem  Copyright (c) Oracle Corporation 1999 - 2007. All Rights Reserved.
Rem
Rem    NAME
Rem      load_es.sql
Rem
Rem    DESCRIPTION
Rem      Install Spanish version of Application Express applications
Rem
Rem    NOTES
Rem      Assumes the Application Express owner.
Rem      Note that the NLS_LANG must be properly set in the environment
Rem      prior to running this script or character set conversion can take place
Rem      The character set portion of NLS_LANG must be set to AL32UTF8
Rem         Example: AMERICAN_AMERICA.AL32UTF8
Rem 
Rem    REQUIRMENTS
Rem      - Oracle 9.2.0.2 or greater, 10g
Rem      - Web Listener with mod_plsql Apache modules
Rem
Rem    Arguments:
Rem      None
Rem
Rem    MODIFIED    (MM/DD/YYYY)
Rem      jkallman   08/29/2003 - Created 
Rem      jkallman   11/07/2003 - Set sgid
Rem      jkallman   12/29/2003 - Remove exit statement (Bug 3343818)
Rem      jkallman   09/23/2005 - Added conditional logic for XE 
Rem      jkallman   09/29/2005 - Unconditionally load 4550, remove 4200
Rem      jkallman   03/27/2006 - Modify update of flow_version (Bug 5113472)
Rem      jkallman   01/15/2007 - Added 4400
Rem      jkallman   10/04/2007 - Remove XE-specifics

prompt .  ____   ____           ____        ____ 
prompt . /    \ |    \   /\    /     |     /    
prompt .|      ||    /  /  \  |      |    |    
prompt .|      ||---    ----  |      |    |---

prompt .|      ||   \  /    \ |      |    |  
prompt . \____/ |    \/      \ \____ |____ \____
prompt .
prompt . Application Express Hosted Development Service Installation.
prompt .........................................................


set define '^'
set concat on
set concat .
set verify off
set termout off
spool off
set termout on

prompt Install Application Express applications
begin
    wwv_flow_security.g_security_group_id := 10;
end;
/
@@f4411_es.sql
@@f4000_es.sql
@@f4050_es.sql
@@f4155_es.sql
@@f4300_es.sql
@@f4350_es.sql
@@f4500_es.sql
@@f4550_es.sql
@@f4400_es.sql
@@f4700_es.sql

prompt Adjust instance settings
-- Update image prefix, owner, release of installed translated applications
begin
    wwv_flow_security.g_security_group_id := 10;
    --
    for c1 in (select flow_image_prefix, owner
                 from wwv_flows
                where security_group_id = 10
                  and id = 4000) loop
        update wwv_flows
           set flow_image_prefix = c1.flow_image_prefix,
                owner = c1.owner,
                flow_version = (select '&PRODUCT_NAME. ' || wwv_flows_release from dual where rownum = 1)
          where id in (4001,4051,4156,4301,4351,4401,4412,4501,4551,4701);
        update wwv_flows set flow_version = '&PRODUCT_NAME. ' where id = 4551;
        commit;
        exit;
    end loop;--c1
end;
/
