Rem
Rem $Header: catmgw.sql 15-jun-2006.13:40:06 chall Exp $
Rem
Rem catmgw.sql
Rem
Rem Copyright (c) 2001, 2006, Oracle. All rights reserved.  
Rem
Rem  NAME
Rem    catmgw.sql - catalog/install script for Oracle Messaging Gateway
Rem
Rem  DESCRIPTION
Rem    Creates database dictionary and schema objects for the Oracle
Rem    Messaging Gateway (MGW) component. This creates the tables, views,
Rem    packages, object types, synonyms, and so on.
Rem
Rem  NOTES
Rem    Run this script AS SYSDBA
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  chall       06/15/06 - use RDBMS version for MGW component version 
Rem  chall       10/29/02 - RDBMS 10iR1 upgrade/downgrade mods
Rem  chall       10/28/02 - UPDATE ANY TABLE so OJMS can set queue LOB field
Rem
Rem ==========================================================================

-- register MGW component
execute -
 dbms_registry.loading('MGW', 'Messaging Gateway', 'mgwi_reg.validate_mgw')

--
-- MGW_ADMINISTRATOR_ROLE
--
-- Messaging Gateway administrator role. This role allows users to execute
-- administration package and object types, access gateway views, etc.
--

create role MGW_ADMINISTRATOR_ROLE not identified;

grant AQ_ADMINISTRATOR_ROLE to MGW_ADMINISTRATOR_ROLE;

-- Grant the admin role to select_catalog_role and execute_catalog_role
-- so that users with generic data dictionary access can also access the
-- the MGW data dictionary (or at least that visible to MGW adminstrators).
--
-- Note: It's unclear what we should grant to select(execute)_catalog_role.
-- Heterogeneous Services (caths.sql) just grants its admin role to these
-- two roles while AQ (catqueue.sql) seems to grant various views, packages, 
-- etc. directly to these roles.
--
-- For now, we will follow HS lead and just grant our adminstrator role.
-- Assume not needed for any objects granted to PUBLIC. These roles will
-- not be sufficient to accesss our internal tables, packages, types.
--
grant mgw_administrator_role to select_catalog_role;
grant mgw_administrator_role to execute_catalog_role;

--
-- MGW_AGENT_ROLE
--
-- This role is used to grant privileges to the database user the gateway 
-- agent will use for connections back to the database. Additional privileges
-- may be added by subsequent scripts that load/create MGW database objects.
--

create role MGW_AGENT_ROLE;

-- privileges via other roles
grant MGW_ADMINISTRATOR_ROLE to MGW_AGENT_ROLE;
grant AQ_ADMINISTRATOR_ROLE to MGW_AGENT_ROLE;

-- privileges on non-Gateway objects
grant SELECT ANY TABLE to MGW_AGENT_ROLE;
grant execute on dbms_pipe to MGW_AGENT_ROLE;
grant select on sys.dba_transformations to MGW_AGENT_ROLE;

-- note: grant UPDATE ANY TABLE so OJMS can update the LOB field of a 
-- queue table using an OJMS ADT (AQ$_JMS_xxx) payload. May be able to
-- get rid of this if/when OJMS switches to temporary LOBs

grant UPDATE ANY TABLE to MGW_AGENT_ROLE;

--
-- Gateway Agent Library
-- Note: Moved to mgwlib.sql file for RDBMS 10iR1, so that file, rather 
-- than catmgw.sql, can be used as the "class C" file by porting group.
--

@@mgwlib

--
-- Tables, types specs.
--
-- Be careful with the dependency when changing the load order; for example,
-- some tables have a dependency on type sys.mgw_properties.
--

-- type specs
@@mgwtype
@@mgwityp.plb

-- tables
@@mgwtable

--
-- Package specs, type bodies, package bodies, views.
-- Perform post-install tasks (create AQ log queues, notify queues, etc.)
--

@@mgwlod

--
-- All done. Indicate MGW component loaded and perform validation
--

execute dbms_registry.loaded('MGW')
execute mgwi_reg.validate_mgw

Rem === End file: catmgw.sql =================================================
