Rem
Rem $Header: mgwadm.sql 12-oct-2006.14:05:28 chall Exp $
Rem
Rem mgwadm.sql
Rem
Rem Copyright (c) 2001, 2006, Oracle. All rights reserved.  
Rem
Rem  NAME
Rem    mgwadm.sql - MGW admin package specification
Rem
Rem  DESCRIPTION
Rem    Specification for the Oracle Messaging Gateway administration package.
Rem
Rem  NOTES
Rem    This script should be run from CATMGW.SQL (AS SYSDBA).
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  chall       10/05/06 - support JDBC thin driver
Rem  chall       09/29/06 - add set_option, remove_option procedures
Rem  chall       09/27/06 - support for agent java property apis
Rem  chall       03/08/06 - propagation job support (11g feature) 
Rem  chall       12/13/05 - multiple agent feature 
Rem  chall       10/04/04 - rename JMS_UNIFIED_CONNECTION to JMS_CONNECTION 
Rem  chall       09/30/04 - add ERRN_NO_JMS_QUEUE_DOMAIN 
Rem  chall       09/28/04 - rename JMS_UNIVERSAL_CONNECTION to 
Rem                         JMS_UNIFIED_CONNECTION 
Rem  chall       05/19/04 - MSMQ support 
Rem  chall       12/16/03 - remove obsolete (commented out) MSMQ code 
Rem  chall       07/31/03 - rename constant ERRN_CANNOT_START_BAD_STATUS
Rem  chall       07/14/03 - RAC shutdown/startup trigger issues (bug 2999689)
Rem  chall       01/17/03 - default subscriber latency (bug 2754884)
Rem  chall       12/11/02 - more cleanup_gateway action constants
Rem  chall       10/30/02 - fix comments
Rem  chall       09/23/02 - add set_log_event
Rem  chall       09/19/02 - added ERRN_CANNOT_ALTER_PROP error code
Rem  chall       09/11/02 - add JMS_xxx_CONNECTION constants
Rem  chall       09/05/02 - more error codes
Rem  chall       08/28/02 - API mods needed for 10iR1
Rem
Rem ==========================================================================

--
-- dbms_mgwadm
--
-- The Messaging Gateway administration package.
--

CREATE OR REPLACE PACKAGE dbms_mgwadm AS 

  -- Gateway propagation types:
  --
  -- OUTBOUND_PROPAGATION : AQ to non-Oracle propagation
  -- INBOUND_PROPAGATION  : non-Oracle to AQ propagation
  --
  OUTBOUND_PROPAGATION   CONSTANT BINARY_INTEGER := 1;
  INBOUND_PROPAGATION    CONSTANT BINARY_INTEGER := 2;

  -- Queue domain types:
  --
  -- DOMAIN_QUEUE : A Queue destination. A JMS queue (point-to-point) would
  --                be classified as a Queue.
  -- DOMAIN_TOPIC : A Topic destination. A JMS topic (publish-subscriber)
  --                would be classified as a Topic.
  --
  DOMAIN_QUEUE          CONSTANT BINARY_INTEGER := 1;
  DOMAIN_TOPIC          CONSTANT BINARY_INTEGER := 2;

  -- MQSeries interface types:
  --
  -- MQSERIES_BASE_JAVA_INTERFACE : MQSeries Base Java interface is used.
  --
  -- Note: JMS_QUEUE_CONNECTION, JMS_TOPIC_CONNECTION are also valid
  -- interface types so be careful when about value used if add more types.
  --
  MQSERIES_BASE_JAVA_INTERFACE    CONSTANT BINARY_INTEGER := 1;

  -- JMS constants:
  --
  -- JMS_QUEUE_CONNECTION  : JMS Queue connection used
  -- JMS_TOPIC_CONNECTION  : JMS Topic connection used
  -- JMS_CONNECTION        : JMS unified messaging model used
  --
  --
  -- Note: Be careful with values to avoid conflicts since these values may
  -- be used in different ways. For example, JMS_xxx_CONNECTION are valid
  -- interface types for MQSeries link.
  --
  JMS_QUEUE_CONNECTION      CONSTANT BINARY_INTEGER := 8;
  JMS_TOPIC_CONNECTION      CONSTANT BINARY_INTEGER := 9;
  JMS_CONNECTION            CONSTANT BINARY_INTEGER := 10;

  -- Transactional nature of links/queues:
  --
  -- TRANSACTIONAL     : Operations performed in context of a transaction.
  -- NON_TRANSACTIONAL : Operations performed outside of a transaction.
  --
  TRANSACTIONAL         CONSTANT BINARY_INTEGER := 1;
  NON_TRANSACTIONAL     CONSTANT BINARY_INTEGER := 2;

  -- Shutdown modes:
  --
  -- SHUTDOWN_NORMAL    : normal shutdown
  -- SHUTDOWN_IMMEDIATE : immediate shutdown
  -- SHUTDOWN_DATABASE  : database instance shutdown (internal use only)
  -- SHUTDOWN_ROGUE     : rogue agent shutdown (internal use only)
  --
  SHUTDOWN_NORMAL       CONSTANT BINARY_INTEGER := 0;
  SHUTDOWN_IMMEDIATE    CONSTANT BINARY_INTEGER := 1;
  SHUTDOWN_DATABASE     CONSTANT BINARY_INTEGER := 2;
  SHUTDOWN_ROGUE        CONSTANT BINARY_INTEGER := 3;

  -- Agent log levels:
  --
  BASIC_LOGGING          CONSTANT BINARY_INTEGER := 0;
  TRACE_LITE_LOGGING     CONSTANT BINARY_INTEGER := 1;
  TRACE_HIGH_LOGGING     CONSTANT BINARY_INTEGER := 2;
  TRACE_DEBUG_LOGGING    CONSTANT BINARY_INTEGER := 3;

  -- Gateway clean up actions (for cleanup_gateway procedure):
  --
  -- CLEAN_STARTUP_STATE : Clean gateway startup/shutdown state. Allows
  -- gateway to be started after agent crash or some other abnormal event.
  --
  -- CLEAN_LOG_QUEUES : Clean log queues for all configured links.
  --
  -- RESET_SUB_MISSING_LOG_REC : Recover MGW subscriber that has failed
  -- due to missing log record.
  --
  -- RESET_SUB_MISSING_MESSAGE : Recover MGW subscriber that has failed
  -- due to missing persistent (source) message.
  --
  CLEAN_STARTUP_STATE         CONSTANT BINARY_INTEGER := 1;
  CLEAN_LOG_QUEUES            CONSTANT BINARY_INTEGER := 2;
  RESET_SUB_MISSING_LOG_REC   CONSTANT BINARY_INTEGER := 3;
  RESET_SUB_MISSING_MESSAGE   CONSTANT BINARY_INTEGER := 4;

  -- Force parameter constants.
  NO_FORCE              CONSTANT BINARY_INTEGER := 0;
  FORCE                 CONSTANT BINARY_INTEGER := 1;

  -- Constant to indicate that a value should be preserved (not changed)
  NO_CHANGE             CONSTANT VARCHAR2(16) := '<<!#NOcHAngE#!>>';

  -- Reserved property names. Typically used to alter the contents of a
  -- MGW_PROPERTIES object.
  --
  MGWPROP_PREFIX      CONSTANT VARCHAR2(10) := 'MGWPROP$_';
  MGWPROP_REMOVE      CONSTANT VARCHAR2(20) := 'MGWPROP$_REMOVE';
  MGWPROP_REMOVE_ALL  CONSTANT VARCHAR2(20) := 'MGWPROP$_REMOVE_ALL';

  -- Name of default agent.
  DEFAULT_AGENT          CONSTANT VARCHAR2(13) := 'DEFAULT_AGENT';

  -- Target types for set_option, remove_option.
  -- 1-5 reserved for agent-related things
  AGENT_JAVA_PROP     CONSTANT PLS_INTEGER := 1;
  MSGLINK_OPTION      CONSTANT PLS_INTEGER := 6;
  JOB_OPTION          CONSTANT PLS_INTEGER := 7;

  -- Database JDBC connection types; create_agent, alter_agent
  JDBC_OCI            CONSTANT VARCHAR2(10) := 'oci';
  JDBC_THIN           CONSTANT VARCHAR2(10) := 'thin';

  --
  -- Error Numbers
  --
  -- Reserved MGW error range: -32800..-32999
  --
  ERRN_INTERNAL_ERROR           CONSTANT BINARY_INTEGER := -32800;
  ERRN_INVALID_PARAMETER        CONSTANT BINARY_INTEGER := -32801;
  ERRN_VALUE_MUST_BE            CONSTANT BINARY_INTEGER := -32802;
  ERRN_CANNOT_ALTER_PARAMETER   CONSTANT BINARY_INTEGER := -32803;
  ERRN_INVALID_NAME_FORMAT      CONSTANT BINARY_INTEGER := -32804;
  ERRN_IDENTIFIER_TOO_LONG      CONSTANT BINARY_INTEGER := -32805;
  ERRN_VALUE_TOO_LONG           CONSTANT BINARY_INTEGER := -32806;
  ERRN_MSGLINK_EXISTS           CONSTANT BINARY_INTEGER := -32807;
  ERRN_MSGLINK_NOT_EXIST        CONSTANT BINARY_INTEGER := -32808;
  ERRN_FQUEUE_REGISTERED        CONSTANT BINARY_INTEGER := -32809;
  ERRN_FQUEUE_NOT_REGISTERED    CONSTANT BINARY_INTEGER := -32810;
  ERRN_SUBSCRIBER_EXISTS        CONSTANT BINARY_INTEGER := -32811;
  ERRN_SUBSCRIBER_NOT_EXIST     CONSTANT BINARY_INTEGER := -32812;
  ERRN_SCHEDULE_EXISTS          CONSTANT BINARY_INTEGER := -32813;
  ERRN_SCHEDULE_NOT_EXIST       CONSTANT BINARY_INTEGER := -32814;
  ERRN_LINK_REFBY_FQUEUE        CONSTANT BINARY_INTEGER := -32815;
  ERRN_FQUEUE_REFBY_SUB_SCHED   CONSTANT BINARY_INTEGER := -32816;
  ERRN_LINK_LOGQ_NOT_SET        CONSTANT BINARY_INTEGER := -32817;
  ERRN_AQ_QUEUE_NOT_EXIST       CONSTANT BINARY_INTEGER := -32818;
  ERRN_AQ_NORMAL_QUEUE          CONSTANT BINARY_INTEGER := -32819;
  ERRN_SUBS_EXCEPTIONQ_LINK     CONSTANT BINARY_INTEGER := -32820;
  ERRN_SUBS_EXCEPTIONQ_PAYLOAD  CONSTANT BINARY_INTEGER := -32821;
  ERRN_SUBS_REMOVE_PENDING      CONSTANT BINARY_INTEGER := -32822;
  ERRN_SUBSCRIBER_SET_EXISTS    CONSTANT BINARY_INTEGER := -32823;
  ERRN_SCHEDULE_SET_EXISTS      CONSTANT BINARY_INTEGER := -32824;
  ERRN_GATEWAY_NOT_STARTED      CONSTANT BINARY_INTEGER := -32825;
  ERRN_GATEWAY_ALREADY_STARTED  CONSTANT BINARY_INTEGER := -32826;
  ERRN_SHUTDOWN_GATEWAY         CONSTANT BINARY_INTEGER := -32827;
  ERRN_RUNNING_GATEWAY          CONSTANT BINARY_INTEGER := -32828;
  ERRN_STARTING_NO_SHUTDOWN     CONSTANT BINARY_INTEGER := -32829;
  ERRN_GATEWAY_RESULT           CONSTANT BINARY_INTEGER := -32830;
  ERRN_ADMIN_LOCK_TIMEOUT       CONSTANT BINARY_INTEGER := -32831;
  ERRN_ADMIN_LOCK_FAILED        CONSTANT BINARY_INTEGER := -32832;
  ERRN_ADMIN_UNLOCK_FAILED      CONSTANT BINARY_INTEGER := -32833;
  ERRN_AGENT_USER_NOT_SET       CONSTANT BINARY_INTEGER := -32834;
  ERRN_DB_USER_NOT_EXIST        CONSTANT BINARY_INTEGER := -32835;
  ERRN_DB_USER_NEEDS_ROLE       CONSTANT BINARY_INTEGER := -32836;
  ERRN_INVALID_CONFIG_STATE     CONSTANT BINARY_INTEGER := -32837;
  ERRN_MAX_PROP_EXCEEDED        CONSTANT BINARY_INTEGER := -32838;
  ERRN_RESERVED_PROP_NAME       CONSTANT BINARY_INTEGER := -32839;
  ERRN_NULL_PROP_NAME           CONSTANT BINARY_INTEGER := -32840;
  ERRN_INVALID_PROP_VALUE       CONSTANT BINARY_INTEGER := -32841;
  ERRN_CANNOT_ALTER_PROP        CONSTANT BINARY_INTEGER := -32842;
  ERRN_OUT_OF_RANGE             CONSTANT BINARY_INTEGER := -32843;
  ERRN_OUT_OF_VALUES            CONSTANT BINARY_INTEGER := -32844;
  ERRN_AGENT_ALREADY_RUNNING    CONSTANT BINARY_INTEGER := -32845;
  ERRN_CANNOT_START_BAD_STATUS  CONSTANT BINARY_INTEGER := -32846;
  ERRN_PLATFORM_NOT_SUPPORTED   CONSTANT BINARY_INTEGER := -32847;
  ERRN_NO_JMS_QUEUE_DOMAIN      CONSTANT BINARY_INTEGER := -32848;
  ERRN_LINKED_PARAMETERS        CONSTANT BINARY_INTEGER := -32849;
  ERRN_AGENT_NOT_EXIST          CONSTANT BINARY_INTEGER := -32850;
  ERRN_AGENT_EXISTS             CONSTANT BINARY_INTEGER := -32851;
  ERRN_AGENT_REFBY_LINK         CONSTANT BINARY_INTEGER := -32852;
  ERRN_PROPJOB_NOT_EXIST        CONSTANT BINARY_INTEGER := -32853;
  ERRN_PROPJOB_EXISTS           CONSTANT BINARY_INTEGER := -32854;
  ERRN_PROPJOB_REMOVE_PENDING   CONSTANT BINARY_INTEGER := -32855;
  ERRN_PROPJOB_OP_NOT_SUPPORTED CONSTANT BINARY_INTEGER := -32856;
  ERRN_PROPJOB_SET_EXISTS       CONSTANT BINARY_INTEGER := -32857;

  --
  -- startup
  --
  -- Start the Messaging Gateway.
  --
  PROCEDURE startup (
    instance IN BINARY_INTEGER DEFAULT 0,
    force    IN BINARY_INTEGER DEFAULT dbms_mgwadm.NO_FORCE );

  PROCEDURE startup (
    agent_name IN VARCHAR2 );

  --
  -- shutdown
  --
  -- Shutdown the Messaging Gateway.
  --
  PROCEDURE shutdown ( 
    sdmode IN BINARY_INTEGER DEFAULT dbms_mgwadm.SHUTDOWN_NORMAL );

  PROCEDURE shutdown (
    agent_name IN VARCHAR2 );

  --
  -- cleanup_gateway
  --
  -- Cleans up Messaging Gateway. This procedure attempts to perform clean up
  -- or recovery tasks that may be needed due to gateway agent crash or some
  -- other abnormal situation.
  --
  PROCEDURE cleanup_gateway ( 
    action IN BINARY_INTEGER,
    sarg   IN VARCHAR2 DEFAULT NULL );

  PROCEDURE cleanup_gateway ( 
    agent_name IN VARCHAR2,
    action     IN BINARY_INTEGER,
    sarg       IN VARCHAR2 DEFAULT NULL );

  --
  -- set_log_level
  --
  -- Dynamically alters the Message Gateway agent logging level.
  --
  PROCEDURE set_log_level (
    log_level IN BINARY_INTEGER );

  PROCEDURE set_log_level (
    agent_name IN VARCHAR2,
    log_level  IN BINARY_INTEGER );

  --
  -- set_log_event
  --
  -- Dynamically alters the Message Gateway agent logging events.
  --
  PROCEDURE set_log_event (
    log_event IN INTEGER,
    component IN INTEGER );

  PROCEDURE set_log_event (
    agent_name IN VARCHAR2,
    log_event  IN INTEGER,
    component  IN INTEGER );

  --
  -- create_agent
  --
  -- Create a Messaging Gateway named agent.
  --
  PROCEDURE create_agent ( 
    agent_name  IN VARCHAR2,
    username    IN VARCHAR2 DEFAULT NULL,
    password    IN VARCHAR2 DEFAULT NULL,
    database    IN VARCHAR2 DEFAULT NULL,
    conntype    IN VARCHAR2 DEFAULT DBMS_MGWADM.JDBC_OCI,
    max_memory  IN PLS_INTEGER DEFAULT 64,
    max_threads IN PLS_INTEGER DEFAULT 1,
    service     IN VARCHAR2 DEFAULT NULL,
    initfile    IN VARCHAR2 DEFAULT NULL,
    comment     IN VARCHAR2 DEFAULT NULL );

  --
  -- remove_agent
  --
  -- Removes a Messaging Gateway named agent.
  --
  PROCEDURE remove_agent ( 
    agent_name IN VARCHAR2 );

  --
  -- alter_agent
  --
  -- Alter Messaging Gateway agent parameters.
  --
  PROCEDURE alter_agent ( 
    agent_name  IN VARCHAR2,
    username    IN VARCHAR2 DEFAULT DBMS_MGWADM.NO_CHANGE,
    password    IN VARCHAR2 DEFAULT DBMS_MGWADM.NO_CHANGE,
    database    IN VARCHAR2 DEFAULT DBMS_MGWADM.NO_CHANGE,
    conntype    IN VARCHAR2 DEFAULT DBMS_MGWADM.NO_CHANGE,
    max_memory  IN PLS_INTEGER DEFAULT NULL,
    max_threads IN PLS_INTEGER DEFAULT NULL,
    service     IN VARCHAR2 DEFAULT DBMS_MGWADM.NO_CHANGE,
    initfile    IN VARCHAR2 DEFAULT DBMS_MGWADM.NO_CHANGE,
    comment     IN VARCHAR2 DEFAULT DBMS_MGWADM.NO_CHANGE );

  PROCEDURE alter_agent ( 
    max_connections IN BINARY_INTEGER DEFAULT NULL,
    max_memory      IN BINARY_INTEGER DEFAULT NULL,
    max_threads     IN BINARY_INTEGER DEFAULT NULL,
    service         IN VARCHAR2 DEFAULT DBMS_MGWADM.NO_CHANGE );

  --
  -- db_connect_info
  --
  -- Configure database connection information for the Message Gateway agent.
  --
  PROCEDURE db_connect_info ( 
    username IN VARCHAR2,
    password IN VARCHAR2,
    database IN VARCHAR2 DEFAULT NULL );

  --
  -- create_msgsystem_link
  --
  -- Creates a link for a MQSeries messaging system.
  --
  PROCEDURE create_msgsystem_link (
    linkname   IN VARCHAR2,
    properties IN sys.mgw_mqseries_properties,
    options    IN sys.mgw_properties DEFAULT NULL,
    comment    IN VARCHAR2 DEFAULT NULL );

  PROCEDURE create_msgsystem_link (
    linkname   IN VARCHAR2,
    agent_name IN VARCHAR2,
    properties IN sys.mgw_mqseries_properties,
    options    IN sys.mgw_properties DEFAULT NULL,
    comment    IN VARCHAR2 DEFAULT NULL );

  --
  -- create_msgsystem_link
  --
  -- Creates a link for a TIB/Rendezvous messaging system.
  --
  PROCEDURE create_msgsystem_link (
    linkname   IN VARCHAR2,
    properties IN sys.mgw_tibrv_properties,
    options    IN sys.mgw_properties DEFAULT NULL,
    comment    IN VARCHAR2 DEFAULT NULL );

  PROCEDURE create_msgsystem_link (
    linkname   IN VARCHAR2,
    agent_name IN VARCHAR2,
    properties IN sys.mgw_tibrv_properties,
    options    IN sys.mgw_properties DEFAULT NULL,
    comment    IN VARCHAR2 DEFAULT NULL );

  --
  -- create_msgsystem_link
  --
  -- Creates a link for a Microsoft MSMQ messaging system.
  --
  PROCEDURE create_msgsystem_link (
    linkname   IN VARCHAR2,
    properties IN sys.mgw_msmq_properties,
    options    IN sys.mgw_properties DEFAULT NULL,
    comment    IN VARCHAR2 DEFAULT NULL );

  PROCEDURE create_msgsystem_link (
    linkname   IN VARCHAR2,
    agent_name IN VARCHAR2,
    properties IN sys.mgw_msmq_properties,
    options    IN sys.mgw_properties DEFAULT NULL,
    comment    IN VARCHAR2 DEFAULT NULL );

  --
  -- remove_msgsystem_link
  --
  -- Removes a messaging system link.
  --
  PROCEDURE remove_msgsystem_link (
    linkname IN VARCHAR2 );

  --
  -- alter_msgsystem_link
  --
  -- Alters properties of MQSeries messaging system link.
  --
  PROCEDURE alter_msgsystem_link (
    linkname   IN VARCHAR2,
    properties IN sys.mgw_mqseries_properties,
    options    IN sys.mgw_properties DEFAULT NULL,
    comment    IN VARCHAR2 DEFAULT dbms_mgwadm.NO_CHANGE );

  --
  -- alter_msgsystem_link
  --
  -- Alters properties of TIB/Rendezvous messaging system link.
  --
  PROCEDURE alter_msgsystem_link (
    linkname   IN VARCHAR2,
    properties IN sys.mgw_tibrv_properties,
    options    IN sys.mgw_properties DEFAULT NULL,
    comment    IN VARCHAR2 DEFAULT dbms_mgwadm.NO_CHANGE );

  --
  -- alter_msgsystem_link
  --
  -- Alters properties of Microsoft MSMQ messaging system link.
  --
  PROCEDURE alter_msgsystem_link (
    linkname   IN VARCHAR2,
    properties IN sys.mgw_msmq_properties,
    options    IN sys.mgw_properties DEFAULT NULL,
    comment    IN VARCHAR2 DEFAULT dbms_mgwadm.NO_CHANGE );

  --
  -- register_foreign_queue
  --
  -- Registers a non-Oracle queue entity in Messaging Gateway.
  --
  PROCEDURE register_foreign_queue (
    name           IN VARCHAR2,
    linkname       IN VARCHAR2,
    provider_queue IN VARCHAR2 DEFAULT NULL,
    domain         IN INTEGER DEFAULT NULL,
    options        IN sys.mgw_properties DEFAULT NULL,
    comment        IN VARCHAR2 DEFAULT NULL );

  --
  -- unregister_foreign_queue
  --
  -- Removes a non-Oracle queue entity in Messaging Gateway.
  --
  PROCEDURE unregister_foreign_queue (
    name     IN VARCHAR2,
    linkname IN VARCHAR2 );

  --
  -- add_subscriber
  --
  -- Adds a subscriber used to consume messages from a source queue for
  -- propagation to a destination.
  --
  PROCEDURE add_subscriber (
    subscriber_id    IN VARCHAR2,
    propagation_type IN BINARY_INTEGER,
    queue_name       IN VARCHAR2,
    destination      IN VARCHAR2,
    rule             IN VARCHAR2 DEFAULT NULL,
    transformation   IN VARCHAR2 DEFAULT NULL,
    exception_queue  IN VARCHAR2 DEFAULT NULL,
    options          IN sys.mgw_properties DEFAULT NULL );

  --
  -- remove_subscriber
  --
  -- Removes a subscriber used to consume messages from a source queue for
  -- propagation to a destination.
  --
  PROCEDURE remove_subscriber (
    subscriber_id IN VARCHAR2,
    force         IN BINARY_INTEGER DEFAULT dbms_mgwadm.NO_FORCE );

  --
  -- alter_subscriber
  --
  -- Alters the parameters of a subscriber used to consume messages 
  -- from a source queue for propagation to a destination.
  --
  PROCEDURE alter_subscriber (
    subscriber_id   IN VARCHAR2,
    rule            IN VARCHAR2 DEFAULT dbms_mgwadm.NO_CHANGE,
    transformation  IN VARCHAR2 DEFAULT dbms_mgwadm.NO_CHANGE,
    exception_queue IN VARCHAR2 DEFAULT dbms_mgwadm.NO_CHANGE,
    options         IN sys.mgw_properties DEFAULT NULL );

  --
  -- reset_subscriber
  --
  -- Resets the propagation error state for a subscriber.
  --
  PROCEDURE reset_subscriber (
    subscriber_id IN VARCHAR2 );

  --
  -- schedule_propagation
  --
  -- Schedules propagation of messages from a source to destination.
  --
  PROCEDURE schedule_propagation (
    schedule_id      IN VARCHAR2,
    propagation_type IN BINARY_INTEGER,
    source           IN VARCHAR2,
    destination      IN VARCHAR2,
    start_time       IN DATE DEFAULT SYSDATE,
    duration         IN NUMBER DEFAULT NULL,
    next_time        IN VARCHAR2 DEFAULT NULL,
    latency          IN NUMBER DEFAULT NULL );

  --
  -- unschedule_propagation
  --
  -- Removes a propagation schedule.
  --
  PROCEDURE unschedule_propagation (
    schedule_id IN VARCHAR2 );

  --
  -- alter_propagation_schedule
  --
  -- Alters parameters of a propagation schedule.
  --
  PROCEDURE alter_propagation_schedule (
    schedule_id IN VARCHAR2,
    duration    IN NUMBER DEFAULT NULL,
    next_time   IN VARCHAR2 DEFAULT NULL,
    latency     IN NUMBER DEFAULT NULL );

  --
  -- enable_propagation_schedule
  --
  -- Enables a propagation schedule.
  --
  PROCEDURE enable_propagation_schedule (
    schedule_id IN VARCHAR2 );

  --
  -- disable_propagation_schedule
  --
  -- Disables a propagation schedule.
  --
  PROCEDURE disable_propagation_schedule (
    schedule_id IN VARCHAR2 );

  --
  -- create_job
  --
  -- Creates a propagation job.
  --
  PROCEDURE create_job (
    job_name         IN VARCHAR2,
    propagation_type IN PLS_INTEGER,
    source           IN VARCHAR2,
    destination      IN VARCHAR2,
    rule             IN VARCHAR2 DEFAULT NULL,
    transformation   IN VARCHAR2 DEFAULT NULL,
    exception_queue  IN VARCHAR2 DEFAULT NULL,
    poll_interval    IN PLS_INTEGER DEFAULT NULL,
    options          IN SYS.MGW_PROPERTIES DEFAULT NULL,
    enabled          IN BOOLEAN DEFAULT TRUE,
    comments         IN VARCHAR2 DEFAULT NULL );

  --
  -- remove_job
  --
  -- Removes a properties job.
  --
  PROCEDURE remove_job (
    job_name IN VARCHAR2,
    force    IN BINARY_INTEGER DEFAULT DBMS_MGWADM.NO_FORCE );

  --
  -- alter_job
  --
  -- Alters the properties of a propagation job.
  --
  PROCEDURE alter_job (
    job_name        IN VARCHAR2,
    rule            IN VARCHAR2 DEFAULT dbms_mgwadm.NO_CHANGE,
    transformation  IN VARCHAR2 DEFAULT dbms_mgwadm.NO_CHANGE,
    exception_queue IN VARCHAR2 DEFAULT dbms_mgwadm.NO_CHANGE,
    poll_interval   IN PLS_INTEGER DEFAULT 0,
    options         IN SYS.MGW_PROPERTIES DEFAULT NULL,
    comments        IN VARCHAR2 DEFAULT dbms_mgwadm.NO_CHANGE );

  --
  -- reset_job
  --
  -- Resets the propagation error state of a propagation job.
  --
  PROCEDURE reset_job (
    job_name IN VARCHAR2 );

  --
  -- enable_job
  --
  -- Enables a propagation job.
  --
  PROCEDURE enable_job (
    job_name IN VARCHAR2 );

  --
  -- disable_job
  --
  -- Disables a propagation job.
  --
  PROCEDURE disable_job (
    job_name IN VARCHAR2 );

  PROCEDURE set_option (
    target_type  IN PLS_INTEGER,
    target_name  IN VARCHAR2,
    option_name  IN VARCHAR2,
    option_value IN VARCHAR2,
    encrypted    IN BOOLEAN DEFAULT FALSE );

  PROCEDURE remove_option (
    target_type IN PLS_INTEGER,
    target_name IN VARCHAR2,
    option_name IN VARCHAR2 );

END dbms_mgwadm;
/

grant execute on dbms_mgwadm to mgw_administrator_role;

create or replace public synonym dbms_mgwadm for dbms_mgwadm;

rem ===== END OF FILE ========================================================
