Rem
Rem $Header: mgwd901.sql 07-feb-2002.17:47:02 chall Exp $
Rem
Rem mgwd901.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      mgwd901.sql - MGW downgrade script
Rem
Rem    DESCRIPTION
Rem      Downgrade Messaging Gateway from MGW/RDBMS Release 9.2.0 to 9.0.1.
Rem
Rem    NOTES
Rem      This script must be run as SYSDBA.
Rem
Rem      This script must be run from the MGW admin directory of the Oracle
Rem      9.0.1 release ($ORACLE_HOME/mgw/admin).
Rem
Rem      This script is intended to be run in the context of a 9.0.1 database
Rem      after it has been downgraded from 9.2.0. It should be run ONLY if the
Rem      Messaging Gateway component (MGW) was loaded into the 9.2.0 database.
Rem      It does not need to be run if the MGW component was never loaded.
Rem
Rem      The Messaging Gateway must be shut down before running this script.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chall       02/07/02 - chall_bug-2218028
Rem    chall       02/07/02 - remove PROMPT lines.
Rem    chall       02/07/02 - Created
Rem
rem ==========================================================================

set serveroutput on

-- verify Messaging Gateway is loaded

whenever sqlerror exit

declare
  v_null CHAR(1);
begin
  -- verify SYS.MGW$_GATEWAY table loaded
  select NULL into v_null from obj$ o, user$ u
    where u.user# = o.owner# AND 
          u.name = 'SYS' AND o.name = 'MGW$_GATEWAY' AND
          o.type# = 2;
exception
  when NO_DATA_FOUND then
    raise_application_error(-20000, 
                            'Messaging Gateway is not loaded');
end;
/

-- verify MGW agent is not running

whenever sqlerror exit

declare
  v_status INTEGER;
begin
  -- verify NOT_STARTED status
  select agent_status into v_status from sys.mgw$_gateway;
  if v_status != 0 then
    raise_application_error(-20000, 
                            'Messaging Gateway agent must be shut down');
  end if;
end;
/

-- update packages

whenever sqlerror continue

@@mgwmesg.plb
@@dbmsmgw
@@mgwiadm.plb
@@mgwadmb.plb
@@mgwiadmb.plb

set serveroutput off
