Rem
Rem $Header: mgwd920.sql 05-nov-2002.16:58:33 chall Exp $
Rem
Rem mgwd920.sql
Rem
Rem Copyright (c) 2002, Oracle Corporation.  All rights reserved.  
Rem
Rem  NAME
Rem    mgwd920.sql - MGW downgrade script (9.2.0.x reload script)
Rem
Rem  DESCRIPTION
Rem    Downgrade Messaging Gateway from MGW/RDBMS Release 10.0.0 to 9.2.0.
Rem
Rem    This is effectively the MGW component reload script (mgwrelod.sql)
Rem    for RDBMS 9.2.0.x release. As of RDBMS 10.0.0, a mgwdNNN.sql script
Rem    should no longer be needed.
Rem
Rem  NOTES
Rem    This script must be run AS SYSDBA.
Rem
Rem    This script must be run from the MGW admin directory of the Oracle
Rem    9.2.0.x release ($ORACLE_HOME/mgw/admin).
Rem
Rem    This script is intended to be run in the context of a 9.2.0.x 
Rem    database after it has been downgraded from 10.0.0. It should be run
Rem    ONLY if the Messaging Gateway component (MGW) was loaded for the 
Rem    10.0.0 database. It does not need to be run if the MGW component
Rem    was never loaded.
Rem
Rem    Messaging Gateway agent must be shut down before running this script.
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  chall       11/05/02 - chall_bug-2606429
Rem  chall       11/05/02 - Created
Rem
Rem ==========================================================================

set serveroutput on

Rem =======================================================================
Rem Some validation before doing the reload.
Rem a) Verify MGW is even loaded.
Rem b) Verify MGW agent is shut down.
Rem =======================================================================

-- verify Messaging Gateway is loaded
--
whenever sqlerror exit

declare
  v_null CHAR(1);
begin
  -- verify SYS.MGW$_GATEWAY table loaded
  select NULL into v_null from obj$ o, user$ u
    where u.user# = o.owner# AND 
          u.name = 'SYS' AND o.name = 'MGW$_GATEWAY' AND
          o.type# = 2;
exception
  when NO_DATA_FOUND then
    raise_application_error(-20000, 
                            'Messaging Gateway is not loaded');
end;
/

-- verify MGW agent is not running
--
whenever sqlerror exit

declare
  v_status INTEGER;
begin
  -- verify NOT_STARTED status
  select agent_status into v_status from sys.mgw$_gateway;
  if v_status != 0 then
    raise_application_error(-20000, 
                            'Messaging Gateway agent must be shut down');
  end if;
end;
/

whenever sqlerror continue

Rem =======================================================================
Rem Reload MGW package specs, type bodies, package bodies, and views.
Rem Tables and type specs should have already been set to that used for
Rem MGW/RDBMS 9.2.x by the mgwe920.sql script (run in context of 10.0.0).
Rem =======================================================================

execute -
 dbms_registry.loading('MGW', 'Messaging Gateway', 'mgwi_reg.validate_mgw')

@@dbmsmgw
@@mgwadm
@@mgwnfy.plb
@@mgwiadm.plb

@@mgwadmb.plb
@@mgwmsgb.plb
@@mgwtypeb.plb
@@mgwiadmb.plb
@@mgwiadtb.plb
@@mgwaqd.plb
@@mgwaqdb.plb
@@mgwireg.plb

@@mgwview.plb

-- note: for RDBMS 9.2.x releases, the MGW version was tied to RDBMS version
-- so preserve that behavior for this 9.2 reload
begin
  dbms_registry.loaded('MGW', 
                       dbms_registry.release_version,
--                       '9.2.0.0.0',
                       'Messaging Gateway Release ' 
                         || dbms_registry.release_version 
                         || ' - ' || dbms_registry.release_status);
end;
/

execute mgwi_reg.validate_mgw;

set serveroutput off

Rem === End file: mgwd920.sql ================================================
