Rem
Rem $Header: mgw/src/plsql/admin/mgwdbmig.sql /mgw_main/8 2008/08/24 09:37:36 chall Exp $
Rem
Rem mgwdbmig.sql
Rem
Rem Copyright (c) 2002, 2008, Oracle. All rights reserved.
Rem
Rem  NAME
Rem    mgwdbmig.sql - MGW component migration script
Rem
Rem  DESCRIPTION
Rem    Migration script to upgrade the Messaging Gateway (MGW) component.
Rem    This script is called from $ORACLE_HOME/rdbms/admin/cmpdbmig.sql
Rem    in context of the "new" database during a RDBMS upgrade.
Rem
Rem  NOTES
Rem    This script must be run AS SYSDBA.
Rem
Rem    MGW scripts located at: $ORACLE_HOME/mgw/admin
Rem
Rem    MGW first available starting with RDBMS 9.0.1.
Rem
Rem    For direct 9.0.1->10.0.0 upgrade, a registry entry will have been
Rem    added for MGW component, but with the validation routine set to null.
Rem    This script should specify one when it calls dbms_registry.upgrading.
Rem    The MGW registry entry is added by dbms_registry_sys.populate 
Rem    (called by $OH/rdbms/a0900010.sql).
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  chall       08/24/08 - 11.2 upgrade
Rem  chall       06/15/06 - use RDBMS version for MGW component version 
Rem  chall       03/30/06 - add check for upgrade from 10.2.0 
Rem  chall       09/17/04 - bugfix 3895383; reload dblink and library objects 
Rem  chall       05/14/04 - add 10gR2 migration hooks 
Rem  chall       11/26/02 - call dbms_registry.check_server_instance
Rem  chall       10/31/02 - upgrade to 10i
Rem  chall       02/07/02 - chall_bug-2218028
Rem  chall       02/07/02 - Created
Rem
Rem ==========================================================================

whenever sqlerror exit
execute dbms_registry.check_server_instance
whenever sqlerror continue

-- specify validate routine since one not yet set if 9.0.1->10.1.0 upgrade
execute -
 dbms_registry.upgrading('MGW', 'Messaging Gateway', 'mgwi_reg.validate_mgw')

-- set up component script file variable
COLUMN :script_name NEW_VALUE comp_file NOPRINT
VARIABLE script_name VARCHAR2(60)

-- decide which dictionary upgrade script to run
BEGIN

  IF substr(dbms_registry.version('MGW'),1,5) = '9.0.1' THEN
    :script_name := '@mgwu901.sql';
  ELSIF substr(dbms_registry.version('MGW'),1,5) = '9.2.0' THEN
    :script_name := '@mgwu920.sql';
  ELSIF substr(dbms_registry.version('MGW'),1,6) = '10.1.0' THEN
    :script_name := '@mgwu101.sql';
  ELSIF substr(dbms_registry.version('MGW'),1,6) = '10.2.0' THEN
    :script_name := '@mgwu102.sql';
  ELSIF substr(dbms_registry.version('MGW'),1,6) = '11.1.0' THEN
    :script_name := '@mgwu111.sql';
  ELSE
    :script_name := dbms_registry.nothing_script;
  END IF;

END;
/

-- run the dictionary upgrade script
SELECT :script_name FROM DUAL;
@&comp_file

-- reload database link and library objects
@@mgwlib

-- create new tables (noop for existing tables)
@@mgwtable

-- load current package specs, type bodies, package bodies, views
-- standard/common "post-install" tasks
@@mgwlod

execute dbms_registry.upgraded('MGW')
execute mgwi_reg.validate_mgw

Rem === End file: mgwdbmig.sql ===============================================
