Rem
Rem $Header: mgwlib.sql 15-sep-2004.17:43:02 chall Exp $
Rem
Rem mgwlib.sql
Rem
Rem Copyright (c) 2002, 2004, Oracle. All rights reserved.  
Rem
Rem  NAME
Rem    mgwlib.sql - MGW agent library load script
Rem
Rem  DESCRIPTION
Rem    Creates schema object for the MGW shared library.
Rem
Rem    This file is likely to be treated as a "class C" file by porting
Rem    group. For example, the location of the shared library may be 
Rem    different for the various platforms
Rem
Rem  NOTES
Rem    This script must be run from CATMGW.SQL, AS SYSDBA.
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  chall       09/15/04 - library name changed to oramgwagent.dll on Windows 
Rem  chall       11/12/02 - comment out debug output
Rem  chall       11/05/02 - chall_bug-2606429
Rem  chall       10/29/02 - Created
Rem
Rem ==========================================================================

--
-- Gateway Agent Library
--
-- The gateway agent is run as an external procedure. The AGENT clause causes
-- it to be run from a database link other than the server; i.e., the default
-- server agent (extproc) will not be used to run the gateway agent.
--
-- Note: AGENT clause not supported on WINNT so dynamic SQL will be used
-- for system dependent SQL statement.
--
--set serveroutput on

create public database link mgw_agent using 'MGW_AGENT';

declare
  v_ps	      VARCHAR2(64);
  v_cursor    INTEGER;
  v_statement VARCHAR2(512);
  v_ret       INTEGER;
begin
  v_cursor := dbms_sql.open_cursor;
  v_ps := dbms_utility.port_string;
  IF (v_ps like '%WIN_NT%') THEN
    v_statement := 'create or replace library dbms_mgwadm_agent_lib as ' ||
                 '''${ORACLE_HOME}\bin\oramgwagent.dll'''; 
  ELSE
    v_statement := 'create or replace library dbms_mgwadm_agent_lib as ' ||
                 '''${ORACLE_HOME}/lib/libmgwagent.so'' agent ''MGW_AGENT''';
  END IF;

  --%dbms_output.put_line(v_statement);
  dbms_sql.parse(v_cursor, v_statement, dbms_sql.v7);
  v_ret := dbms_sql.execute(v_cursor);
  dbms_sql.close_cursor(v_cursor);
exception
  when others then
    -- Close the cursor, then raise the error again
    dbms_sql.close_cursor(v_cursor);
    raise;
end;
/

Rem ===== END OF FILE ========================================================
