Rem
Rem $Header: mgwlod.sql 21-nov-2006.14:25:31 chall Exp $
Rem
Rem mgwlod.sql
Rem
Rem Copyright (c) 2002, 2006, Oracle. All rights reserved.  
Rem
Rem  NAME
Rem    mgwlod.sql - MGW component load script
Rem
Rem  DESCRIPTION
Rem    The main load script for MGW component. Encapsulates the steps 
Rem    needed to load MGW package specs, type bodies, package bodies,
Rem    views, and so on. It does _not_ load the MGW tables or type specs.
Rem    This script may also perform certain "post-install" actions.
Rem
Rem    This script may be called from:
Rem    1) catmgw.sql, when MGW is first installed.
Rem    2) mgwdbmig.sql, as part of a database upgrade.
Rem    3) mgwrelod.sql, as part of a database downgrade.
Rem
Rem  NOTES
Rem    This script must be run AS SYSDBA.
Rem
Rem  MODIFIED   (MM/DD/YY)
Rem  chall       11/21/06 - load mgwi_crypto package spec and body
Rem  chall       07/13/06 - placement of trigger creation 
Rem  chall       06/15/06 - load views after specs been loaded 
Rem  chall       07/29/03 - no STARTUP trigger for 10i (bug 2999689)
Rem  chall       12/03/02 - create database STARTUP and SHUTDOWN triggers
Rem  chall       11/12/02 - load mgwireg.plb (vs mgwireg.sql)
Rem  chall       11/05/02 - chall_bug-2606429
Rem  chall       11/05/02 - Created
Rem
Rem ==========================================================================

Rem ========================================================================
Rem Load component objects
Rem ========================================================================

-- package specs
@@mgwmsg
@@mgwadm
@@mgwnfy.plb
@@mgwaqd.plb
@@mgwiadm.plb
@@mgwicry.plb

-- views
@@mgwview

-- type, package bodies
@@mgwtypeb.plb
@@mgwityb.plb
@@mgwmsgb.plb
@@mgwadmb.plb
@@mgwnfyb.plb
@@mgwaqdb.plb
@@mgwiadmb.plb
@@mgwicryb.plb

@@mgwireg.plb

-- database SHUTDOWN trigger
create or replace trigger mgw_dbshutdown_trig
 before shutdown on database
call mgwi_admin.db_shutdown_trigger
/

Rem ========================================================================
Rem
Rem Other "post-install" setup/configuration tasks.
Rem
Rem These tasks may be run when MGW is first installed (via catmgw.sql),
Rem as part of a database upgrade (via mgwdbmig.sql), or as part of MGW
Rem component reload during a database downgrade. Any tasks which are not
Rem safe to do in all of these situations should be moved to another script,
Rem for example, to a component "a" script.
Rem
Rem ========================================================================

-- create aq log queues, notification queue, Scheduler objects, etc.
-- these are a NOOP if already been done; e.g., for reload or downgrade cases
begin
  mgwi_admin.task(MGWI_ADMIN.TSK_MGW_INSTALL);
end;
/

Rem === End file: mgwlod.sql =================================================
